/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.validation;

import com.horizen.SidechainHistory;
import com.horizen.block.Ommer;
import com.horizen.block.OmmersContainer;
import com.horizen.block.SidechainBlock;
import com.horizen.block.SidechainBlockHeader;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.consensus.ConsensusEpochAndSlot;
import com.horizen.consensus.FullConsensusEpochInfo;
import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.StakeConsensusEpochInfo;
import com.horizen.consensus.TimeToEpochSlotConverter;
import com.horizen.consensus.package$;
import com.horizen.validation.HistoryBlockValidator;
import com.horizen.validation.SidechainBlockSlotInFutureException;
import com.horizen.validation.SidechainBlockSlotInFutureException$;
import com.horizen.vrf.VrfOutput;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0005\u000b\u0001EAQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005B!BQA\u0010\u0001\u0005\n}BQA\u0011\u0001\u0005\n\rCQa\u0012\u0001\u0005\n!CQ\u0001\u0019\u0001\u0005\n\u0005Da\u0001\u001a\u0001\u0005\u00021)\u0007\u0002CA.\u0001\u0011\u0005A\"!\u0018\u0003%\r{gn]3ogV\u001ch+\u00197jI\u0006$xN\u001d\u0006\u0003\u00171\t!B^1mS\u0012\fG/[8o\u0015\tia\"A\u0004i_JL'0\u001a8\u000b\u0003=\t1aY8n\u0007\u0001\u0019B\u0001\u0001\n\u00199A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003)I!a\u0007\u0006\u0003+!K7\u000f^8ss\ncwnY6WC2LG-\u0019;peB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005kRLGNC\u0001\"\u0003\u0019\u00198m\u001c:fq&\u00111E\b\u0002\u000e'\u000e|'/\u001a=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0003CA\r\u0001\u0003!1\u0018\r\\5eCR,GcA\u00152qA\u0019!\u0006\f\u0018\u000e\u0003-R!a\b\u000b\n\u00055Z#a\u0001+ssB\u00111cL\u0005\u0003aQ\u0011A!\u00168ji\")!G\u0001a\u0001g\u0005)!\r\\8dWB\u0011AGN\u0007\u0002k)\u0011!\u0007D\u0005\u0003oU\u0012abU5eK\u000eD\u0017-\u001b8CY>\u001c7\u000eC\u0003:\u0005\u0001\u0007!(A\u0004iSN$xN]=\u0011\u0005mbT\"\u0001\u0007\n\u0005ub!\u0001E*jI\u0016\u001c\u0007.Y5o\u0011&\u001cHo\u001c:z\u0003Q1\u0018\r\\5eCR,w)\u001a8fg&\u001c(\t\\8dWR\u0019a\u0006Q!\t\u000bI\u001a\u0001\u0019A\u001a\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002/Y\fG.\u001b3bi\u0016tuN\\$f]\u0016\u001c\u0018n\u001d\"m_\u000e\\Gc\u0001\u0018E\r\")Q\t\u0002a\u0001g\u0005ia/\u001a:jM&,GM\u00117pG.DQ!\u000f\u0003A\u0002i\nqB^3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u0005]%3\u0006\fC\u0003K\u000b\u0001\u00071*\u0001\fwKJLg-[3e\u00052|7m\u001b+j[\u0016\u001cH/Y7q!\ta5K\u0004\u0002N#6\taJ\u0003\u00023\u001f*\u0011\u0001\u000bI\u0001\u0005G>\u0014X-\u0003\u0002S\u001d\u0006)!\t\\8dW&\u0011A+\u0016\u0002\n)&lWm\u001d;b[BT!A\u0015(\t\u000b]+\u0001\u0019A&\u0002)A\f'/\u001a8u\u00052|7m\u001b+j[\u0016\u001cH/Y7q\u0011\u0015IV\u00011\u0001[\u00035!\u0018.\\3D_:4XM\u001d;feB\u00111LX\u0007\u00029*\u0011Q\fD\u0001\nG>t7/\u001a8tkNL!a\u0018/\u00031QKW.\u001a+p\u000bB|7\r[*m_R\u001cuN\u001c<feR,'/A\fwKJLg-\u001f+j[\u0016\u001cH/Y7q\u0013:4U\u000f^;sKR\u0019aFY2\t\u000b)3\u0001\u0019A&\t\u000be2\u0001\u0019\u0001\u001e\u0002\u0019Y,'/\u001b4z\u001f6lWM]:\u0015\u0017927\u000e];\u0002\f\u0005m\u0011Q\u0004\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u0010_6lWM]:D_:$\u0018-\u001b8feB\u0011A'[\u0005\u0003UV\u0012qbT7nKJ\u001c8i\u001c8uC&tWM\u001d\u0005\u0006Y\u001e\u0001\r!\\\u0001\u001eGV\u0014(/\u001a8u\rVdGnQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_B\u00111L\\\u0005\u0003_r\u0013aCR;mY\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u0005\u0006c\u001e\u0001\rA]\u0001\"aJ,g/[8vg\u001a+H\u000e\\\"p]N,gn];t\u000bB|7\r[%oM>|\u0005\u000f\u001e\t\u0004'Ml\u0017B\u0001;\u0015\u0005\u0019y\u0005\u000f^5p]\")ao\u0002a\u0001o\u0006\t\"-Z:u\u0017:|wO\u001c)be\u0016tG/\u00133\u0011\u0007a\f)AD\u0002z\u0003\u0003q!A_@\u000f\u0005mtX\"\u0001?\u000b\u0005u\u0004\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\ty\u0002%C\u0002\u0002\u0004y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!AC'pI&4\u0017.\u001a:JI*\u0019\u00111\u0001\u0010\t\u000f\u00055q\u00011\u0001\u0002\u0010\u0005\u0019\"-Z:u\u0017:|wO\u001c)be\u0016tG/\u00138g_B!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u00161\tQa\u00195bS:LA!!\u0007\u0002\u0014\t\u00112+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017J\u001c4p\u0011\u0015It\u00011\u0001;\u0011\u001d\tyb\u0002a\u0001\u0003C\t!\u0005\u001d:fm&|Wo]#q_\u000eDw*\\7feNLeNZ8BG\u000e,X.\u001e7bi>\u0014\bCBA\u0012\u0003W\t\tD\u0004\u0003\u0002&\u0005%bbA>\u0002(%\tQ#C\u0002\u0002\u0004QIA!!\f\u00020\t\u00191+Z9\u000b\u0007\u0005\rA\u0003E\u0004\u0014\u0003g\t9$a\u0011\n\u0007\u0005UBC\u0001\u0004UkBdWM\r\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0007\u0002\u0007Y\u0014h-\u0003\u0003\u0002B\u0005m\"!\u0003,sM>+H\u000f];u!\u0011\t)%!\u0016\u000f\t\u0005\u001d\u00131\u000b\b\u0005\u0003\u0013\n\tF\u0004\u0003\u0002L\u0005=cbA>\u0002N%\tq\"\u0003\u0002\u000e\u001d%\u0011Q\fD\u0005\u0004\u0003\u0007a\u0016\u0002BA,\u00033\u00121cQ8og\u0016t7/^:TY>$h*^7cKJT1!a\u0001]\u0003=1XM]5gs\u001a{'oZ3s\u0005>DHc\u0002\u0018\u0002`\u0005%\u00141\u000f\u0005\b\u0003CB\u0001\u0019AA2\u0003\u0019AW-\u00193feB\u0019A'!\u001a\n\u0007\u0005\u001dTG\u0001\u000bTS\u0012,7\r[1j]\ncwnY6IK\u0006$WM\u001d\u0005\b\u0003WB\u0001\u0019AA7\u0003]\u0019H/Y6f\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eE\u0002\\\u0003_J1!!\u001d]\u0005]\u0019F/Y6f\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eC\u0004\u0002v!\u0001\r!a\u000e\u0002\u0013Y\u0014hmT;uaV$\b")
public class ConsensusValidator
implements HistoryBlockValidator,
ScorexLogging {
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<BoxedUnit> validate(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (history.isGenesisBlock(block.id())) {
                this.validateGenesisBlock(block, history);
            } else {
                this.validateNonGenesisBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(SidechainBlock block, SidechainHistory history) {
        if (block.timestamp() != history.params().sidechainGenesisBlockTimestamp()) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Genesis block timestamp ").append(block.timestamp()).append(" is differ than expected timestamp from configuration ").append(history.params().sidechainGenesisBlockTimestamp()).toString());
        }
        boolean vrfSignIsNotCorrect = false;
        if (vrfSignIsNotCorrect) {
            throw new IllegalArgumentException("Genesis block timestamp is not signed his own forger box");
        }
    }

    private void validateNonGenesisBlock(SidechainBlock verifiedBlock, SidechainHistory history) {
        SidechainBlockInfo parentBlockInfo = history.blockInfoById(verifiedBlock.parentId());
        this.verifyTimestamp(verifiedBlock.timestamp(), parentBlockInfo.timestamp(), history);
        FullConsensusEpochInfo currentConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(verifiedBlock.timestamp(), verifiedBlock.parentId());
        VrfOutput vrfOutput = (VrfOutput)history.getVrfOutput(verifiedBlock.header(), currentConsensusEpochInfo.nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for block ").append(verifiedBlock.id()).append(" had been failed").toString());
        });
        this.verifyForgerBox(verifiedBlock.header(), currentConsensusEpochInfo.stakeConsensusEpochInfo(), vrfOutput);
        SidechainBlockInfo lastBlockInPreviousConsensusEpochInfo = history.blockInfoById(history.getLastBlockInPreviousConsensusEpoch(verifiedBlock.timestamp(), verifiedBlock.parentId()));
        FullConsensusEpochInfo previousFullConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(lastBlockInPreviousConsensusEpochInfo.timestamp(), lastBlockInPreviousConsensusEpochInfo.parentId());
        this.verifyOmmers(verifiedBlock, currentConsensusEpochInfo, (Option<FullConsensusEpochInfo>)new Some((Object)previousFullConsensusEpochInfo), verifiedBlock.parentId(), parentBlockInfo, history, (Seq<Tuple2<VrfOutput, Object>>)((Seq)Nil$.MODULE$));
        this.verifyTimestampInFuture(verifiedBlock.timestamp(), history);
    }

    private void verifyTimestamp(long verifiedBlockTimestamp, long parentBlockTimestamp, TimeToEpochSlotConverter timeConverter) {
        int epochNumberForParentBlock;
        int absoluteSlotNumberForParentBlock;
        if (verifiedBlockTimestamp < parentBlockTimestamp) {
            throw new IllegalArgumentException("Block had been generated before parent block had been generated");
        }
        int absoluteSlotNumberForVerifiedBlock = timeConverter.timeStampToAbsoluteSlotNumber(verifiedBlockTimestamp);
        if (absoluteSlotNumberForVerifiedBlock <= (absoluteSlotNumberForParentBlock = timeConverter.timeStampToAbsoluteSlotNumber(parentBlockTimestamp))) {
            throw new IllegalArgumentException("Block absolute slot number is equal or less than parent block");
        }
        int epochNumberForVerifiedBlock = timeConverter.timeStampToEpochNumber(verifiedBlockTimestamp);
        if (epochNumberForVerifiedBlock - (epochNumberForParentBlock = timeConverter.timeStampToEpochNumber(parentBlockTimestamp)) > 1) {
            throw new IllegalStateException("Whole epoch had been skipped");
        }
    }

    private void verifyTimestampInFuture(long verifiedBlockTimestamp, SidechainHistory history) {
        if (history.timeStampToAbsoluteSlotNumber(verifiedBlockTimestamp) > history.timeStampToAbsoluteSlotNumber(Instant.now().getEpochSecond())) {
            throw new SidechainBlockSlotInFutureException("Block had been generated in the future", SidechainBlockSlotInFutureException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyOmmers(OmmersContainer ommersContainer, FullConsensusEpochInfo currentFullConsensusEpochInfo, Option<FullConsensusEpochInfo> previousFullConsensusEpochInfoOpt, String bestKnownParentId, SidechainBlockInfo bestKnownParentInfo, SidechainHistory history, Seq<Tuple2<VrfOutput, Object>> previousEpochOmmersInfoAccumulator) {
        Seq<Ommer> ommers = ommersContainer.ommers();
        if (ommers.isEmpty()) {
            return;
        }
        int ommersContainerEpochNumber = history.timeStampToEpochNumber(ommersContainer.header().timestamp());
        ObjectRef accumulator = ObjectRef.create(previousEpochOmmersInfoAccumulator);
        IntRef previousOmmerEpochNumber = IntRef.create((int)ommersContainerEpochNumber);
        ObjectRef ommerCurrentFullConsensusEpochInfo = ObjectRef.create((Object)currentFullConsensusEpochInfo);
        ObjectRef ommerPreviousFullConsensusEpochInfoOpt = ObjectRef.create(previousFullConsensusEpochInfoOpt);
        ommers.foreach((Function1 & Serializable & scala.Serializable)ommer -> {
            ConsensusValidator.$anonfun$verifyOmmers$1(this, history, previousOmmerEpochNumber, ommerCurrentFullConsensusEpochInfo, previousFullConsensusEpochInfoOpt, ommersContainer, ommerPreviousFullConsensusEpochInfoOpt, bestKnownParentId, bestKnownParentInfo, accumulator, currentFullConsensusEpochInfo, ommersContainerEpochNumber, ommer);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyForgerBox(SidechainBlockHeader header, StakeConsensusEpochInfo stakeConsensusEpochInfo, VrfOutput vrfOutput) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Verify Forger box against root hash: {} by merkle path {}", new Object[]{stakeConsensusEpochInfo.rootHash(), new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.forgerBoxMerklePath().bytes())).deep().mkString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean forgerBoxIsCorrect = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.forgerBoxMerklePath().apply(header.forgerBox().id())));
        if (!forgerBoxIsCorrect) {
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Actual stakeInfo: rootHash: {}, totalStake: {}", new Object[]{stakeConsensusEpochInfo.rootHash(), BoxesRunTime.boxToLong((long)stakeConsensusEpochInfo.totalStake())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new IllegalStateException(new StringBuilder(76).append("Forger box merkle path in block ").append(header.id()).append(" is inconsistent to stakes merkle root hash ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).deep().mkString(",")).toString());
        }
        long value = header.forgerBox().value();
        boolean stakeIsEnough = package$.MODULE$.vrfProofCheckAgainstStake(vrfOutput, value, stakeConsensusEpochInfo.totalStake());
        if (!stakeIsEnough) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Stake value in forger box in block ").append(header.id()).append(" is not enough for to be forger.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyOmmers$1(ConsensusValidator $this, SidechainHistory history$2, IntRef previousOmmerEpochNumber$1, ObjectRef ommerCurrentFullConsensusEpochInfo$1, Option previousFullConsensusEpochInfoOpt$1, OmmersContainer ommersContainer$1, ObjectRef ommerPreviousFullConsensusEpochInfoOpt$1, String bestKnownParentId$1, SidechainBlockInfo bestKnownParentInfo$1, ObjectRef accumulator$1, FullConsensusEpochInfo currentFullConsensusEpochInfo$1, int ommersContainerEpochNumber$1, Ommer ommer) {
        ConsensusEpochAndSlot ommerEpochAndSlot = history$2.timestampToEpochAndSlot(ommer.header().timestamp());
        if (ommerEpochAndSlot.epochNumber() < previousOmmerEpochNumber$1.elem) {
            ommerCurrentFullConsensusEpochInfo$1.elem = (FullConsensusEpochInfo)previousFullConsensusEpochInfoOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(40).append("Block ").append(ommersContainer$1.header().id()).append(" contains ommer two epochs before.").toString());
            });
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = None$.MODULE$;
        } else if (ommerEpochAndSlot.epochNumber() > previousOmmerEpochNumber$1.elem) {
            NonceConsensusEpochInfo nonce = history$2.calculateNonceForNonGenesisEpoch(bestKnownParentId$1, bestKnownParentInfo$1, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
            ommerCurrentFullConsensusEpochInfo$1.elem = new FullConsensusEpochInfo(currentFullConsensusEpochInfo$1.stakeConsensusEpochInfo(), nonce);
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = previousFullConsensusEpochInfoOpt$1;
        }
        VrfOutput ommerVrfOutput = (VrfOutput)history$2.getVrfOutput(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for Ommer ").append(ommer.header().id()).append(" had been failed").toString());
        });
        $this.verifyForgerBox(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).stakeConsensusEpochInfo(), ommerVrfOutput);
        $this.verifyOmmers(ommer, (FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem, (Option<FullConsensusEpochInfo>)((Option)ommerPreviousFullConsensusEpochInfoOpt$1.elem), bestKnownParentId$1, bestKnownParentInfo$1, history$2, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
        if (ommerEpochAndSlot.epochNumber() < ommersContainerEpochNumber$1) {
            Tuple2 tuple2 = new Tuple2((Object)ommerVrfOutput, (Object)BoxesRunTime.boxToInteger((int)ommerEpochAndSlot.slotNumber()));
            accumulator$1.elem = (Seq)((Seq)accumulator$1.elem).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        }
        previousOmmerEpochNumber$1.elem = ommerEpochAndSlot.epochNumber();
    }

    public ConsensusValidator() {
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
    }
}

