/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;

public class ListSerializer<T extends BytesSerializable>
implements ScorexSerializer<List<T>> {
    private ScorexSerializer<T> serializer;
    private int maxListLength;

    public ListSerializer(ScorexSerializer<T> serializer) {
        this(serializer, 0);
    }

    public ListSerializer(ScorexSerializer<T> serializer, int maxListLength) {
        this.maxListLength = maxListLength;
        this.serializer = serializer;
    }

    public void serialize(List<T> objectsList, Writer writer) {
        ArrayList<Integer> lengthsList = new ArrayList<Integer>();
        ByteArrayOutputStream objects = new ByteArrayOutputStream();
        for (BytesSerializable object : objectsList) {
            byte[] objectBytes = this.serializer.toBytes((Object)object);
            lengthsList.add(objectBytes.length);
            objects.write(objectBytes, 0, objectBytes.length);
        }
        writer.putInt(objectsList.size());
        Iterator<Object> iterator = lengthsList.iterator();
        while (iterator.hasNext()) {
            int length = (Integer)iterator.next();
            writer.putInt(length);
        }
        writer.putBytes(objects.toByteArray());
    }

    public List<T> parse(Reader reader) {
        int objectsCount = reader.getInt();
        int objectsTotalLength = 0;
        if (objectsCount < 0) {
            throw new IllegalArgumentException("Input data contains illegal elements count - " + objectsCount);
        }
        if (this.maxListLength > 0 && objectsCount > this.maxListLength) {
            throw new IllegalArgumentException("Input data contains to many elements - " + objectsCount);
        }
        ArrayList<Integer> lengthsList = new ArrayList<Integer>();
        for (int i = 0; i < objectsCount; ++i) {
            int length2 = reader.getInt();
            lengthsList.add(length2);
            objectsTotalLength += length2;
        }
        if (reader.remaining() < objectsTotalLength) {
            throw new IllegalArgumentException("Input data is corrupted.");
        }
        ArrayList objectsList = new ArrayList(objectsCount);
        lengthsList.forEach(length -> objectsList.add((BytesSerializable)this.serializer.parseBytes(reader.getBytes(length.intValue()))));
        return objectsList;
    }
}

