/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;

public class DynamicTypedSerializer<T extends BytesSerializable, S extends ScorexSerializer<T>>
implements ScorexSerializer<T> {
    protected HashMap<Byte, S> _coreSerializers;
    protected HashMap<Class, Byte> _coreSerializersClasses;
    protected HashMap<Byte, S> _customSerializers;
    protected HashMap<Class, Byte> _customSerializersClasses;
    protected byte CUSTOM_SERIALIZER_TYPE = (byte)127;

    public DynamicTypedSerializer(HashMap<Byte, S> coreSerializers, HashMap<Byte, S> customSerializers) {
        this._coreSerializers = coreSerializers;
        this._customSerializers = customSerializers;
        this._coreSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this._coreSerializers.entrySet()) {
            this._coreSerializersClasses.put(((ScorexSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this._coreSerializers.size() != this._coreSerializersClasses.size()) {
            throw new IllegalArgumentException("Core Serializers class types expected to be unique.");
        }
        this._customSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this._customSerializers.entrySet()) {
            this._customSerializersClasses.put(((ScorexSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this._customSerializers.size() != this._customSerializersClasses.size()) {
            throw new IllegalArgumentException("Custom Serializers class types expected to be unique.");
        }
    }

    public void serialize(T obj, Writer writer) {
        if (this._coreSerializersClasses.containsKey(obj.serializer().getClass())) {
            byte idOfSerializer = this._coreSerializersClasses.get(obj.serializer().getClass());
            writer.put(idOfSerializer);
            writer.putBytes(obj.serializer().toBytes(obj));
        } else if (this._customSerializersClasses.containsKey(obj.serializer().getClass())) {
            byte idOfSerializer = this._customSerializersClasses.get(obj.serializer().getClass());
            writer.put(this.CUSTOM_SERIALIZER_TYPE);
            writer.put(idOfSerializer);
            writer.putBytes(obj.serializer().toBytes(obj));
        } else {
            throw new IllegalArgumentException("Object without defined serializer occurred.");
        }
    }

    public T parse(Reader reader) {
        if (reader.remaining() < 1) {
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        byte[] bytes = reader.getBytes(reader.remaining());
        if (bytes[0] == this.CUSTOM_SERIALIZER_TYPE) {
            ScorexSerializer serializer = (ScorexSerializer)this._customSerializers.get(bytes[1]);
            if (serializer != null) {
                return (T)((BytesSerializable)serializer.parseBytes(Arrays.copyOfRange(bytes, 2, bytes.length)));
            }
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        ScorexSerializer serializer = (ScorexSerializer)this._coreSerializers.get(bytes[0]);
        if (serializer != null) {
            return (T)((BytesSerializable)serializer.parseBytes(Arrays.copyOfRange(bytes, 1, bytes.length)));
        }
        throw new IllegalArgumentException("Unknown core type id.");
    }
}

