/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.horizen.params.MainNetParams;
import com.horizen.params.NetworkParams;
import com.horizen.utils.Utils;
import com.horizen.utils.VarInt;
import java.util.Arrays;
import java.util.Collection;
import scorex.util.encode.Base58;

public final class BytesUtils {
    private static int HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH = 2;
    private static int HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH = 20;
    private static int HORIZEN_PUBLIC_KEY_ADDRESS_CHECKSUM_LENGTH = 4;
    private static int HORIZEN_PUBLIC_KEY_ADDRESS_BASE58_Length = 35;
    private static byte[] PUBLIC_KEY_MAINNET_PREFIX = BytesUtils.fromHexString("2089");
    private static byte[] PUBLIC_KEY_MAINNET_PREFIX_OLD = BytesUtils.fromHexString("1CB8");
    private static byte[] PUBLIC_KEY_TESTNET_PREFIX = BytesUtils.fromHexString("2098");
    private static byte[] PUBLIC_KEY_TESTNET_PREFIX_OLD = BytesUtils.fromHexString("1D25");

    private BytesUtils() {
    }

    public static short getShort(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 2) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Shorts.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1]);
    }

    public static short getReversedShort(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 2) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Shorts.fromBytes((byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static int getInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 4) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Ints.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3]);
    }

    public static int getReversedInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 4) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Ints.fromBytes((byte)bytes[offset + 3], (byte)bytes[offset + 2], (byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static long getLong(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 8) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Longs.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3], (byte)bytes[offset + 4], (byte)bytes[offset + 5], (byte)bytes[offset + 6], (byte)bytes[offset + 7]);
    }

    public static long getReversedLong(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 8) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Longs.fromBytes((byte)bytes[offset + 7], (byte)bytes[offset + 6], (byte)bytes[offset + 5], (byte)bytes[offset + 4], (byte)bytes[offset + 3], (byte)bytes[offset + 2], (byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static VarInt getVarInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 1) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        byte first = bytes[offset];
        switch (first) {
            case -3: {
                return new VarInt(BytesUtils.getShort(bytes, offset + 1), 3);
            }
            case -2: {
                return new VarInt(BytesUtils.getInt(bytes, offset + 1), 5);
            }
            case -1: {
                return new VarInt(BytesUtils.getLong(bytes, offset + 1), 9);
            }
        }
        return new VarInt(first, 1);
    }

    public static VarInt getReversedVarInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 1) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        byte first = bytes[offset];
        switch (first) {
            case -3: {
                return new VarInt(BytesUtils.getReversedShort(bytes, offset + 1), 3);
            }
            case -2: {
                return new VarInt(BytesUtils.getReversedInt(bytes, offset + 1), 5);
            }
            case -1: {
                return new VarInt(BytesUtils.getReversedLong(bytes, offset + 1), 9);
            }
        }
        return new VarInt(first & 0xFF, 1);
    }

    public static byte[] fromVarInt(VarInt vi) {
        byte[] res = new byte[vi.size()];
        switch (vi.size()) {
            case 1: {
                res[0] = (byte)(vi.value() & 0xFFL);
                break;
            }
            case 3: {
                res[0] = -3;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                break;
            }
            case 5: {
                res[0] = -2;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                res[3] = (byte)(vi.value() >> 16 & 0xFFL);
                res[4] = (byte)(vi.value() >> 24 & 0xFFL);
                break;
            }
            case 9: {
                res[0] = -1;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                res[3] = (byte)(vi.value() >> 16 & 0xFFL);
                res[4] = (byte)(vi.value() >> 24 & 0xFFL);
                res[5] = (byte)(vi.value() >> 32 & 0xFFL);
                res[6] = (byte)(vi.value() >> 40 & 0xFFL);
                res[7] = (byte)(vi.value() >> 48 & 0xFFL);
                res[8] = (byte)(vi.value() >> 56 & 0xFFL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect size of VarInt had been detected:" + vi.size());
            }
        }
        return res;
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[bytes.length - 1 - i];
        }
        return res;
    }

    public static byte[] fromHexString(String hex) {
        return BaseEncoding.base16().lowerCase().decode((CharSequence)hex.toLowerCase());
    }

    public static String toHexString(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    public static boolean contains(Collection<byte[]> collection, byte[] value) {
        for (byte[] v : collection) {
            if (!Arrays.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    public static byte[] fromHorizenPublicKeyAddress(String address, NetworkParams params) {
        if (address.length() != HORIZEN_PUBLIC_KEY_ADDRESS_BASE58_Length) {
            throw new IllegalArgumentException(String.format("Incorrect Horizen public key address length $d", address.length()));
        }
        byte[] addressBytesWithChecksum = (byte[])Base58.decode((String)address).get();
        byte[] addressBytes = Arrays.copyOfRange(addressBytesWithChecksum, 0, HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH + HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH);
        byte[] prefix = Arrays.copyOfRange(addressBytes, 0, HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH);
        if (params instanceof MainNetParams) {
            if (!Arrays.equals(prefix, PUBLIC_KEY_MAINNET_PREFIX) && !Arrays.equals(prefix, PUBLIC_KEY_MAINNET_PREFIX_OLD)) {
                throw new IllegalArgumentException("Incorrect Horizen public key address format, MainNet format expected.");
            }
        } else if (!Arrays.equals(prefix, PUBLIC_KEY_TESTNET_PREFIX) && !Arrays.equals(prefix, PUBLIC_KEY_TESTNET_PREFIX_OLD)) {
            throw new IllegalArgumentException("Incorrect Horizen public key address format, TestNet format expected.");
        }
        byte[] publicKeyHash = Arrays.copyOfRange(addressBytes, HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH, HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH + HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH);
        byte[] checksum = Arrays.copyOfRange(addressBytesWithChecksum, HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH + HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH, addressBytesWithChecksum.length);
        byte[] calculatedChecksum = Arrays.copyOfRange(Utils.doubleSHA256Hash(addressBytes), 0, HORIZEN_PUBLIC_KEY_ADDRESS_CHECKSUM_LENGTH);
        if (!Arrays.equals(calculatedChecksum, checksum)) {
            throw new IllegalArgumentException("Broken Horizen public key address: checksum is wrong.");
        }
        return publicKeyHash;
    }

    public static String toHorizenPublicKeyAddress(byte[] publicKeyHashBytes, NetworkParams params) {
        if (publicKeyHashBytes.length != HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH) {
            throw new IllegalArgumentException("Incorrect Horizen public key address bytes length.");
        }
        byte[] prefix = params instanceof MainNetParams ? PUBLIC_KEY_MAINNET_PREFIX : PUBLIC_KEY_TESTNET_PREFIX;
        byte[] addressBytes = Bytes.concat((byte[][])new byte[][]{prefix, publicKeyHashBytes});
        byte[] checksum = Arrays.copyOfRange(Utils.doubleSHA256Hash(addressBytes), 0, HORIZEN_PUBLIC_KEY_ADDRESS_CHECKSUM_LENGTH);
        return Base58.encode((byte[])Bytes.concat((byte[][])new byte[][]{addressBytes, checksum}));
    }
}

