/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import com.horizen.block.MainchainTxSidechainCreationCrosschainOutputData;
import com.horizen.box.ForgerBox;
import com.horizen.box.data.ForgerBoxData;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.transaction.mainchain.SidechainCreationSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;
import java.util.Arrays;
import scorex.crypto.hash.Blake2b256;

public final class SidechainCreation
implements SidechainRelatedMainchainOutput<ForgerBox> {
    private MainchainTxSidechainCreationCrosschainOutput output;
    private byte[] containingTxHash;
    private int index;

    public SidechainCreation(MainchainTxSidechainCreationCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{BytesUtils.reverseBytes(this.output.hash()), BytesUtils.reverseBytes(this.containingTxHash), BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public ForgerBox getBox() {
        PublicKey25519Proposition proposition = new PublicKey25519Proposition(this.output.address());
        long value = this.output.amount();
        VrfPublicKey vrfPublicKey = new VrfPublicKey(this.output.customData());
        ForgerBoxData forgerBoxData = new ForgerBoxData(proposition, value, proposition, vrfPublicKey);
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.containingTxHash, Ints.toByteArray((int)this.index)}));
        long nonce = BytesUtils.getLong(hash, 0);
        return forgerBoxData.getBox(nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)this.output.size()), this.output.sidechainCreationOutputBytes(), this.containingTxHash, Ints.toByteArray((int)this.index)});
    }

    public byte[] getGenSysConstant() {
        return this.output.constant();
    }

    public static SidechainCreation parseBytes(byte[] bytes) {
        int offset = 0;
        int sidechainCreationSize = BytesUtils.getInt(bytes, offset);
        offset += 4;
        if (bytes.length < 40 + sidechainCreationSize) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        MainchainTxSidechainCreationCrosschainOutputData output = (MainchainTxSidechainCreationCrosschainOutputData)MainchainTxSidechainCreationCrosschainOutputData.create(bytes, offset).get();
        byte[] txHash = Arrays.copyOfRange(bytes, offset += sidechainCreationSize, offset + 32);
        int index = BytesUtils.getInt(bytes, offset += 32);
        byte[] sidechainId = MainchainTxSidechainCreationCrosschainOutput.calculateSidechainId(txHash, index);
        return new SidechainCreation(new MainchainTxSidechainCreationCrosschainOutput(sidechainId, output), txHash, index);
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return SidechainCreationSerializer.getSerializer();
    }

    public int withdrawalEpochLength() {
        return this.output.withdrawalEpochLength();
    }
}

