/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import com.horizen.box.RegularBox;
import com.horizen.box.data.RegularBoxData;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.transaction.mainchain.ForwardTransferSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;
import java.util.Arrays;
import scorex.crypto.hash.Blake2b256;

public final class ForwardTransfer
implements SidechainRelatedMainchainOutput<RegularBox> {
    private MainchainTxForwardTransferCrosschainOutput output;
    private byte[] containingTxHash;
    private int index;

    public ForwardTransfer(MainchainTxForwardTransferCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{BytesUtils.reverseBytes(this.output.hash()), BytesUtils.reverseBytes(this.containingTxHash), BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public RegularBox getBox() {
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.containingTxHash, Ints.toByteArray((int)this.index)}));
        long nonce = BytesUtils.getLong(hash, 0);
        return new RegularBox(new RegularBoxData(new PublicKey25519Proposition(this.output.propositionBytes()), this.output.amount()), nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{this.output.forwardTransferOutputBytes(), this.containingTxHash, Ints.toByteArray((int)this.index)});
    }

    public static ForwardTransfer parseBytes(byte[] bytes) {
        if (bytes.length < 36 + MainchainTxForwardTransferCrosschainOutput.FORWARD_TRANSFER_OUTPUT_SIZE()) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        int offset = 0;
        MainchainTxForwardTransferCrosschainOutput output = (MainchainTxForwardTransferCrosschainOutput)MainchainTxForwardTransferCrosschainOutput.create(bytes, offset).get();
        byte[] txHash = Arrays.copyOfRange(bytes, offset += MainchainTxForwardTransferCrosschainOutput.FORWARD_TRANSFER_OUTPUT_SIZE(), offset + 32);
        int idx = BytesUtils.getInt(bytes, offset += 32);
        return new ForwardTransfer(output, txHash, idx);
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return ForwardTransferSerializer.getSerializer();
    }
}

