/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.horizen.box.BoxUnlocker;
import com.horizen.box.NoncedBox;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.BoxTransaction;
import com.horizen.utils.BytesUtils;
import java.io.ByteArrayOutputStream;
import java.util.List;
import scorex.crypto.hash.Blake2b256;

public abstract class SidechainTransaction<P extends Proposition, B extends NoncedBox<P>>
extends BoxTransaction<P, B> {
    private byte[] _hashWithoutNonce;

    private synchronized byte[] hashWithoutNonce() {
        if (this._hashWithoutNonce == null) {
            ByteArrayOutputStream unlockersStream = new ByteArrayOutputStream();
            for (BoxUnlocker u : this.unlockers()) {
                unlockersStream.write(u.closedBoxId(), 0, u.closedBoxId().length);
            }
            ByteArrayOutputStream newBoxesStream = new ByteArrayOutputStream();
            for (NoncedBox box : this.newBoxes()) {
                newBoxesStream.write(box.proposition().bytes(), 0, box.proposition().bytes().length);
            }
            this._hashWithoutNonce = Bytes.concat((byte[][])new byte[][]{unlockersStream.toByteArray(), newBoxesStream.toByteArray(), Longs.toByteArray((long)this.timestamp()), Longs.toByteArray((long)this.fee())});
        }
        return this._hashWithoutNonce;
    }

    protected final long getNewBoxNonce(P newBoxProposition, int newBoxIndex) {
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{newBoxProposition.bytes(), this.hashWithoutNonce(), Ints.toByteArray((int)newBoxIndex)}));
        return BytesUtils.getLong(hash, 0);
    }

    public abstract boolean transactionSemanticValidity();

    @Override
    public final boolean semanticValidity() {
        if (this.unlockers().size() != this.boxIdsToOpen().size()) {
            return false;
        }
        List boxes = this.newBoxes();
        for (int i = 0; i < boxes.size(); ++i) {
            if (((NoncedBox)boxes.get(i)).nonce() == this.getNewBoxNonce(((NoncedBox)boxes.get(i)).proposition(), i)) continue;
            return false;
        }
        return this.transactionSemanticValidity();
    }
}

