/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.horizen.box.BoxUnlocker;
import com.horizen.box.NoncedBox;
import com.horizen.box.data.NoncedBoxData;
import com.horizen.companion.SidechainBoxesDataCompanion;
import com.horizen.companion.SidechainProofsCompanion;
import com.horizen.proof.Proof;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.SidechainCoreTransactionSerializer;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.ListSerializer;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import scorex.core.NodeViewModifier$;

public class SidechainCoreTransaction
extends SidechainTransaction<Proposition, NoncedBox<Proposition>> {
    private List<byte[]> inputsIds;
    private List<NoncedBoxData<Proposition, NoncedBox<Proposition>>> outputsData;
    private List<Proof<Proposition>> proofs;
    private SidechainBoxesDataCompanion boxesDataCompanion;
    private SidechainProofsCompanion proofsCompanion;
    private long fee;
    private long timestamp;
    private List<NoncedBox<Proposition>> newBoxes;
    private List<BoxUnlocker<Proposition>> unlockers;

    @Inject
    SidechainCoreTransaction(@Assisted(value="inputIds") List<byte[]> inputsIds, @Assisted(value="outputsData") List<NoncedBoxData<Proposition, NoncedBox<Proposition>>> outputsData, @Assisted(value="proofs") List<Proof<Proposition>> proofs, @Assisted(value="fee") long fee, @Assisted(value="timestamp") long timestamp, SidechainBoxesDataCompanion boxesDataCompanion, SidechainProofsCompanion proofsCompanion) {
        Objects.requireNonNull(inputsIds, "Inputs Ids list can't be null.");
        Objects.requireNonNull(outputsData, "Outputs Data list can't be null.");
        Objects.requireNonNull(proofs, "Proofs list can't be null.");
        Objects.requireNonNull(boxesDataCompanion, "BoxesDataCompanion can't be null.");
        Objects.requireNonNull(proofsCompanion, "ProofsCompanion can't be null.");
        this.inputsIds = inputsIds;
        this.outputsData = outputsData;
        this.proofs = proofs;
        this.fee = fee;
        this.timestamp = timestamp;
        this.boxesDataCompanion = boxesDataCompanion;
        this.proofsCompanion = proofsCompanion;
    }

    public TransactionSerializer serializer() {
        return new SidechainCoreTransactionSerializer(this.boxesDataCompanion, this.proofsCompanion);
    }

    @Override
    public synchronized List<BoxUnlocker<Proposition>> unlockers() {
        if (this.unlockers == null) {
            this.unlockers = new ArrayList<BoxUnlocker<Proposition>>();
            int i = 0;
            while (i < this.inputsIds.size() && i < this.proofs.size()) {
                final int finalI = i++;
                BoxUnlocker<Proposition> unlocker = new BoxUnlocker<Proposition>(){

                    @Override
                    public byte[] closedBoxId() {
                        return (byte[])SidechainCoreTransaction.this.inputsIds.get(finalI);
                    }

                    @Override
                    public Proof boxKey() {
                        return (Proof)SidechainCoreTransaction.this.proofs.get(finalI);
                    }
                };
                this.unlockers.add(unlocker);
            }
        }
        return Collections.unmodifiableList(this.unlockers);
    }

    @Override
    public synchronized List<NoncedBox<Proposition>> newBoxes() {
        if (this.newBoxes == null) {
            this.newBoxes = new ArrayList<NoncedBox<Proposition>>();
            for (int i = 0; i < this.outputsData.size(); ++i) {
                NoncedBoxData<Proposition, NoncedBox<Proposition>> boxData = this.outputsData.get(i);
                long nonce = this.getNewBoxNonce(boxData.proposition(), i);
                this.newBoxes.add(boxData.getBox(nonce));
            }
        }
        return Collections.unmodifiableList(this.newBoxes);
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean transactionSemanticValidity() {
        if (this.fee < 0L || this.timestamp < 0L) {
            return false;
        }
        if (this.inputsIds.isEmpty() || this.outputsData.isEmpty()) {
            return false;
        }
        return this.inputsIds.size() == this.proofs.size() && this.inputsIds.size() == this.boxIdsToOpen().size();
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.SidechainCoreTransactionId.id();
    }

    @Override
    public byte[] bytes() {
        ByteArrayOutputStream inputsIdsStream = new ByteArrayOutputStream();
        for (byte[] id : this.inputsIds) {
            inputsIdsStream.write(id, 0, id.length);
        }
        byte[] inputIdsBytes = inputsIdsStream.toByteArray();
        ListSerializer<NoncedBoxData<Proposition, NoncedBox<Proposition>>> boxesDataSerializer = new ListSerializer<NoncedBoxData<Proposition, NoncedBox<Proposition>>>(this.boxesDataCompanion, 1000);
        byte[] outputBoxDataBytes = boxesDataSerializer.toBytes(this.outputsData);
        ListSerializer<Proof<Proposition>> proofsSerializer = new ListSerializer<Proof<Proposition>>(this.proofsCompanion, 1000);
        byte[] proofsBytes = proofsSerializer.toBytes(this.proofs);
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.fee()), Longs.toByteArray((long)this.timestamp()), Ints.toByteArray((int)inputIdsBytes.length), inputIdsBytes, Ints.toByteArray((int)outputBoxDataBytes.length), outputBoxDataBytes, Ints.toByteArray((int)proofsBytes.length), proofsBytes});
    }

    public static SidechainCoreTransaction parseBytes(byte[] bytes, SidechainBoxesDataCompanion boxesDataCompanion, SidechainProofsCompanion proofsCompanion) {
        int batchSize;
        int idLength;
        if (bytes.length < 36) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        if (bytes.length > 500000) {
            throw new IllegalArgumentException("Input data length is too large.");
        }
        int offset = 0;
        long fee = BytesUtils.getLong(bytes, offset);
        long timestamp = BytesUtils.getLong(bytes, offset += 8);
        offset += 4;
        ArrayList<byte[]> inputsIds = new ArrayList<byte[]>();
        for (batchSize = BytesUtils.getInt(bytes, offset += 8); batchSize > 0; batchSize -= idLength) {
            idLength = NodeViewModifier$.MODULE$.ModifierIdSize();
            inputsIds.add(Arrays.copyOfRange(bytes, offset, offset + idLength));
            offset += idLength;
        }
        batchSize = BytesUtils.getInt(bytes, offset);
        ListSerializer<NoncedBoxData<Proposition, NoncedBox<Proposition>>> boxesDataSerializer = new ListSerializer<NoncedBoxData<Proposition, NoncedBox<Proposition>>>(boxesDataCompanion, 1000);
        List outputsData = (List)boxesDataSerializer.parseBytes(Arrays.copyOfRange(bytes, offset += 4, offset + batchSize));
        offset += batchSize;
        if (bytes.length != (offset += 4) + (batchSize = BytesUtils.getInt(bytes, offset))) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        ListSerializer<Proof<Proposition>> proofsSerializer = new ListSerializer<Proof<Proposition>>(proofsCompanion, 1000);
        List proofs = (List)proofsSerializer.parseBytes(Arrays.copyOfRange(bytes, offset, offset + batchSize));
        return new SidechainCoreTransaction(inputsIds, outputsData, proofs, fee, timestamp, boxesDataCompanion, proofsCompanion);
    }
}

