/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.Box;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.box.data.NoncedBoxData;
import com.horizen.box.data.RegularBoxData;
import com.horizen.node.NodeWallet;
import com.horizen.proposition.Proposition;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.secret.PrivateKey25519;
import com.horizen.secret.Secret;
import com.horizen.transaction.RegularTransaction;
import com.horizen.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RegularTransactionCreator {
    public static RegularTransaction create(NodeWallet wallet, List<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> to, PublicKey25519Proposition changeAddress, long fee, List<byte[]> boxIdsToExclude) {
        Objects.requireNonNull(wallet, "Wallet can't be null");
        Objects.requireNonNull(to, "Destination box data list can't be null");
        Objects.requireNonNull(changeAddress, "Change address can't be null");
        Objects.requireNonNull(boxIdsToExclude, "Box ids to exclude list can't be null");
        long toAmount = 0L;
        for (NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>> boxData : to) {
            if (boxData.value() < 0L) {
                throw new IllegalArgumentException("Output values must be >= 0.");
            }
            toAmount += boxData.value();
        }
        if (fee < 0L) {
            throw new IllegalArgumentException("Fee must be >= 0.");
        }
        toAmount += fee;
        ArrayList<RegularBox> boxes = new ArrayList<RegularBox>();
        for (Box box : wallet.boxesOfType(RegularBox.class, boxIdsToExclude)) {
            boxes.add((RegularBox)box);
        }
        ArrayList<Pair<RegularBox, PrivateKey25519>> from = new ArrayList<Pair<RegularBox, PrivateKey25519>>();
        long l = 0L;
        for (RegularBox box : boxes) {
            Secret s = wallet.secretByPublicKey((Proposition)box.proposition()).get();
            if (!(s instanceof PrivateKey25519)) continue;
            from.add(new Pair<RegularBox, PrivateKey25519>(box, (PrivateKey25519)s));
            if ((l += box.value()) < toAmount) continue;
            break;
        }
        if (l < toAmount) {
            throw new IllegalArgumentException("Not enough balances in the wallet to create a transaction.");
        }
        ArrayList<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> sendTo = new ArrayList<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>>(to);
        if (l > toAmount) {
            sendTo.add(new RegularBoxData(changeAddress, l - toAmount));
        }
        long timestamp = System.currentTimeMillis();
        return RegularTransaction.create(from, sendTo, fee, timestamp);
    }
}

