/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.horizen.box.BoxUnlocker;
import com.horizen.box.CoreBoxesIdsEnum;
import com.horizen.box.ForgerBox;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.box.RegularBoxSerializer;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.data.ForgerBoxData;
import com.horizen.box.data.ForgerBoxDataSerializer;
import com.horizen.box.data.NoncedBoxData;
import com.horizen.box.data.NoncedBoxDataSerializer;
import com.horizen.box.data.RegularBoxData;
import com.horizen.box.data.RegularBoxDataSerializer;
import com.horizen.box.data.WithdrawalRequestBoxData;
import com.horizen.box.data.WithdrawalRequestBoxDataSerializer;
import com.horizen.proof.Proof;
import com.horizen.proof.Signature25519;
import com.horizen.proof.Signature25519Serializer;
import com.horizen.proposition.Proposition;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.secret.PrivateKey25519;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.RegularTransactionSerializer;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.DynamicTypedSerializer;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class RegularTransaction
extends SidechainTransaction<Proposition, NoncedBox<Proposition>> {
    private List<RegularBox> inputs;
    private List<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> outputs;
    private List<Signature25519> signatures;
    private long fee;
    private long timestamp;
    private List<NoncedBox<Proposition>> newBoxes;
    private List<BoxUnlocker<Proposition>> unlockers;
    private static ListSerializer<RegularBox> boxListSerializer = new ListSerializer<RegularBox>(RegularBoxSerializer.getSerializer(), 1000);
    private static ListSerializer<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> boxDataListSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, NoncedBoxDataSerializer>(){
        {
            this.put(CoreBoxesIdsEnum.RegularBoxId.id(), RegularBoxDataSerializer.getSerializer());
            this.put(CoreBoxesIdsEnum.WithdrawalRequestBoxId.id(), WithdrawalRequestBoxDataSerializer.getSerializer());
            this.put(CoreBoxesIdsEnum.ForgerBoxId.id(), ForgerBoxDataSerializer.getSerializer());
        }
    }, new HashMap()));
    private static ListSerializer<Signature25519> signaturesSerializer = new ListSerializer<Signature25519>(Signature25519Serializer.getSerializer(), 1000);

    private RegularTransaction(List<RegularBox> inputs, List<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> outputs, List<Signature25519> signatures, long fee, long timestamp) {
        if (inputs.size() != signatures.size()) {
            throw new IllegalArgumentException("Inputs list size is different to signatures list size!");
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.signatures = signatures;
        this.fee = fee;
        this.timestamp = timestamp;
    }

    public TransactionSerializer serializer() {
        return RegularTransactionSerializer.getSerializer();
    }

    @Override
    public synchronized List<BoxUnlocker<Proposition>> unlockers() {
        if (this.unlockers == null) {
            this.unlockers = new ArrayList<BoxUnlocker<Proposition>>();
            int i = 0;
            while (i < this.inputs.size() && i < this.signatures.size()) {
                final int finalI = i++;
                BoxUnlocker<Proposition> unlocker = new BoxUnlocker<Proposition>(){

                    @Override
                    public byte[] closedBoxId() {
                        return ((RegularBox)RegularTransaction.this.inputs.get(finalI)).id();
                    }

                    @Override
                    public Proof boxKey() {
                        return (Proof)RegularTransaction.this.signatures.get(finalI);
                    }
                };
                this.unlockers.add(unlocker);
            }
        }
        return Collections.unmodifiableList(this.unlockers);
    }

    @Override
    public synchronized List<NoncedBox<Proposition>> newBoxes() {
        if (this.newBoxes == null) {
            this.newBoxes = new ArrayList<NoncedBox<Proposition>>();
            for (int i = 0; i < this.outputs.size(); ++i) {
                long nonce = this.getNewBoxNonce(this.outputs.get(i).proposition(), i);
                NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>> boxData = this.outputs.get(i);
                if (boxData instanceof RegularBoxData) {
                    this.newBoxes.add(new RegularBox((RegularBoxData)boxData, nonce));
                    continue;
                }
                if (boxData instanceof WithdrawalRequestBoxData) {
                    this.newBoxes.add(new WithdrawalRequestBox((WithdrawalRequestBoxData)boxData, nonce));
                    continue;
                }
                if (boxData instanceof ForgerBoxData) {
                    this.newBoxes.add(new ForgerBox((ForgerBoxData)boxData, nonce));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unexpected BoxData type: %s", boxData.getClass().toString()));
            }
        }
        return Collections.unmodifiableList(this.newBoxes);
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean transactionSemanticValidity() {
        if (this.fee < 0L || this.timestamp < 0L) {
            return false;
        }
        if (this.inputs.size() != this.signatures.size() || this.inputs.size() != this.boxIdsToOpen().size()) {
            return false;
        }
        if (!RegularTransaction.checkSupportedBoxDataTypes(this.outputs).booleanValue()) {
            return false;
        }
        Long outputsAmount = 0L;
        for (NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>> output : this.outputs) {
            if (output.value() <= 0L) {
                return false;
            }
            outputsAmount = outputsAmount + output.value();
        }
        Long inputsAmount = 0L;
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!this.signatures.get(i).isValid((PublicKey25519Proposition)this.inputs.get(i).proposition(), this.messageToSign())) {
                return false;
            }
            inputsAmount = inputsAmount + this.inputs.get(i).value();
        }
        return inputsAmount == outputsAmount + this.fee;
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.RegularTransactionId.id();
    }

    @Override
    public byte[] bytes() {
        byte[] inputBoxesBytes = boxListSerializer.toBytes(this.inputs);
        byte[] outputBoxDataBytes = boxDataListSerializer.toBytes(this.outputs);
        byte[] signaturesBytes = signaturesSerializer.toBytes(this.signatures);
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.fee()), Longs.toByteArray((long)this.timestamp()), Ints.toByteArray((int)inputBoxesBytes.length), inputBoxesBytes, Ints.toByteArray((int)outputBoxDataBytes.length), outputBoxDataBytes, Ints.toByteArray((int)signaturesBytes.length), signaturesBytes});
    }

    public static RegularTransaction parseBytes(byte[] bytes) {
        if (bytes.length < 40) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        if (bytes.length > 500000) {
            throw new IllegalArgumentException("Input data length is too large.");
        }
        int offset = 0;
        long fee = BytesUtils.getLong(bytes, offset);
        long timestamp = BytesUtils.getLong(bytes, offset += 8);
        int batchSize = BytesUtils.getInt(bytes, offset += 8);
        List inputs = (List)boxListSerializer.parseBytes(Arrays.copyOfRange(bytes, offset += 4, offset + batchSize));
        offset += batchSize;
        batchSize = BytesUtils.getInt(bytes, offset);
        List outputs = (List)boxDataListSerializer.parseBytes(Arrays.copyOfRange(bytes, offset += 4, offset + batchSize));
        offset += batchSize;
        if (bytes.length != (offset += 4) + (batchSize = BytesUtils.getInt(bytes, offset))) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        List signatures = (List)signaturesSerializer.parseBytes(Arrays.copyOfRange(bytes, offset, offset + batchSize));
        return new RegularTransaction(inputs, outputs, signatures, fee, timestamp);
    }

    private static Boolean checkSupportedBoxDataTypes(List<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> boxDataList) {
        for (NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>> boxData : boxDataList) {
            if (boxData instanceof RegularBoxData || boxData instanceof WithdrawalRequestBoxData || boxData instanceof ForgerBoxData) continue;
            return false;
        }
        return true;
    }

    public static RegularTransaction create(List<Pair<RegularBox, PrivateKey25519>> from, List<NoncedBoxData<? extends Proposition, ? extends NoncedBox<? extends Proposition>>> outputs, long fee, long timestamp) {
        if (from == null || outputs == null) {
            throw new IllegalArgumentException("Parameters can't be null.");
        }
        if (from.size() > 1000) {
            throw new IllegalArgumentException("Transaction from number is too large.");
        }
        if (outputs.size() > 1000) {
            throw new IllegalArgumentException("Transaction outputs number is too large.");
        }
        if (!RegularTransaction.checkSupportedBoxDataTypes(outputs).booleanValue()) {
            throw new IllegalArgumentException("Unsupported output box data type found.");
        }
        ArrayList<RegularBox> inputs = new ArrayList<RegularBox>();
        ArrayList<Signature25519> fakeSignatures = new ArrayList<Signature25519>();
        for (Pair<RegularBox, PrivateKey25519> item : from) {
            inputs.add(item.getKey());
            fakeSignatures.add(null);
        }
        RegularTransaction unsignedTransaction = new RegularTransaction(inputs, outputs, fakeSignatures, fee, timestamp);
        byte[] messageToSign = unsignedTransaction.messageToSign();
        ArrayList<Signature25519> signatures = new ArrayList<Signature25519>();
        for (Pair<RegularBox, PrivateKey25519> item : from) {
            signatures.add(item.getValue().sign(messageToSign));
        }
        RegularTransaction transaction = new RegularTransaction(inputs, outputs, signatures, fee, timestamp);
        return transaction;
    }

    public String toString() {
        return "RegularTransaction{inputs=" + this.inputs + ", outputs=" + this.outputs + ", signatures=" + this.signatures + ", fee=" + this.fee + ", timestamp=" + this.timestamp + ", newBoxes=" + this.newBoxes + ", unlockers=" + this.unlockers + '}';
    }
}

