/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.horizen.box.Box;
import com.horizen.box.BoxUnlocker;
import com.horizen.proposition.Proposition;
import com.horizen.serialization.Views;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.MC2SCAggregatedTransactionSerializer;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.transaction.mainchain.ForwardTransferSerializer;
import com.horizen.transaction.mainchain.SidechainCreationSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.DynamicTypedSerializer;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.MerkleTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.encode.Base16;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"mc2scTransactionsOutputs", "encoder"})
public final class MC2SCAggregatedTransaction
extends BoxTransaction<Proposition, Box<Proposition>> {
    private byte[] mc2scTransactionsMerkleRootHash;
    private List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs;
    private long timestamp;
    private List<Box<Proposition>> newBoxes;
    private static ListSerializer<SidechainRelatedMainchainOutput> mc2scTransactionsSerializer = new ListSerializer(new DynamicTypedSerializer(new HashMap<Byte, ScorexSerializer<SidechainRelatedMainchainOutput>>(){
        {
            this.put((byte)1, ForwardTransferSerializer.getSerializer());
            this.put((byte)3, SidechainCreationSerializer.getSerializer());
        }
    }, new HashMap()));

    public MC2SCAggregatedTransaction(List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs, long timestamp) {
        if (mc2scTransactionsOutputs.isEmpty()) {
            throw new IllegalArgumentException("Empty sidechain related mainchain outputs passed.");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Negative timestamp passed.");
        }
        this.mc2scTransactionsOutputs = mc2scTransactionsOutputs;
        this.timestamp = timestamp;
    }

    public TransactionSerializer serializer() {
        return MC2SCAggregatedTransactionSerializer.getSerializer();
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return null;
    }

    @Override
    public synchronized List<BoxUnlocker<Proposition>> unlockers() {
        return new ArrayList<BoxUnlocker<Proposition>>();
    }

    @Override
    public synchronized List<Box<Proposition>> newBoxes() {
        if (this.newBoxes == null) {
            this.newBoxes = new ArrayList<Box<Proposition>>();
            for (SidechainRelatedMainchainOutput t : this.mc2scTransactionsOutputs) {
                this.newBoxes.add((Box<Proposition>)t.getBox());
            }
        }
        return Collections.unmodifiableList(this.newBoxes);
    }

    @Override
    public long fee() {
        return 0L;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.MC2SCAggregatedTransactionId.id();
    }

    @Override
    public String id() {
        return Base16.encode((byte[])this.mc2scMerkleRootHash());
    }

    @Override
    public byte[] messageToSign() {
        throw new UnsupportedOperationException("MC2SCAggregatedTransaction can not be signed.");
    }

    @JsonProperty(value="mc2scTransactionsMerkleRootHash")
    public synchronized byte[] mc2scMerkleRootHash() {
        if (this.mc2scTransactionsMerkleRootHash == null) {
            ArrayList<byte[]> hashes = new ArrayList<byte[]>();
            for (SidechainRelatedMainchainOutput t : this.mc2scTransactionsOutputs) {
                hashes.add(t.hash());
            }
            this.mc2scTransactionsMerkleRootHash = MerkleTree.createMerkleTree(hashes).rootHash();
        }
        return Arrays.copyOf(this.mc2scTransactionsMerkleRootHash, this.mc2scTransactionsMerkleRootHash.length);
    }

    public List<SidechainRelatedMainchainOutput> mc2scTransactionsOutputs() {
        return Collections.unmodifiableList(this.mc2scTransactionsOutputs);
    }

    @Override
    public boolean semanticValidity() {
        return true;
    }

    @Override
    public byte[] bytes() {
        byte[] transactions = mc2scTransactionsSerializer.toBytes(this.mc2scTransactionsOutputs);
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.timestamp()), Ints.toByteArray((int)transactions.length), transactions});
    }

    public static MC2SCAggregatedTransaction parseBytes(byte[] bytes) {
        if (bytes.length < 12) {
            throw new IllegalArgumentException("Input data corrupted.");
        }
        if (bytes.length > 500000) {
            throw new IllegalArgumentException("Input data length is too large.");
        }
        int offset = 0;
        long timestamp = BytesUtils.getLong(bytes, offset);
        int batchSize = BytesUtils.getInt(bytes, offset += 8);
        List mc2scTransactions = (List)mc2scTransactionsSerializer.parseBytes(Arrays.copyOfRange(bytes, offset += 4, offset + batchSize));
        return new MC2SCAggregatedTransaction(mc2scTransactions, timestamp);
    }
}

