/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.BoxUnlocker;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.utils.ByteArrayWrapper;
import java.util.List;

public class DefaultTransactionIncompatibilityChecker
implements TransactionIncompatibilityChecker {
    @Override
    public <T extends BoxTransaction> boolean isTransactionCompatible(T newTx, List<T> currentTxs) {
        if (newTx == null || currentTxs == null) {
            throw new IllegalArgumentException("Parameters can't be null.");
        }
        for (BoxUnlocker unlocker : newTx.unlockers()) {
            ByteArrayWrapper closedBoxId = new ByteArrayWrapper(unlocker.closedBoxId());
            for (BoxTransaction tx : currentTxs) {
                if (!tx.boxIdsToOpen().contains((Object)closedBoxId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMemoryPoolCompatible() {
        return true;
    }
}

