/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage.leveldb;

import com.horizen.storage.leveldb.ChangeSet;
import com.horizen.storage.leveldb.ChangeSetSerializer$;
import com.horizen.storage.leveldb.KVStore;
import com.horizen.storage.leveldb.package$Algos$;
import com.horizen.storage.leveldb.package$Constants$;
import io.iohk.iodb.ByteArrayWrapper;
import java.io.Serializable;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\n\u0015\u0005uA\u0001B\u000b\u0001\u0003\u0006\u0004%\tb\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005Y!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r)\u0003\u0001\u0015!\u0003E\u0011\u001dY\u0005A1A\u0005\u00021Ca!\u0014\u0001!\u0002\u00139\u0005\"\u0002(\u0001\t\u0003y\u0005bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00026\u0001!\t!a\u000e\b\u000b\r$\u0002\u0012\u00013\u0007\u000bM!\u0002\u0012A3\t\u000bu\u0002B\u0011A5\u0006\t)\u0004\u0002\u0001\u0012\u0002\u0014-\u0016\u00148/[8oK\u0012dEIQ&W'R|'/\u001a\u0006\u0003+Y\tq\u0001\\3wK2$'M\u0003\u0002\u00181\u000591\u000f^8sC\u001e,'BA\r\u001b\u0003\u001dAwN]5{K:T\u0011aG\u0001\u0004G>l7\u0001A\n\u0004\u0001y1\u0003CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u001dBS\"\u0001\u000b\n\u0005%\"\"aB&W'R|'/Z\u0001\u0003I\n,\u0012\u0001\f\t\u0003[Mj\u0011A\f\u0006\u0003+=R!\u0001M\u0019\u0002\t%\f\b\b\r\u0006\u0002e\u0005\u0019qN]4\n\u0005Qr#A\u0001#C\u0003\r!'\rI\u0001\rW\u0016,\u0007OV3sg&|gn\u001d\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002@\u0001\u0006\u0003\"a\n\u0001\t\u000b)\"\u0001\u0019\u0001\u0017\t\u000bY\"\u0001\u0019A\u001c\u0002\u0017Y+'o]5p]N\\U-_\u000b\u0002\tB\u0019\u0001(R$\n\u0005\u0019K$!B!se\u0006L\bC\u0001\u001dI\u0013\tI\u0015H\u0001\u0003CsR,\u0017\u0001\u0004,feNLwN\\:LKf\u0004\u0013aD\"iC:<WmU3u!J,g-\u001b=\u0016\u0003\u001d\u000b\u0001c\u00115b]\u001e,7+\u001a;Qe\u00164\u0017\u000e\u001f\u0011\u0002\rU\u0004H-\u0019;f)\u0011\u00016.!\u0001\u0015\u0005E#\u0006C\u0001\u001dS\u0013\t\u0019\u0016H\u0001\u0003V]&$\b\"B+\n\u0001\u00041\u0016a\u0002<feNLwN\u001c\t\u0003/Jq!\u0001W\b\u000f\u0005e\u0013gB\u0001.b\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012a\u0005,feNLwN\\3e\u0019\u0012\u00135JV*u_J,\u0007CA\u0014\u0011'\t\u0001b\r\u0005\u00029O&\u0011\u0001.\u000f\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0011\u0014\u0011BV3sg&|g.\u00133\t\u000b1L\u0001\u0019A7\u0002\u0011Q|\u0017J\\:feR\u00042A\\:w\u001d\ty\u0017O\u0004\u0002]a&\t!(\u0003\u0002ss\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\r\u0019V-\u001d\u0006\u0003ef\u0002B\u0001O<z{&\u0011\u00010\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005i\\X\"\u0001\u0001\n\u0005qD#!A&\u0011\u0005it\u0018BA@)\u0005\u00051\u0006bBA\u0002\u0013\u0001\u0007\u0011QA\u0001\ti>\u0014V-\\8wKB\u0019an]=\u0002\r%t7/\u001a:u)\u0011\tY!a\u0004\u0015\u0007E\u000bi\u0001C\u0003V\u0015\u0001\u0007a\u000bC\u0003m\u0015\u0001\u0007Q.\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003+\tI\u0002F\u0002R\u0003/AQ!V\u0006A\u0002YCq!a\u0001\f\u0001\u0004\t)!\u0001\u0006s_2d'-Y2l)>$B!a\b\u0002,A)\u0011\u0011EA\u0014#6\u0011\u00111\u0005\u0006\u0004\u0003KI\u0014\u0001B;uS2LA!!\u000b\u0002$\t\u0019AK]=\t\r\u00055B\u00021\u0001W\u0003%1XM]:j_:LE-\u0001\u0005wKJ\u001c\u0018n\u001c8t+\t\t\u0019\u0004E\u0002ogZ\u000bqB^3sg&|g.\u00133Fq&\u001cHo\u001d\u000b\u0005\u0003s\ty\u0004E\u00029\u0003wI1!!\u0010:\u0005\u001d\u0011un\u001c7fC:Da!!\f\u000f\u0001\u00041\u0006")
public final class VersionedLDBKVStore
implements KVStore {
    private final DB db;
    private final int keepVersions;
    private final byte[] VersionsKey;
    private final byte ChangeSetPrefix;

    @Override
    public Option<byte[]> get(byte[] key) {
        return KVStore.get$((KVStore)this, key);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll(Function2<byte[], byte[], Object> cond) {
        return KVStore.getAll$(this, cond);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll() {
        return KVStore.getAll$(this);
    }

    @Override
    public byte[] getOrElse(byte[] key, Function0<byte[]> function0) {
        return KVStore.getOrElse$(this, key, function0);
    }

    @Override
    public Seq<Tuple2<byte[], Option<byte[]>>> get(Seq<byte[]> keys) {
        return KVStore.get$((KVStore)this, keys);
    }

    @Override
    public void close() {
        KVStore.close$(this);
    }

    @Override
    public DB db() {
        return this.db;
    }

    public byte[] VersionsKey() {
        return this.VersionsKey;
    }

    public byte ChangeSetPrefix() {
        return this.ChangeSetPrefix;
    }

    public void update(Seq<Tuple2<byte[], byte[]>> toInsert, Seq<byte[]> toRemove, byte[] version) {
        Predef$.MODULE$.require(version.length == package$Constants$.MODULE$.HashLength(), (Function0 & Serializable & scala.Serializable)() -> "Illegal version id size");
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)this.db().get(version, ro)).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Version id is already used");
        ArrayBuffer insertedKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer altered = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        toInsert.foreach((Function1 & Serializable & scala.Serializable)x -> {
            VersionedLDBKVStore.$anonfun$update$3(this, ro, insertedKeys, altered, x);
            return BoxedUnit.UNIT;
        });
        Seq removed = (Seq)toRemove.flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(k, ro)).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), x$1))), Seq$.MODULE$.canBuildFrom());
        ChangeSet changeSet = new ChangeSet((Seq<byte[]>)insertedKeys, (Seq<Tuple2<byte[], byte[]>>)removed, (Seq<Tuple2<byte[], byte[]>>)altered);
        Tuple2 tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey(), ro)).map((Function1 & Serializable & scala.Serializable)x$2 -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(version)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> version))).splitAt(package$Constants$.MODULE$.HashLength() * this.keepVersions);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] updatedVersions = (byte[])tuple2._1();
        byte[] versionsToShrink = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)updatedVersions, (Object)versionsToShrink);
        Tuple2 tuple23 = tuple22;
        byte[] updatedVersions2 = (byte[])tuple23._1();
        byte[] versionsToShrink2 = (byte[])tuple23._2();
        Iterator versionIdsToShrink = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(versionsToShrink2)).grouped(package$Constants$.MODULE$.HashLength());
        WriteBatch batch = this.db().createWriteBatch();
        try {
            batch.put(this.VersionsKey(), updatedVersions2);
            versionIdsToShrink.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
            byte by = this.ChangeSetPrefix();
            batch.put(version, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ChangeSetSerializer$.MODULE$.toBytes(changeSet))).$plus$colon((Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.Byte()));
            toInsert.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                byte[] k = (byte[])tuple2._1();
                byte[] v = (byte[])tuple2._2();
                WriteBatch writeBatch = batch.put(k, v);
                return writeBatch;
            });
            toRemove.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
            this.db().write(batch);
        }
        finally {
            batch.close();
            ro.snapshot().close();
        }
    }

    public void insert(Seq<Tuple2<byte[], byte[]>> toInsert, byte[] version) {
        this.update(toInsert, (Seq<byte[]>)((Seq)Nil$.MODULE$), version);
    }

    public void remove(Seq<byte[]> toRemove, byte[] version) {
        this.update((Seq<Tuple2<byte[], byte[]>>)((Seq)Nil$.MODULE$), toRemove, version);
    }

    public Try<BoxedUnit> rollbackTo(byte[] versionId) {
        Failure failure;
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Option option = Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()));
        if (option instanceof Some) {
            Success success;
            Some some = (Some)option;
            byte[] bytes = (byte[])some.value();
            WriteBatch batch = this.db().createWriteBatch();
            try {
                Iterator versionsToRollBack = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$1(versionId, x$5)));
                ((IterableLike)versionsToRollBack.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Seq acc = (Seq)tuple2._1();
                    byte[] verId = (byte[])tuple2._2();
                    Option changeSetOpt = Option$.MODULE$.apply((Object)this.db().get(verId, ro)).flatMap((Function1 & Serializable & scala.Serializable)changeSetBytes -> ChangeSetSerializer$.MODULE$.parseBytesTry((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(changeSetBytes)).tail()).toOption());
                    Predef$.MODULE$.require(changeSetOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Inconsistent versioned storage state");
                    Seq seq = (Seq)acc.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(changeSetOpt).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verId), x$6), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    return seq;
                })).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] verId = (byte[])tuple2._1();
                    ChangeSet changeSet = (ChangeSet)tuple2._2();
                    changeSet.insertedKeys().foreach((Function1 & Serializable & scala.Serializable)k -> batch.delete(k));
                    changeSet.removed().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] v = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, v);
                        return writeBatch;
                    });
                    changeSet.altered().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] oldV = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, oldV);
                        return writeBatch;
                    });
                    WriteBatch writeBatch = batch.delete(verId);
                    return writeBatch;
                });
                ByteArrayWrapper wrappedVersionId = new ByteArrayWrapper(versionId);
                byte[] updatedVersions = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).map((Function1 & Serializable & scala.Serializable)data -> new ByteArrayWrapper(data)).dropWhile((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$11(wrappedVersionId, x$7))).foldLeft(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x0$5, x1$2) -> {
                    Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] acc = (byte[])tuple2._1();
                    ByteArrayWrapper arr = (ByteArrayWrapper)tuple2._2();
                    byte[] byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr.data())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                    return byArray;
                });
                versionsToRollBack.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
                batch.put(this.VersionsKey(), updatedVersions);
                this.db().write(batch);
                success = new Success((Object)BoxedUnit.UNIT);
            }
            finally {
                batch.close();
                ro.snapshot().close();
            }
            failure = success;
        } else if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new Exception(new StringBuilder(18).append("Version ").append(package$Algos$.MODULE$.encode(versionId)).append(" not found").toString()));
        } else {
            throw new MatchError((Object)option);
        }
        return failure;
    }

    public Seq<byte[]> versions() {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$8)).grouped(package$Constants$.MODULE$.HashLength()), Seq$.MODULE$.canBuildFrom());
    }

    public boolean versionIdExists(byte[] versionId) {
        return this.versions().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$versionIdExists$1(versionId, x$9)));
    }

    public static final /* synthetic */ void $anonfun$update$3(VersionedLDBKVStore $this, ReadOptions ro$1, ArrayBuffer insertedKeys$1, ArrayBuffer altered$1, Tuple2 x) {
        Option$.MODULE$.apply((Object)$this.db().get((byte[])x._1(), ro$1)).fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedKeys$1.$plus$eq(x._1()), (Function1 & Serializable & scala.Serializable)oldValue -> {
            altered$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)oldValue));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$1(byte[] versionId$1, byte[] x$5) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$5);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$1);
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !byteArrayWrapper.equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$11(ByteArrayWrapper wrappedVersionId$1, ByteArrayWrapper x$7) {
        ByteArrayWrapper byteArrayWrapper = x$7;
        ByteArrayWrapper byteArrayWrapper2 = wrappedVersionId$1;
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !byteArrayWrapper.equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$versionIdExists$1(byte[] versionId$2, byte[] x$9) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$9);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$2);
        return !(byteArrayWrapper != null ? !byteArrayWrapper.equals(byteArrayWrapper2) : byteArrayWrapper2 != null);
    }

    public VersionedLDBKVStore(DB db, int keepVersions) {
        this.db = db;
        this.keepVersions = keepVersions;
        KVStore.$init$(this);
        this.VersionsKey = package$Algos$.MODULE$.hash().apply("versions");
        this.ChangeSetPrefix = (byte)22;
    }
}

