/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.ForgerBox;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.companion.SidechainTransactionsCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.RegularTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;
import scorex.util.package;
import scorex.util.package$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0006\r\u0001MA\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)\u0011\u0007\u0001C\u0001e!)a\u0007\u0001C\u0001o!)a\t\u0001C\u0001\u000f\")a\f\u0001C\u0001?\")Q\u000f\u0001C\u0001m\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0002\"'&$Wm\u00195bS:<\u0016\r\u001c7fiR\u0013\u0018M\\:bGRLwN\\*u_J\fw-\u001a\u0006\u0003\u001b9\tqa\u001d;pe\u0006<WM\u0003\u0002\u0010!\u00059\u0001n\u001c:ju\u0016t'\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001!\"D\b\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\b\n\u0005uq!AD*jI\u0016\u001c\u0007.Y5o)f\u0004Xm\u001d\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA!\u001e;jY*\t1%\u0001\u0004tG>\u0014X\r_\u0005\u0003K\u0001\u0012QbU2pe\u0016DHj\\4hS:<\u0007CA\u0014)\u001b\u0005a\u0011BA\u0015\r\u0005\u001d\u0019Fo\u001c:bO\u0016\fad]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t7oQ8na\u0006t\u0017n\u001c8\u0011\u00051zS\"A\u0017\u000b\u00059r\u0011!C2p[B\fg.[8o\u0013\t\u0001TF\u0001\u0010TS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\\:D_6\u0004\u0018M\\5p]\u00061A(\u001b8jiz\"2a\r\u001b6!\t9\u0003\u0001C\u0003\u000e\u0007\u0001\u0007a\u0005C\u0003+\u0007\u0001\u00071&\u0001\u0007dC2\u001cW\u000f\\1uK.+\u0017\u0010\u0006\u00029}A\u0011\u0011\bP\u0007\u0002u)\u00111HD\u0001\u0006kRLGn]\u0005\u0003{i\u0012\u0001CQ=uK\u0006\u0013(/Y=Xe\u0006\u0004\b/\u001a:\t\u000b}\"\u0001\u0019\u0001!\u0002\u001bQ\u0014\u0018M\\:bGRLwN\\%e!\r)\u0012iQ\u0005\u0003\u0005Z\u0011Q!\u0011:sCf\u0004\"!\u0006#\n\u0005\u00153\"\u0001\u0002\"zi\u0016\f1aZ3u)\tAU\fE\u0002\u0016\u0013.K!A\u0013\f\u0003\r=\u0003H/[8o!\u0011au*U,\u000e\u00035S!A\u0014\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003!6\u0013aBQ8y)J\fgn]1di&|g\u000e\u0005\u0002S+6\t1K\u0003\u0002U\u001d\u0005Y\u0001O]8q_NLG/[8o\u0013\t16KA\u0006Qe>\u0004xn]5uS>t\u0007c\u0001-\\#6\t\u0011L\u0003\u0002[\u001d\u0005\u0019!m\u001c=\n\u0005qK&a\u0001\"pq\")q(\u0002a\u0001\u0001\u00061Q\u000f\u001d3bi\u0016$2\u0001Y3h!\r\t7mM\u0007\u0002E*\u0011\u0011EF\u0005\u0003I\n\u00141\u0001\u0016:z\u0011\u00151g\u00011\u00019\u0003\u001d1XM]:j_:DQ\u0001\u001b\u0004A\u0002%\fQ\u0003\u001e:b]N\f7\r^5p]V\u0003H-\u0019;f\u0019&\u001cH\u000fE\u0002ke.s!a\u001b9\u000f\u00051|W\"A7\u000b\u00059\u0014\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t\th#A\u0004qC\u000e\\\u0017mZ3\n\u0005M$(aA*fc*\u0011\u0011OF\u0001\u000eY\u0006\u001cHOV3sg&|g.\u00133\u0016\u0003]\u00042\u0001\u001f?9\u001b\u0005I(BA\u0011{\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!!`=\u0003\u0011=\u0003H/[8oC2\f\u0001C]8mY\n\f7m\u001b,feNLwN\\:\u0016\u0005\u0005\u0005\u0001\u0003\u00026\u0002\u0004aJ1!!\u0002u\u0005\u0011a\u0015n\u001d;\u0002\u0011I|G\u000e\u001c2bG.$2\u0001YA\u0006\u0011\u00151\u0017\u00021\u00019\u0003\u001dI7/R7qif,\"!!\u0005\u0011\u0007U\t\u0019\"C\u0002\u0002\u0016Y\u0011qAQ8pY\u0016\fg\u000e")
public class SidechainWalletTransactionStorage
implements SidechainTypes,
ScorexLogging {
    private final Storage storage;
    private final SidechainTransactionsCompanion sidechainTransactionsCompanion;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> regularTxToScbt(RegularTransaction t) {
        return SidechainTypes.regularTxToScbt$(this, t);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainNoncedBoxTxToScbt(SidechainTransaction<Proposition, NoncedBox<Proposition>> t) {
        return SidechainTypes.sidechainNoncedBoxTxToScbt$(this, t);
    }

    @Override
    public List<BoxTransaction<Proposition, Box<Proposition>>> regularTxListToScbtList(List<RegularTransaction> tl) {
        return SidechainTypes.regularTxListToScbtList$(this, tl);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainNoncedBoxTxListToScbtList(java.util.List<SidechainTransaction<Proposition, NoncedBox<Proposition>>> tl) {
        return SidechainTypes.sidechainNoncedBoxTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> regularBoxToScb(RegularBox b) {
        return SidechainTypes.regularBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> certifierRightBoxToScb(CertifierRightBox b) {
        return SidechainTypes.certifierRightBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> regularBoxJavaListToScbtJavaList(java.util.List<RegularBox> bl) {
        return SidechainTypes.regularBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> regularBoxListToScbtList(List<RegularBox> bl) {
        return SidechainTypes.regularBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public java.util.List<Box<Proposition>> certifierRightBoxJavaListToScbtJavaList(java.util.List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> certifierRightBoxListToScbtList(List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> regularBoxSetToScbSet(Set<RegularBox> bs) {
        return SidechainTypes.regularBoxSetToScbSet$(this, bs);
    }

    @Override
    public Set<Box<Proposition>> certifierRightBoxSetToScbSet(Set<CertifierRightBox> bs) {
        return SidechainTypes.certifierRightBoxSetToScbSet$(this, bs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper calculateKey(byte[] transactionId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.hash(transactionId));
    }

    public Option<BoxTransaction<Proposition, Box<Proposition>>> get(byte[] transactionId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(this.calculateKey(transactionId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainTransactionsCompanion.parseBytesTry(((io.iohk.iodb.ByteArrayWrapper)optional.get()).data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BoxTransaction transaction = (BoxTransaction)success.value();
                option2 = Option$.MODULE$.apply((Object)transaction);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while Transaction parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Try<SidechainWalletTransactionStorage> update(ByteArrayWrapper version, Seq<BoxTransaction<Proposition, Box<Proposition>>> transactionUpdateList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(transactionUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Transactions to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!transactionUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Transactions to add/update must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            transactionUpdateList.foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.calculateKey(package$.MODULE$.idToBytes((String)package.ModifierId$.MODULE$.$at$at((Object)tx.id(), package.Tagger$.MODULE$.baseRaw()))), new ByteArrayWrapper(this.sidechainTransactionsCompanion.toBytes(tx))))));
            $this.storage.update(version, updateList, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Optional<ByteArrayWrapper> lastVersionId() {
        return this.storage.lastVersionID();
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletTransactionStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainWalletTransactionStorage(Storage storage, SidechainTransactionsCompanion sidechainTransactionsCompanion) {
        this.storage = storage;
        this.sidechainTransactionsCompanion = sidechainTransactionsCompanion;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainTransactionsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainTransactionsCompanion must be NOT NULL.");
    }
}

