/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.WalletBox;
import com.horizen.WalletBoxSerializer;
import com.horizen.box.Box;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.ForgerBox;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.RegularTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\u000f\u001e\u0001\u0011B\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)!\t\u0001C\u0001\u0007\"9q\t\u0001b\u0001\n\u0013A\u0005B\u0002.\u0001A\u0003%\u0011\nC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r-\u0004\u0001\u0015!\u0003^\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\b\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u00111\u000b\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\tI\b\u0001C\u0001\u0003\u000bCq!!*\u0001\t\u0003\t9\u000bC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bb\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqAa\n\u0001\t\u0003\u0011ICA\rTS\u0012,7\r[1j]^\u000bG\u000e\\3u\u0005>D8\u000b^8sC\u001e,'B\u0001\u0010 \u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001I\u0011\u0002\u000f!|'/\u001b>f]*\t!%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001K-z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\tq$\u0003\u0002/?\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bC\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0003Q\naa]2pe\u0016D\u0018B\u0001\u001c2\u00055\u00196m\u001c:fq2{wmZ5oOB\u0011\u0001(O\u0007\u0002;%\u0011!(\b\u0002\b'R|'/Y4f\u0003]\u0019\u0018\u000eZ3dQ\u0006LgNQ8yKN\u001cu.\u001c9b]&|g\u000e\u0005\u0002>\u00016\taH\u0003\u0002@?\u0005I1m\\7qC:LwN\\\u0005\u0003\u0003z\u0012qcU5eK\u000eD\u0017-\u001b8C_b,7oQ8na\u0006t\u0017n\u001c8\u0002\rqJg.\u001b;?)\r!UI\u0012\t\u0003q\u0001AQAH\u0002A\u0002]BQaO\u0002A\u0002q\nAbX<bY2,GOQ8yKN,\u0012!\u0013\t\u0005\u0015>\u000bv+D\u0001L\u0015\taU*A\u0004nkR\f'\r\\3\u000b\u00059;\u0013AC2pY2,7\r^5p]&\u0011\u0001k\u0013\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005I+V\"A*\u000b\u0005Q{\u0012!B;uS2\u001c\u0018B\u0001,T\u0005A\u0011\u0015\u0010^3BeJ\f\u0017p\u0016:baB,'\u000f\u0005\u0002-1&\u0011\u0011l\b\u0002\n/\u0006dG.\u001a;C_b\fQbX<bY2,GOQ8yKN\u0004\u0013AE0xC2dW\r\u001e\"pq\u0016\u001c()\u001f+za\u0016,\u0012!\u0018\t\u0006\u0015>s\u0016Q\u0001\u0019\u0003?&\u00042\u0001Y3h\u001b\u0005\t'B\u00012d\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\fAA[1wC&\u0011a-\u0019\u0002\u0006\u00072\f7o\u001d\t\u0003Q&d\u0001\u0001B\u0005k\u000f\u0005\u0005\t\u0011!B\u0001Y\n\u0019q\fJ\u0019\u0002'};\u0018\r\u001c7fi\n{\u00070Z:CsRK\b/\u001a\u0011\u0012\u00055\u0004\bC\u0001\u0014o\u0013\tywEA\u0004O_RD\u0017N\\41\u0005ED\bc\u0001:vo6\t1O\u0003\u0002u?\u0005\u0019!m\u001c=\n\u0005Y\u001c(a\u0001\"pqB\u0011\u0001\u000e\u001f\u0003\nsj\f\t\u0011!A\u0003\u0002m\u00141a\u0018\u00133\t%Qw!!A\u0002\u0002\u000b\u0005A.\u0005\u0002nyB\u0019Q0!\u0001\u000e\u0003yT!a`\u0010\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0004\u0003\u0007q(a\u0003)s_B|7/\u001b;j_:\u0004RASA\u0004#^K1!!\u0003L\u0005\ri\u0015\r]\u0001\u0015?^\fG\u000e\\3u\u0005>DXm\u001d\"bY\u0006t7-Z:\u0016\u0005\u0005=\u0001C\u0002&P\u0003#\tY\u0003\r\u0003\u0002\u0014\u0005]\u0001\u0003\u00021f\u0003+\u00012\u0001[A\f\t-\tI\"CA\u0001\u0002\u0003\u0015\t!!\b\u0003\u0007}#3'A\u000b`o\u0006dG.\u001a;C_b,7OQ1mC:\u001cWm\u001d\u0011\u0012\u00075\fy\u0002\r\u0003\u0002\"\u0005\u0015\u0002\u0003\u0002:v\u0003G\u00012\u0001[A\u0013\t-\t9#!\u000b\u0002\u0002\u0003\u0005)\u0011A>\u0003\u0007}#C\u0007B\u0006\u0002\u001a%\t\t1!A\u0003\u0002\u0005u\u0001c\u0001\u0014\u0002.%\u0019\u0011qF\u0014\u0003\t1{gnZ\u0001\u0015?^\fG\u000e\\3u\u0005>D8+\u001a:jC2L'0\u001a:\u0016\u0005\u0005U\u0002c\u0001\u0017\u00028%\u0019\u0011\u0011H\u0010\u0003']\u000bG\u000e\\3u\u0005>D8+\u001a:jC2L'0\u001a:\u0002+};\u0018\r\u001c7fi\n{\u0007pU3sS\u0006d\u0017N_3sA\u0005a1-\u00197dk2\fG/Z&fsR\u0019\u0011+!\u0011\t\u000f\u0005\rC\u00021\u0001\u0002F\u0005)!m\u001c=JIB)a%a\u0012\u0002L%\u0019\u0011\u0011J\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0019\ni%C\u0002\u0002P\u001d\u0012AAQ=uK\u000612-\u00197dk2\fG/\u001a\"pq\u0016\u001c()\u00197b]\u000e,7\u000f\u0006\u0002\u0002VA\u0019a%a\u0016\n\u0007\u0005esE\u0001\u0003V]&$\u0018AE;qI\u0006$XMQ8yKN\u0014\u0015\r\\1oG\u0016$b!!\u0016\u0002`\u0005\r\u0004BBA1\u001d\u0001\u0007q+\u0001\u0005c_b$v.\u00113e\u0011\u0019\t)G\u0004a\u0001/\u0006Y!m\u001c=U_J+Wn\u001c<f\u0003I\tG\rZ,bY2,GOQ8y\u0005f$\u0016\u0010]3\u0015\t\u0005U\u00131\u000e\u0005\u0007\u0003[z\u0001\u0019A,\u0002\u0013]\fG\u000e\\3u\u0005>D\u0018!\u0006:f[>4XmV1mY\u0016$(i\u001c=CsRK\b/\u001a\u000b\u0005\u0003+\n\u0019\b\u0003\u0004\u0002vA\u0001\r!U\u0001\u000eE>D\u0018\n\u001a+p%\u0016lwN^3\u0002\u001f1|\u0017\rZ,bY2,GOQ8yKN\f1aZ3u)\u0011\ti(a!\u0011\t\u0019\nyhV\u0005\u0004\u0003\u0003;#AB(qi&|g\u000eC\u0004\u0002DI\u0001\r!!\u0012\u0015\t\u0005\u001d\u0015q\u0014\t\u0006\u0003\u0013\u000bIj\u0016\b\u0005\u0003\u0017\u000b)J\u0004\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\tjI\u0001\u0007yI|w\u000e\u001e \n\u0003!J1!a&(\u0003\u001d\u0001\u0018mY6bO\u0016LA!a'\u0002\u001e\n!A*[:u\u0015\r\t9j\n\u0005\b\u0003C\u001b\u0002\u0019AAR\u0003\u0019\u0011w\u000e_%egB1\u0011\u0011RAM\u0003\u000b\naaZ3u\u00032dWCAAD\u0003%9W\r\u001e\"z)f\u0004X\r\u0006\u0003\u0002\b\u00065\u0006bBAX+\u0001\u0007\u0011\u0011W\u0001\bE>DH+\u001f9fa\u0011\t\u0019,a1\u0011\r\u0005U\u0016QXAa\u001d\u0011\t9,!/\u0011\u0007\u00055u%C\u0002\u0002<\u001e\na\u0001\u0015:fI\u00164\u0017b\u00014\u0002@*\u0019\u00111X\u0014\u0011\u0007!\f\u0019\r\u0002\u0007\u0002F\u00065\u0016\u0011!A\u0001\u0006\u0003\t9MA\u0002`IU\n2!\\Aea\u0011\tY-a4\u0011\tI,\u0018Q\u001a\t\u0004Q\u0006=GaCAi\u0003'\f\t\u0011!A\u0003\u0002m\u00141a\u0018\u00137\t1\t)-!,\u0002\u0002\u0007\u0005)\u0011AAd\u0003=9W\r\u001e\"pq\u0016\u001c()\u00197b]\u000e,G\u0003BA\u0016\u00033Dq!a,\u0017\u0001\u0004\tY\u000e\r\u0003\u0002^\u0006\u0005\bCBA[\u0003{\u000by\u000eE\u0002i\u0003C$A\"a9\u0002Z\u0006\u0005\t\u0011!B\u0001\u0003K\u00141a\u0018\u00138#\ri\u0017q\u001d\u0019\u0005\u0003S\fi\u000f\u0005\u0003sk\u0006-\bc\u00015\u0002n\u0012Y\u0011q^Ay\u0003\u0003\u0005\tQ!\u0001|\u0005\ryF\u0005\u000f\u0003\r\u0003G\fI.!A\u0002\u0002\u000b\u0005\u0011Q]\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005](\u0011\u0001B\u0003\u0005\u0013\u0001R!!?\u0002~\u0012k!!a?\u000b\u0005I:\u0013\u0002BA\u0000\u0003w\u00141\u0001\u0016:z\u0011\u0019\u0011\u0019a\u0006a\u0001#\u00069a/\u001a:tS>t\u0007b\u0002B\u0004/\u0001\u0007\u0011qQ\u0001\u0014o\u0006dG.\u001a;C_b,\u0006\u000fZ1uK2K7\u000f\u001e\u0005\b\u0005\u00179\u0002\u0019AAR\u0003A\u0011w\u000e_%egJ+Wn\u001c<f\u0019&\u001cH/A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0003\u0005#\u0001RAa\u0005\u0003\u0018Ek!A!\u0006\u000b\u0005I\u001a\u0017\u0002\u0002B\r\u0005+\u0011\u0001b\u00149uS>t\u0017\r\\\u0001\u0011e>dGNY1dWZ+'o]5p]N,\"Aa\b\u0011\u000b\u0005%\u0015\u0011T)\u0002\u0011I|G\u000e\u001c2bG.$B!a>\u0003&!1!1\u0001\u000eA\u0002E\u000bq![:F[B$\u00180\u0006\u0002\u0003,A\u0019aE!\f\n\u0007\t=rEA\u0004C_>dW-\u00198")
public class SidechainWalletBoxStorage
implements SidechainTypes,
ScorexLogging {
    private final Storage storage;
    private final LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances;
    private final WalletBoxSerializer _walletBoxSerializer;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> regularTxToScbt(RegularTransaction t) {
        return SidechainTypes.regularTxToScbt$(this, t);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainNoncedBoxTxToScbt(SidechainTransaction<Proposition, NoncedBox<Proposition>> t) {
        return SidechainTypes.sidechainNoncedBoxTxToScbt$(this, t);
    }

    @Override
    public List<BoxTransaction<Proposition, Box<Proposition>>> regularTxListToScbtList(List<RegularTransaction> tl) {
        return SidechainTypes.regularTxListToScbtList$(this, tl);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainNoncedBoxTxListToScbtList(java.util.List<SidechainTransaction<Proposition, NoncedBox<Proposition>>> tl) {
        return SidechainTypes.sidechainNoncedBoxTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> regularBoxToScb(RegularBox b) {
        return SidechainTypes.regularBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> certifierRightBoxToScb(CertifierRightBox b) {
        return SidechainTypes.certifierRightBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> regularBoxJavaListToScbtJavaList(java.util.List<RegularBox> bl) {
        return SidechainTypes.regularBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> regularBoxListToScbtList(List<RegularBox> bl) {
        return SidechainTypes.regularBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public java.util.List<Box<Proposition>> certifierRightBoxJavaListToScbtJavaList(java.util.List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> certifierRightBoxListToScbtList(List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> regularBoxSetToScbSet(Set<RegularBox> bs) {
        return SidechainTypes.regularBoxSetToScbSet$(this, bs);
    }

    @Override
    public Set<Box<Proposition>> certifierRightBoxSetToScbSet(Set<CertifierRightBox> bs) {
        return SidechainTypes.certifierRightBoxSetToScbSet$(this, bs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes() {
        return this._walletBoxes;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType() {
        return this._walletBoxesByType;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances() {
        return this._walletBoxesBalances;
    }

    private WalletBoxSerializer _walletBoxSerializer() {
        return this._walletBoxSerializer;
    }

    public ByteArrayWrapper calculateKey(byte[] boxId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.hash(boxId));
    }

    private void calculateBoxesBalances() {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> this._walletBoxesBalances().put(bc, ((TraversableOnce)((TraversableLike)this._walletBoxesByType().apply(bc)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SidechainWalletBoxStorage.$anonfun$calculateBoxesBalances$2(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    private void updateBoxesBalance(WalletBox boxToAdd, WalletBox boxToRemove) {
        block2: {
            BoxedUnit boxedUnit;
            if (boxToAdd != null) {
                Class<?> bca = boxToAdd.box().getClass();
                boxedUnit = this._walletBoxesBalances().put(bca, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bca, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + boxToAdd.box().value())));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (boxToRemove == null) break block2;
            Class<?> bcr = boxToRemove.box().getClass();
            this._walletBoxesBalances().put(bcr, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bcr, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - boxToRemove.box().value())));
        }
    }

    private void addWalletBoxByType(WalletBox walletBox) {
        Class<?> bc = walletBox.box().getClass();
        ByteArrayWrapper key = this.calculateKey(walletBox.box().id());
        Option t = this._walletBoxesByType().get(bc);
        if (t.isEmpty()) {
            LinkedHashMap m = new LinkedHashMap();
            m.put((Object)key, (Object)walletBox);
            this._walletBoxesByType().put(bc, (Object)m);
        } else {
            ((MapLike)t.get()).put((Object)key, (Object)walletBox);
        }
    }

    private void removeWalletBoxByType(ByteArrayWrapper boxIdToRemove) {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> ((MapLike)this._walletBoxesByType().apply(bc)).remove((Object)boxIdToRemove));
    }

    private void loadWalletBoxes() {
        this._walletBoxes().clear();
        this._walletBoxesByType().clear();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).foreach((Function1 & Serializable & scala.Serializable)wb -> {
            SidechainWalletBoxStorage.$anonfun$loadWalletBoxes$1(this, wb);
            return BoxedUnit.UNIT;
        });
        this.calculateBoxesBalances();
    }

    public Option<WalletBox> get(byte[] boxId) {
        return this._walletBoxes().get((Object)this.calculateKey(boxId));
    }

    public List<WalletBox> get(List<byte[]> boxIds) {
        return (List)((TraversableLike)boxIds.map((Function1 & Serializable & scala.Serializable)boxId -> this.calculateKey((byte[])boxId), List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SidechainWalletBoxStorage.$anonfun$get$2(this, id))).map((Function1 & Serializable & scala.Serializable)id -> (WalletBox)this._walletBoxes().apply((Object)id), List$.MODULE$.canBuildFrom());
    }

    public List<WalletBox> getAll() {
        return this._walletBoxes().values().toList();
    }

    public List<WalletBox> getByType(Class<? extends Box<? extends Proposition>> boxType) {
        Nil$ nil$;
        Option option = this._walletBoxesByType().get(boxType);
        if (option instanceof Some) {
            Some some = (Some)option;
            Map v = (Map)some.value();
            nil$ = v.values().toList();
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    public long getBoxesBalance(Class<? extends Box<? extends Proposition>> boxType) {
        return BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(boxType, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Try<SidechainWalletBoxStorage> update(ByteArrayWrapper version, List<WalletBox> walletBoxUpdateList, List<byte[]> boxIdsRemoveList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(walletBoxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of WalletBoxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!walletBoxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WalletBox to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            removeList.addAll(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)boxIdsRemoveList.map((Function1 & Serializable & scala.Serializable)x$2 -> this.calculateKey((byte[])x$2), List$.MODULE$.canBuildFrom())).asJavaCollection());
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wb -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.calculateKey(wb.box().id()), new ByteArrayWrapper(this._walletBoxSerializer().toBytes(wb))))));
            $this.storage.update(version, updateList, removeList);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(removeList).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                SidechainWalletBoxStorage.$anonfun$update$8(this, key);
                return BoxedUnit.UNIT;
            });
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wba -> {
                SidechainWalletBoxStorage.$anonfun$update$9(this, wba);
                return BoxedUnit.UNIT;
            });
            return this;
        });
    }

    public Optional<ByteArrayWrapper> lastVersionId() {
        return this.storage.lastVersionID();
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletBoxStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.loadWalletBoxes();
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ long $anonfun$calculateBoxesBalances$2(Tuple2 x$1) {
        return ((WalletBox)x$1._2()).box().value();
    }

    public static final /* synthetic */ void $anonfun$loadWalletBoxes$1(SidechainWalletBoxStorage $this, Pair wb) {
        BoxedUnit boxedUnit;
        Try<WalletBox> walletBox = $this._walletBoxSerializer().parseBytesTry(((io.iohk.iodb.ByteArrayWrapper)wb.getValue()).data());
        if (walletBox.isSuccess()) {
            $this._walletBoxes().put((Object)$this.calculateKey(((WalletBox)walletBox.get()).box().id()), walletBox.get());
            $this.addWalletBoxByType((WalletBox)walletBox.get());
        } else if ($this.log().underlying().isErrorEnabled()) {
            $this.log().underlying().error("Error while WalletBox parsing.", new Object[]{walletBox});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$get$2(SidechainWalletBoxStorage $this, ByteArrayWrapper id) {
        return $this._walletBoxes().get((Object)id).isDefined();
    }

    public static final /* synthetic */ void $anonfun$update$8(SidechainWalletBoxStorage $this, ByteArrayWrapper key) {
        block0: {
            Option btr = $this._walletBoxes().remove((Object)key);
            $this.removeWalletBoxByType(key);
            if (!btr.isDefined()) break block0;
            $this.updateBoxesBalance(null, (WalletBox)btr.get());
        }
    }

    public static final /* synthetic */ void $anonfun$update$9(SidechainWalletBoxStorage $this, WalletBox wba) {
        block0: {
            ByteArrayWrapper key = $this.calculateKey(wba.box().id());
            Option bta = $this._walletBoxes().put((Object)key, (Object)wba);
            $this.addWalletBoxByType(wba);
            if (!bta.isEmpty()) break block0;
            $this.updateBoxesBalance(wba, null);
        }
    }

    public SidechainWalletBoxStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this._walletBoxes = new LinkedHashMap();
        this._walletBoxesByType = new LinkedHashMap();
        this._walletBoxesBalances = new LinkedHashMap();
        this._walletBoxSerializer = new WalletBoxSerializer(sidechainBoxesCompanion);
        this.loadWalletBoxes();
    }
}

