/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.horizen.SidechainTypes;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.box.Box;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.ForgerBox;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.WithdrawalRequestBoxSerializer;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.consensus.ForgingStakeInfo;
import com.horizen.consensus.ForgingStakeInfoSerializer$;
import com.horizen.consensus.package$;
import com.horizen.proposition.Proposition;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.RegularTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.utils.WithdrawalEpochInfoSerializer$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0014)\u0001=B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")Q\n\u0001C\u0001\u001d\"A!\u000b\u0001b\u0001\n\u0003Q3\u000b\u0003\u0004[\u0001\u0001\u0006I\u0001\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u00191\u0007\u0001)A\u0005;\"Aq\r\u0001b\u0001\n\u0003Q3\u000b\u0003\u0004i\u0001\u0001\u0006I\u0001\u0016\u0005\tS\u0002\u0011\r\u0011\"\u0001+'\"1!\u000e\u0001Q\u0001\nQC\u0001b\u001b\u0001C\u0002\u0013\u0005!f\u0015\u0005\u0007Y\u0002\u0001\u000b\u0011\u0002+\t\u000f5\u0004!\u0019!C\u0005]\"1a\u000f\u0001Q\u0001\n=Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\u0007{\u0002!\tA\u000b@\t\u0011\u0005\r\u0001\u0001\"\u0001+\u0003\u000bA\u0001\"!\u0004\u0001\t\u0003Q\u0013q\u0002\u0005\t\u0003+\u0001!\u0019!C\u0005'\"9\u0011q\u0003\u0001!\u0002\u0013!\u0006bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a/\u0001\t\u0003\ti\fC\u0004\u0003\n\u0001!IAa\u0003\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u0005U\u0019\u0016\u000eZ3dQ\u0006Lgn\u0015;bi\u0016\u001cFo\u001c:bO\u0016T!!\u000b\u0016\u0002\u000fM$xN]1hK*\u00111\u0006L\u0001\bQ>\u0014\u0018N_3o\u0015\u0005i\u0013aA2p[\u000e\u00011\u0003\u0002\u00011my\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011)H/\u001b7\u000b\u0003m\naa]2pe\u0016D\u0018BA\u001f9\u00055\u00196m\u001c:fq2{wmZ5oOB\u0011q\bQ\u0007\u0002U%\u0011\u0011I\u000b\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\t\u0019E)D\u0001)\u0013\t)\u0005FA\u0004Ti>\u0014\u0018mZ3\u0002/MLG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0007C\u0001%L\u001b\u0005I%B\u0001&+\u0003%\u0019w.\u001c9b]&|g.\u0003\u0002M\u0013\n92+\u001b3fG\"\f\u0017N\u001c\"pq\u0016\u001c8i\\7qC:LwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0003\u0016\u000b\u0005\u0002D\u0001!)\u0011f\u0001a\u0001\u0005\")ai\u0001a\u0001\u000f\u0006ir/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_Jl\u0017\r^5p].+\u00170F\u0001U!\t)\u0006,D\u0001W\u0015\t9&&A\u0003vi&d7/\u0003\u0002Z-\n\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM]\u0001\u001fo&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\u001c:nCRLwN\\&fs\u0002\n1d^5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A/\u0011\u0007Us\u0006-\u0003\u0002`-\nqA*[:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA1e\u001b\u0005\u0011'BA2+\u0003\r\u0011w\u000e_\u0005\u0003K\n\u0014AcV5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u\u0005>D\u0018\u0001H<ji\"$'/Y<bYJ+\u0017/^3tiN+'/[1mSj,'\u000fI\u0001\u0012G>t7/\u001a8tkN,\u0005o\\2i\u0017\u0016L\u0018AE2p]N,gn];t\u000bB|7\r[&fs\u0002\naCZ8sO&twm\u0015;bW\u0016\u001c\u0018)\\8v]R\\U-_\u0001\u0018M>\u0014x-\u001b8h'R\f7.Z:B[>,h\u000e^&fs\u0002\nACZ8sO&twm\u0015;bW\u0016\u001c\u0018J\u001c4p\u0017\u0016L\u0018!\u00064pe\u001eLgnZ*uC.,7/\u00138g_.+\u0017\u0010I\u0001\u001bM>\u0014x-\u001b8h'R\f7.Z%oM>\u001cVM]5bY&TXM]\u000b\u0002_B\u0019QK\u00189\u0011\u0005E$X\"\u0001:\u000b\u0005MT\u0013!C2p]N,gn];t\u0013\t)(O\u0001\tG_J<\u0017N\\4Ti\u0006\\W-\u00138g_\u0006Ybm\u001c:hS:<7\u000b^1lK&sgm\\*fe&\fG.\u001b>fe\u0002\nq$\u001e8eK\u001aLg.\u001a3XSRDGM]1xC2,\u0005o\\2i\u0007>,h\u000e^3s+\u0005I\bCA\u0019{\u0013\tY(GA\u0002J]R\f\u0001%\u001e8eK\u001aLg.\u001a3XSRDGM]1xC2,\u0005o\\2i\u0007>,h\u000e^3sA\u0005ar-\u001a;XSRDGM]1xC2,\u0005o\\2i\u0007>,h\u000e^3s\u0017\u0016LHC\u0001+\u0000\u0011\u0019\t\tA\u0005a\u0001s\u0006yq/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u0001\rhKR<\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f^:LKf$R\u0001VA\u0004\u0003\u0013Aa!!\u0001\u0014\u0001\u0004I\bBBA\u0006'\u0001\u0007\u00110A\u0004d_VtG/\u001a:\u0002+\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u00052|7m[&fsR\u0019A+!\u0005\t\r\u0005MA\u00031\u0001z\u0003\u0015)\u0007o\\2i\u0003=b\u0017m\u001d;XSRDGM]1xC2\u001cUM\u001d;jM&\u001c\u0017\r^3Qe\u00164\u0018n\\;t\u001b\u000e\u0014En\\2l\u0011\u0006\u001c\bnS3z\u0003Ab\u0017m\u001d;XSRDGM]1xC2\u001cUM\u001d;jM&\u001c\u0017\r^3Qe\u00164\u0018n\\;t\u001b\u000e\u0014En\\2l\u0011\u0006\u001c\bnS3zA\u0005a1-\u00197dk2\fG/Z&fsR\u0019A+!\b\t\u000f\u0005}q\u00031\u0001\u0002\"\u0005)!m\u001c=JIB)\u0011'a\t\u0002(%\u0019\u0011Q\u0005\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\nI#C\u0002\u0002,I\u0012AAQ=uK\u00061q-\u001a;C_b$B!!\r\u0002JA)\u0011'a\r\u00028%\u0019\u0011Q\u0007\u001a\u0003\r=\u0003H/[8o!\u0015\t\u0017\u0011HA\u001f\u0013\r\tYD\u0019\u0002\u0004\u0005>D\b\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r#&A\u0006qe>\u0004xn]5uS>t\u0017\u0002BA$\u0003\u0003\u00121\u0002\u0015:pa>\u001c\u0018\u000e^5p]\"9\u0011q\u0004\rA\u0002\u0005\u0005\u0012AF4fi^KG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8\u0016\u0005\u0005=\u0003#B\u0019\u00024\u0005E\u0003cA+\u0002T%\u0019\u0011Q\u000b,\u0003']KG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8\u00023\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM\u001d\u000b\u0004s\u0006m\u0003BBA\n5\u0001\u0007\u00110A\u000bhKR<\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f^:\u0015\t\u0005\u0005\u0014\u0011\u0010\t\u0006\u0003G\n\u0019\b\u0019\b\u0005\u0003K\nyG\u0004\u0003\u0002h\u00055TBAA5\u0015\r\tYGL\u0001\u0007yI|w\u000e\u001e \n\u0003MJ1!!\u001d3\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001e\u0002x\t\u00191+Z9\u000b\u0007\u0005E$\u0007\u0003\u0004\u0002\u0014m\u0001\r!_\u0001!O\u0016$XK\u001c9s_\u000e,7o]3e/&$\b\u000e\u001a:bo\u0006d'+Z9vKN$8\u000f\u0006\u0003\u0002\u0000\u0005\u0005\u0005#B\u0019\u00024\u0005\u0005\u0004BBA\n9\u0001\u0007\u00110A\fhKR\u001cuN\\:f]N,8/\u00129pG\"tU/\u001c2feV\u0011\u0011q\u0011\t\u0006c\u0005M\u0012\u0011\u0012\t\u0005\u0003\u0017\u000bYJ\u0004\u0003\u0002\u000e\u0006ee\u0002BAH\u0003/sA!!%\u0002\u0016:!\u0011qMAJ\u0013\u0005i\u0013BA\u0016-\u0013\t\u0019(&C\u0002\u0002rILA!!(\u0002 \n!2i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJT1!!\u001ds\u0003Y9W\r\u001e$pe\u001eLgnZ*uC.,7/Q7pk:$XCAAS!\u0015\t\u00141GAT!\r\t\u0014\u0011V\u0005\u0004\u0003W\u0013$\u0001\u0002'p]\u001e\fAcZ3u\r>\u0014x-\u001b8h'R\f7.Z:J]\u001a|WCAAY!\u0015\t\u00141GAZ!\u0015\t\u0019'a\u001dq\u0003!:W\r\u001e'bgR\u001cUM\u001d;jM&\u001c\u0017\r^3F]\u0012,\u0005o\\2i\u001b\u000e\u0014En\\2l\u0011\u0006\u001c\bn\u00149u+\t\tI\fE\u00032\u0003g\t\t#\u0001\u0004va\u0012\fG/\u001a\u000b\u0013\u0003\u007f\u000bI-!4\u0002R\u0006\u0015\u00181^Ax\u0003g\f9\u0010E\u0003\u0002B\u0006\u0015w*\u0004\u0002\u0002D*\u0011\u0011HM\u0005\u0005\u0003\u000f\f\u0019MA\u0002UefDa!a3\"\u0001\u0004!\u0016a\u0002<feNLwN\u001c\u0005\b\u0003\u001f\f\u0003\u0019AA)\u0003M9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p\u0011\u001d\t\u0019.\ta\u0001\u0003+\fQBY8y+B$\u0017\r^3MSN$\bCBAl\u0003?\f9D\u0004\u0003\u0002Z\u0006m\u0007cAA4e%\u0019\u0011Q\u001c\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t/a9\u0003\u0007M+GOC\u0002\u0002^JBq!a:\"\u0001\u0004\tI/A\bc_bLEm\u001d*f[>4XmU3u!\u0015\t9.a8U\u0011\u001d\ti/\ta\u0001\u0003C\n!d^5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u\u0003B\u0004XM\u001c3TKFDq!!=\"\u0001\u0004\t\u0019,\u0001\rg_J<\u0017N\\4Ti\u0006\\Wm\u001d+p\u0003B\u0004XM\u001c3TKFDq!!>\"\u0001\u0004\tI)\u0001\bd_:\u001cXM\\:vg\u0016\u0003xn\u00195\t\u000f\u0005e\u0018\u00051\u0001\u0002|\u0006ir/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ3si&4\u0017nY1uK>\u0003H\u000fE\u00032\u0003g\ti\u0010\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019AK\u0001\u0006E2|7m[\u0005\u0005\u0005\u000f\u0011\tA\u0001\u000eXSRDGM]1xC2,\u0005o\\2i\u0007\u0016\u0014H/\u001b4jG\u0006$X-A\rbaBd\u0017PR8sO&twm\u0015;bW\u0016\u001c8\t[1oO\u0016\u001cHC\u0002B\u0007\u0005'\u00119\u0002E\u00042\u0005\u001f\t\u0019,a*\n\u0007\tE!G\u0001\u0004UkBdWM\r\u0005\b\u0005+\u0011\u0003\u0019AAu\u00039\u0011w\u000e_%egR{'+Z7pm\u0016Dq!!=#\u0001\u0004\t\u0019,A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0003\u0005;\u0001B!MA\u001a)\u0006\u0001\"o\u001c7mE\u0006\u001c7NV3sg&|gn]\u000b\u0003\u0005G\u0001R!a\u0019\u0002tQ\u000b\u0001B]8mY\n\f7m\u001b\u000b\u0005\u0003\u007f\u0013I\u0003\u0003\u0004\u0002L\u0016\u0002\r\u0001V\u0001\bSN,U\u000e\u001d;z+\t\u0011y\u0003E\u00022\u0005cI1Aa\r3\u0005\u001d\u0011un\u001c7fC:\u0004")
public class SidechainStateStorage
implements ScorexLogging,
SidechainTypes {
    private final Storage storage;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final ByteArrayWrapper withdrawalEpochInformationKey;
    private final ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer;
    private final ByteArrayWrapper consensusEpochKey;
    private final ByteArrayWrapper forgingStakesAmountKey;
    private final ByteArrayWrapper forgingStakesInfoKey;
    private final ListSerializer<ForgingStakeInfo> forgingStakeInfoSerializer;
    private final int undefinedWithdrawalEpochCounter;
    private final ByteArrayWrapper lastWithdrawalCertificatePreviousMcBlockHashKey;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> regularTxToScbt(RegularTransaction t) {
        return SidechainTypes.regularTxToScbt$(this, t);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainNoncedBoxTxToScbt(SidechainTransaction<Proposition, NoncedBox<Proposition>> t) {
        return SidechainTypes.sidechainNoncedBoxTxToScbt$(this, t);
    }

    @Override
    public List<BoxTransaction<Proposition, Box<Proposition>>> regularTxListToScbtList(List<RegularTransaction> tl) {
        return SidechainTypes.regularTxListToScbtList$(this, tl);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainNoncedBoxTxListToScbtList(java.util.List<SidechainTransaction<Proposition, NoncedBox<Proposition>>> tl) {
        return SidechainTypes.sidechainNoncedBoxTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> regularBoxToScb(RegularBox b) {
        return SidechainTypes.regularBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> certifierRightBoxToScb(CertifierRightBox b) {
        return SidechainTypes.certifierRightBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> regularBoxJavaListToScbtJavaList(java.util.List<RegularBox> bl) {
        return SidechainTypes.regularBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> regularBoxListToScbtList(List<RegularBox> bl) {
        return SidechainTypes.regularBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public java.util.List<Box<Proposition>> certifierRightBoxJavaListToScbtJavaList(java.util.List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> certifierRightBoxListToScbtList(List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> regularBoxSetToScbSet(Set<RegularBox> bs) {
        return SidechainTypes.regularBoxSetToScbSet$(this, bs);
    }

    @Override
    public Set<Box<Proposition>> certifierRightBoxSetToScbSet(Set<CertifierRightBox> bs) {
        return SidechainTypes.certifierRightBoxSetToScbSet$(this, bs);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper withdrawalEpochInformationKey() {
        return this.withdrawalEpochInformationKey;
    }

    private ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer() {
        return this.withdrawalRequestSerializer;
    }

    public ByteArrayWrapper consensusEpochKey() {
        return this.consensusEpochKey;
    }

    public ByteArrayWrapper forgingStakesAmountKey() {
        return this.forgingStakesAmountKey;
    }

    public ByteArrayWrapper forgingStakesInfoKey() {
        return this.forgingStakesInfoKey;
    }

    private ListSerializer<ForgingStakeInfo> forgingStakeInfoSerializer() {
        return this.forgingStakeInfoSerializer;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getWithdrawalRequestsKey(int withdrawalEpoch, int counter) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getWithdrawalBlockKey(int epoch) {
        return this.calculateKey(new StringBuilder(19).append("Withdrawal block - ").append(epoch).toString().getBytes());
    }

    private ByteArrayWrapper lastWithdrawalCertificatePreviousMcBlockHashKey() {
        return this.lastWithdrawalCertificatePreviousMcBlockHashKey;
    }

    public ByteArrayWrapper calculateKey(byte[] boxId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.hash(boxId));
    }

    public Option<Box<Proposition>> getBox(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(this.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainBoxesCompanion.parseBytesTry(((io.iohk.iodb.ByteArrayWrapper)optional.get()).data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Box box = (Box)success.value();
                option2 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while WalletBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<WithdrawalEpochInfo> getWithdrawalEpochInfo() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochInformationKey())));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some.value());
            Try<WithdrawalEpochInfo> try_ = WithdrawalEpochInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochInfo withdrawalEpochInfo = (WithdrawalEpochInfo)success.value();
                option3 = Option$.MODULE$.apply((Object)withdrawalEpochInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch info information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some.value());
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<WithdrawalRequestBox> getWithdrawalRequests(int epoch) {
        void var2_2;
        ListBuffer withdrawalRequests = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(epoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getWithdrawalRequestsKey(epoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)((Object)((Object)some.value()));
                Try try_ = this.withdrawalRequestSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while withdrawal requests parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List wr = (java.util.List)success.value();
                withdrawalRequests.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(wr).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while withdrawal requests retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Option<Seq<WithdrawalRequestBox>> getUnprocessedWithdrawalRequests(int epoch) {
        Optional<ByteArrayWrapper> optional = this.storage.get(this.getWithdrawalBlockKey(epoch));
        Object object = optional.isPresent() ? None$.MODULE$ : new Some(this.getWithdrawalRequests(epoch));
        return object;
    }

    public Option<Object> getConsensusEpochNumber() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.consensusEpochKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some2.value());
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.intToConsensusEpochNumber(epoch)));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while consensus epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<Object> getForgingStakesAmount() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgingStakesAmountKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some2.value());
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Longs.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long epoch = BoxesRunTime.unboxToLong((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToLong((long)epoch));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while forging stakes amount parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<Seq<ForgingStakeInfo>> getForgingStakesInfo() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgingStakesInfoKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some2.value());
            Try try_ = this.forgingStakeInfoSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List stakesInfo = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(stakesInfo).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while forging stakes parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getLastCertificateEndEpochMcBlockHashOpt() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.lastWithdrawalCertificatePreviousMcBlockHashKey()))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    public Try<SidechainStateStorage> update(ByteArrayWrapper version, WithdrawalEpochInfo withdrawalEpochInfo, Set<Box<Proposition>> boxUpdateList, Set<ByteArrayWrapper> boxIdsRemoveSet, Seq<WithdrawalRequestBox> withdrawalRequestAppendSeq, Seq<ForgingStakeInfo> forgingStakesToAppendSeq, int consensusEpoch, Option<WithdrawalEpochCertificate> withdrawalEpochCertificateOpt) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Some some;
            WithdrawalEpochInfo storedEpochInfo;
            Object object2;
            Predef$.MODULE$.require(withdrawalEpochInfo != null, (Function0 & Serializable & scala.Serializable)() -> "WithdrawalEpochInfo must be NOT NULL.");
            Predef$.MODULE$.require(boxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Boxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!boxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Box to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveSet.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            Predef$.MODULE$.require(withdrawalRequestAppendSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of WithdrawalRequests to append must be NOT NULL. Use empty Seq instead.");
            Predef$.MODULE$.require(!withdrawalRequestAppendSeq.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WithdrawalRequest to append must be NOT NULL.");
            Predef$.MODULE$.require(forgingStakesToAppendSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of ForgerStakes to append must be NOT NULL. Use empty Seq instead.");
            Predef$.MODULE$.require(!forgingStakesToAppendSeq.contains(null), (Function0 & Serializable & scala.Serializable)() -> "ForgerStake to append must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)removeList.add(this.calculateKey(r.data()))));
            boxUpdateList.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.calculateKey(b.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(b))))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochInformationKey(), new ByteArrayWrapper(WithdrawalEpochInfoSerializer$.MODULE$.toBytes(withdrawalEpochInfo))));
            if (withdrawalRequestAppendSeq.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpochInfo.epoch()) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object2 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalRequestsKey(withdrawalEpochInfo.epoch(), nextWithdrawalEpochCounter), new ByteArrayWrapper(this.withdrawalRequestSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequestAppendSeq).asJava())))));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Option<WithdrawalEpochInfo> option = this.getWithdrawalEpochInfo();
            boolean bl = option instanceof Some ? (storedEpochInfo = (WithdrawalEpochInfo)(some = (Some)option).value()).epoch() != withdrawalEpochInfo.epoch() : false;
            boolean isWithdrawalEpochSwitched = bl;
            if (isWithdrawalEpochSwitched) {
                int withdrawalEpochNumberToRemove = withdrawalEpochInfo.epoch() - 2;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(withdrawalEpochNumberToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getWithdrawalRequestsKey(withdrawalEpochInfo.epoch() - 2, counter)));
                object = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getWithdrawalEpochCounterKey(withdrawalEpochNumberToRemove)));
            } else {
                object = BoxedUnit.UNIT;
            }
            withdrawalEpochCertificateOpt.map((Function1 & Serializable & scala.Serializable)withdrawalEpochCertificate -> BoxesRunTime.boxToBoolean((boolean)SidechainStateStorage.$anonfun$update$14(this, updateList, withdrawalEpochInfo, version, withdrawalEpochCertificate)));
            Object object3 = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.intToConsensusEpochNumber(0))) != consensusEpoch ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.consensusEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)consensusEpoch))))) : BoxedUnit.UNIT;
            Tuple2<Seq<ForgingStakeInfo>, Object> tuple2 = this.applyForgingStakesChanges(boxIdsRemoveSet, forgingStakesToAppendSeq);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq forgingStakesInfoSeq = (Seq)tuple2._1();
            long forgingStakesAmount = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)forgingStakesInfoSeq, (Object)BoxesRunTime.boxToLong((long)forgingStakesAmount));
            Tuple2 tuple23 = tuple22;
            Seq forgingStakesInfoSeq2 = (Seq)tuple23._1();
            long forgingStakesAmount2 = tuple23._2$mcJ$sp();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgingStakesInfoKey(), new ByteArrayWrapper(this.forgingStakeInfoSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(forgingStakesInfoSeq2).asJava()))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgingStakesAmountKey(), new ByteArrayWrapper(Longs.toByteArray((long)forgingStakesAmount2))));
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    private Tuple2<Seq<ForgingStakeInfo>, Object> applyForgingStakesChanges(Set<ByteArrayWrapper> boxIdsToRemove, Seq<ForgingStakeInfo> forgingStakesToAppendSeq) {
        Tuple2 tuple2;
        Option<Seq<ForgingStakeInfo>> option = this.getForgingStakesInfo();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq currentStakesInfoSeq = (Seq)some.value();
            Tuple2 tuple22 = currentStakesInfoSeq.partition((Function1 & Serializable & scala.Serializable)stakeInfo -> BoxesRunTime.boxToBoolean((boolean)boxIdsToRemove.contains((Object)new ByteArrayWrapper(stakeInfo.boxId()))));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Seq removedStakes = (Seq)tuple22._1();
            Seq existentStakes = (Seq)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)removedStakes, (Object)existentStakes);
            Tuple2 tuple24 = tuple23;
            Seq removedStakes2 = (Seq)tuple24._1();
            Seq existentStakes2 = (Seq)tuple24._2();
            long stakesAmount = BoxesRunTime.unboxToLong((Object)this.getForgingStakesAmount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedStakes2.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.value()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakesToAppendSeq.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.value()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            tuple2 = new Tuple2(existentStakes2.$plus$plus(forgingStakesToAppendSeq, Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToLong((long)stakesAmount));
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2(forgingStakesToAppendSeq, ((TraversableOnce)forgingStakesToAppendSeq.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.value()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainStateStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$update$14(SidechainStateStorage $this, ArrayList updateList$1, WithdrawalEpochInfo withdrawalEpochInfo$1, ByteArrayWrapper version$1, WithdrawalEpochCertificate withdrawalEpochCertificate) {
        updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getWithdrawalBlockKey(withdrawalEpochInfo$1.epoch() - 1), version$1));
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.lastWithdrawalCertificatePreviousMcBlockHashKey(), com.horizen.utils.package$.MODULE$.byteArrayToWrapper(withdrawalEpochCertificate.endEpochBlockHash())));
    }

    public SidechainStateStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this.withdrawalEpochInformationKey = this.calculateKey("withdrawalEpochInformation".getBytes());
        this.withdrawalRequestSerializer = new ListSerializer<WithdrawalRequestBox>(WithdrawalRequestBoxSerializer.getSerializer());
        this.consensusEpochKey = this.calculateKey("consensusEpoch".getBytes());
        this.forgingStakesAmountKey = this.calculateKey("forgingStakesAmount".getBytes());
        this.forgingStakesInfoKey = this.calculateKey("forgingStakes".getBytes());
        this.forgingStakeInfoSerializer = new ListSerializer<ForgingStakeInfo>(ForgingStakeInfoSerializer$.MODULE$);
        this.undefinedWithdrawalEpochCounter = -1;
        this.lastWithdrawalCertificatePreviousMcBlockHashKey = this.calculateKey("Previous MC block hash Key".getBytes());
    }
}

