/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.ForgerBox;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.companion.SidechainSecretsCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.secret.Secret;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.RegularTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\t\u0012\u0001aA\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)a\u0007\u0001C\u0001o!91\b\u0001b\u0001\n\u0013a\u0004BB)\u0001A\u0003%Q\bC\u0003S\u0001\u0011\u00051\u000bC\u0003\\\u0001\u0011%A\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0003a\u0001\u0011\u0005a\rC\u0003w\u0001\u0011\u0005q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010\u0003\u0004y\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u001bAq!a\u0005\u0001\t\u0003\t)B\u0001\fTS\u0012,7\r[1j]N+7M]3u'R|'/Y4f\u0015\t\u00112#A\u0004ti>\u0014\u0018mZ3\u000b\u0005Q)\u0012a\u00025pe&TXM\u001c\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M!\u0001!G\u0010$!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002'%\u0011!e\u0005\u0002\u000f'&$Wm\u00195bS:$\u0016\u0010]3t!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\rM\u001cwN]3y\u0013\tQSEA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003Y5j\u0011!E\u0005\u0003]E\u0011qa\u0015;pe\u0006<W-A\rtS\u0012,7\r[1j]N+7M]3ug\u000e{W\u000e]1oS>t\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\u0014\u0003%\u0019w.\u001c9b]&|g.\u0003\u00026e\tI2+\u001b3fG\"\f\u0017N\\*fGJ,Go]\"p[B\fg.[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u00051\u0002\u0001\"\u0002\n\u0004\u0001\u0004Y\u0003\"B\u0018\u0004\u0001\u0004\u0001\u0014aB:fGJ,Go]\u000b\u0002{A!ahQ#L\u001b\u0005y$B\u0001!B\u0003\u001diW\u000f^1cY\u0016T!AQ\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002E\u007f\tiA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"AR%\u000e\u0003\u001dS!\u0001S\n\u0002\u000bU$\u0018\u000e\\:\n\u0005);%\u0001\u0005\"zi\u0016\f%O]1z/J\f\u0007\u000f]3s!\tau*D\u0001N\u0015\tq5#\u0001\u0004tK\u000e\u0014X\r^\u0005\u0003!6\u0013aaU3de\u0016$\u0018\u0001C:fGJ,Go\u001d\u0011\u0002\u0019\r\fGnY;mCR,7*Z=\u0015\u0005\u0015#\u0006\"B+\u0007\u0001\u00041\u0016a\u00039s_B|7/\u001b;j_:\u0004\"aV-\u000e\u0003aS!!V\n\n\u0005iC&a\u0003)s_B|7/\u001b;j_:\f1\u0002\\8bIN+7M]3ugR\tQ\f\u0005\u0002\u001b=&\u0011ql\u0007\u0002\u0005+:LG/A\u0002hKR$\"AY3\u0011\u0007i\u00197*\u0003\u0002e7\t1q\n\u001d;j_:DQ!\u0016\u0005A\u0002Y#\"aZ:\u0011\u0007!\u00048J\u0004\u0002j]:\u0011!.\\\u0007\u0002W*\u0011AnF\u0001\u0007yI|w\u000e\u001e \n\u0003qI!a\\\u000e\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002p7!)A/\u0003a\u0001k\u0006a\u0001O]8q_NLG/[8ogB\u0019\u0001\u000e\u001d,\u0002\r\u001d,G/\u00117m+\u00059\u0017aA1eIR\u0011!p \t\u0004wvDT\"\u0001?\u000b\u0005\u0019Z\u0012B\u0001@}\u0005\r!&/\u001f\u0005\u0006\u001d.\u0001\ra\u0013\u000b\u0004u\u0006\r\u0001BBA\u0003\u0019\u0001\u0007q-\u0001\u0006tK\u000e\u0014X\r\u001e'jgR\faA]3n_Z,Gc\u0001>\u0002\f!)Q+\u0004a\u0001-R\u0019!0a\u0004\t\r\u0005Ea\u00021\u0001v\u0003=\u0001(o\u001c9pg&$\u0018n\u001c8MSN$\u0018aB5t\u000b6\u0004H/_\u000b\u0003\u0003/\u00012AGA\r\u0013\r\tYb\u0007\u0002\b\u0005>|G.Z1o\u0001")
public class SidechainSecretStorage
implements SidechainTypes,
ScorexLogging {
    private final Storage storage;
    private final SidechainSecretsCompanion sidechainSecretsCompanion;
    private final LinkedHashMap<ByteArrayWrapper, Secret> secrets;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> regularTxToScbt(RegularTransaction t) {
        return SidechainTypes.regularTxToScbt$(this, t);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainNoncedBoxTxToScbt(SidechainTransaction<Proposition, NoncedBox<Proposition>> t) {
        return SidechainTypes.sidechainNoncedBoxTxToScbt$(this, t);
    }

    @Override
    public List<BoxTransaction<Proposition, Box<Proposition>>> regularTxListToScbtList(List<RegularTransaction> tl) {
        return SidechainTypes.regularTxListToScbtList$(this, tl);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainNoncedBoxTxListToScbtList(java.util.List<SidechainTransaction<Proposition, NoncedBox<Proposition>>> tl) {
        return SidechainTypes.sidechainNoncedBoxTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> regularBoxToScb(RegularBox b) {
        return SidechainTypes.regularBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> certifierRightBoxToScb(CertifierRightBox b) {
        return SidechainTypes.certifierRightBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> regularBoxJavaListToScbtJavaList(java.util.List<RegularBox> bl) {
        return SidechainTypes.regularBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> regularBoxListToScbtList(List<RegularBox> bl) {
        return SidechainTypes.regularBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public java.util.List<Box<Proposition>> certifierRightBoxJavaListToScbtJavaList(java.util.List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> certifierRightBoxListToScbtList(List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> regularBoxSetToScbSet(Set<RegularBox> bs) {
        return SidechainTypes.regularBoxSetToScbSet$(this, bs);
    }

    @Override
    public Set<Box<Proposition>> certifierRightBoxSetToScbSet(Set<CertifierRightBox> bs) {
        return SidechainTypes.certifierRightBoxSetToScbSet$(this, bs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LinkedHashMap<ByteArrayWrapper, Secret> secrets() {
        return this.secrets;
    }

    public ByteArrayWrapper calculateKey(Proposition proposition) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.hash(proposition.bytes()));
    }

    private void loadSecrets() {
        this.secrets().clear();
        Buffer storageData = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala();
        ((IterableLike)((TraversableViewLike)storageData.view().map((Function1 & Serializable & scala.Serializable)keyToSecretBytes -> ((io.iohk.iodb.ByteArrayWrapper)keyToSecretBytes.getValue()).data(), SeqView$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)secretBytes -> (Secret)$this.sidechainSecretsCompanion.parseBytes((byte[])secretBytes), SeqView$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)secret -> this.secrets().put((Object)this.calculateKey(secret.publicImage()), secret));
    }

    public Option<Secret> get(Proposition proposition) {
        return this.secrets().get((Object)this.calculateKey(proposition));
    }

    public List<Secret> get(List<Proposition> propositions) {
        return (List)propositions.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.option2Iterable(this.secrets().get((Object)this.calculateKey((Proposition)p))), List$.MODULE$.canBuildFrom());
    }

    public List<Secret> getAll() {
        return this.secrets().values().toList();
    }

    public Try<SidechainSecretStorage> add(Secret secret) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "Secret must be NOT NULL.");
            byte[] version = new byte[32];
            ByteArrayWrapper key = this.calculateKey(secret.publicImage());
            Predef$.MODULE$.require(!this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(secret).toString());
            ByteArrayWrapper value = new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(secret));
            Random$.MODULE$.nextBytes(version);
            $this.storage.update(new ByteArrayWrapper(version), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, value), (List)Nil$.MODULE$)).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            this.secrets().put((Object)key, (Object)secret);
            return this;
        });
    }

    public Try<SidechainSecretStorage> add(List<Secret> secretList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!secretList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Secret must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            byte[] version = new byte[32];
            Random$.MODULE$.nextBytes(version);
            secretList.foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$add$6(this, updateList, s)));
            $this.storage.update(new ByteArrayWrapper(version), updateList, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(Proposition proposition) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(proposition != null, (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            byte[] version = new byte[32];
            ByteArrayWrapper key = this.calculateKey(proposition);
            Random$.MODULE$.nextBytes(version);
            $this.storage.update(new ByteArrayWrapper(version), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$)).asJava());
            this.secrets().remove((Object)key);
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(List<Proposition> propositionList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!propositionList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            byte[] version = new byte[32];
            Random$.MODULE$.nextBytes(version);
            propositionList.foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$remove$5(this, removeList, p)));
            $this.storage.update(new ByteArrayWrapper(version), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), removeList);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$6(SidechainSecretStorage $this, ArrayList updateList$1, Secret s) {
        ByteArrayWrapper key = $this.calculateKey(s.publicImage());
        Predef$.MODULE$.require(!$this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(s).toString());
        $this.secrets().put((Object)key, (Object)s);
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(s))));
    }

    public static final /* synthetic */ boolean $anonfun$remove$5(SidechainSecretStorage $this, ArrayList removeList$1, Proposition p) {
        ByteArrayWrapper key = $this.calculateKey(p);
        $this.secrets().remove((Object)key);
        return removeList$1.add(key);
    }

    public SidechainSecretStorage(Storage storage, SidechainSecretsCompanion sidechainSecretsCompanion) {
        this.storage = storage;
        this.sidechainSecretsCompanion = sidechainSecretsCompanion;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainSecretsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainSecretsCompanion must be NOT NULL.");
        this.secrets = new LinkedHashMap();
        this.loadSecrets();
    }
}

