/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReferenceData;
import com.horizen.block.MainchainHeader;
import com.horizen.block.SidechainBlock;
import com.horizen.block.SidechainBlockSerializer;
import com.horizen.chain.ActiveChain;
import com.horizen.chain.ActiveChain$;
import com.horizen.chain.MainchainBlockReferenceDataInfo;
import com.horizen.chain.MainchainHeaderInfo;
import com.horizen.chain.MainchainHeaderMetadata;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.chain.SidechainBlockInfoSerializer$;
import com.horizen.chain.package$;
import com.horizen.companion.SidechainTransactionsCompanion;
import com.horizen.node.util.MainchainBlockReferenceInfo;
import com.horizen.params.NetworkParams;
import com.horizen.storage.SidechainBlockInfoProvider;
import com.horizen.storage.Storage;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.vrf.VrfOutput;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.core.consensus.ModifierSemanticValidity;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u00181\u0001]B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001B\u0001B\u0003%Q\u000bC\u0003[\u0001\u0011\u00051\fC\u0004a\u0001\t\u0007I\u0011B1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u001dI\u0007A1A\u0005\n)Da!\u001d\u0001!\u0002\u0013Y\u0007\"\u0002:\u0001\t\u0013\u0019\b\"\u0002;\u0001\t\u0013)\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!!/\u0001\t\u0003\tY\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqAa\u000f\u0001\t\u0003\u0011i\u0004C\u0004\u0003H\u0001!\tA!\u0013\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003\f\u0002!\tA!$\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\"9!1\u0016\u0001\u0005\u0002\t5\u0006b\u0002BZ\u0001\u0011\u0005!Q\u0017\u0002\u0018'&$Wm\u00195bS:D\u0015n\u001d;pef\u001cFo\u001c:bO\u0016T!!\r\u001a\u0002\u000fM$xN]1hK*\u00111\u0007N\u0001\bQ>\u0014\u0018N_3o\u0015\u0005)\u0014aA2p[\u000e\u00011\u0003\u0002\u00019}\t\u0003\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007CA A\u001b\u0005\u0001\u0014BA!1\u0005i\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.LeNZ8Qe>4\u0018\u000eZ3s!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\rM\u001cwN]3y\u0013\tIEIA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003\u007f-K!\u0001\u0014\u0019\u0003\u000fM#xN]1hK\u0006q2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u001c8i\\7qC:LwN\u001c\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#J\n\u0011bY8na\u0006t\u0017n\u001c8\n\u0005M\u0003&AH*jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|gn]\"p[B\fg.[8o\u0003\u0019\u0001\u0018M]1ngB\u0011a\u000bW\u0007\u0002/*\u0011AKM\u0005\u00033^\u0013QBT3uo>\u00148\u000eU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003];z{\u0006CA \u0001\u0011\u0015\tD\u00011\u0001K\u0011\u0015iE\u00011\u0001O\u0011\u0015!F\u00011\u0001V\u00039\u0011Wm\u001d;CY>\u001c7.\u00133LKf,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KJ\nQ!\u001e;jYNL!a\u001a3\u0003!\tKH/Z!se\u0006LxK]1qa\u0016\u0014\u0018a\u00042fgR\u0014En\\2l\u0013\u0012\\U-\u001f\u0011\u0002\u0017\u0005\u001cG/\u001b<f\u0007\"\f\u0017N\\\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011aNM\u0001\u0006G\"\f\u0017N\\\u0005\u0003a6\u00141\"Q2uSZ,7\t[1j]\u0006a\u0011m\u0019;jm\u0016\u001c\u0005.Y5oA\u0005yAn\\1e\u0003\u000e$\u0018N^3DQ\u0006Lg\u000eF\u0001l\u0003-1\u0018\r\\5eSRL8*Z=\u0015\u0005\t4\b\"B<\u000b\u0001\u0004A\u0018a\u00022m_\u000e\\\u0017\n\u001a\t\u0004s\u0006\u001dab\u0001>\u0002\u00049\u001910!\u0001\u000f\u0005q|X\"A?\u000b\u0005y4\u0014A\u0002\u001fs_>$h(C\u0001H\u0013\t)e)C\u0002\u0002\u0006\u0011\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!AC'pI&4\u0017.\u001a:JI*\u0019\u0011Q\u0001#\u0002\u0019\tdwnY6J]\u001a|7*Z=\u0015\u0007\t\f\t\u0002C\u0003x\u0017\u0001\u0007\u00010A\u0006oKb$h+\u001a:tS>tWCAA\f!\u0015I\u0014\u0011DA\u000f\u0013\r\tYB\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004s\u0005}\u0011bAA\u0011u\t!!)\u001f;f\u0003\u0019AW-[4iiV\u0011\u0011q\u0005\t\u0004s\u0005%\u0012bAA\u0016u\t\u0019\u0011J\u001c;\u0002\u0011!,\u0017n\u001a5u\u001f\u001a$B!!\r\u00028A)\u0011(a\r\u0002(%\u0019\u0011Q\u0007\u001e\u0003\r=\u0003H/[8o\u0011\u00159h\u00021\u0001y\u0003-\u0011Wm\u001d;CY>\u001c7.\u00133\u0016\u0003a\f\u0011BY3ti\ncwnY6\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d#'A\u0003cY>\u001c7.\u0003\u0003\u0002L\u0005\u0015#AD*jI\u0016\u001c\u0007.Y5o\u00052|7m[\u0001\u000eE\u0016\u001cHO\u00117pG.LeNZ8\u0016\u0005\u0005E\u0003c\u00017\u0002T%\u0019\u0011QK7\u0003%MKG-Z2iC&t'\t\\8dW&sgm\\\u0001\nE2|7m\u001b\"z\u0013\u0012$B!a\u0017\u0002^A)\u0011(a\r\u0002B!)qO\u0005a\u0001q\u0006i!\r\\8dW&sgm\u001c\"z\u0013\u0012$B!!\u0015\u0002d!)qo\u0005a\u0001q\u0006\u0019\"\r\\8dW&sgm\\(qi&|gNQ=JIR!\u0011\u0011NA6!\u0015I\u00141GA)\u0011\u00159H\u00031\u0001y\u00035\u0001\u0018M]3oi\ncwnY6JIR!\u0011\u0011OA:!\u0011I\u00141\u0007=\t\u000b],\u0002\u0019\u0001=\u0002\u001b\rD\u0017-\u001b8TG>\u0014XMR8s)\u0011\tI(!!\u0011\u000be\n\u0019$a\u001f\u0011\u0007e\ni(C\u0002\u0002\u0000i\u0012A\u0001T8oO\")qO\u0006a\u0001q\u0006y\u0011n]%o\u0003\u000e$\u0018N^3DQ\u0006Lg\u000e\u0006\u0003\u0002\b\u00065\u0005cA\u001d\u0002\n&\u0019\u00111\u0012\u001e\u0003\u000f\t{w\u000e\\3b]\")qo\u0006a\u0001q\u0006\u0011\u0012m\u0019;jm\u0016\u001c\u0005.Y5o\u00052|7m[%e)\u0011\t\t(a%\t\u000f\u0005\r\u0002\u00041\u0001\u0002(\u0005\u0001\u0012m\u0019;jm\u0016\u001c\u0005.Y5o\u0003\u001a$XM\u001d\u000b\u0005\u00033\u000bI\u000bE\u0003\u0002\u001c\u0006\r\u0006P\u0004\u0003\u0002\u001e\u0006\u0005fb\u0001?\u0002 &\t1(C\u0002\u0002\u0006iJA!!*\u0002(\n\u00191+Z9\u000b\u0007\u0005\u0015!\bC\u0003x3\u0001\u0007\u00010\u0001\u0016hKR\u001c\u0016\u000eZ3dQ\u0006LgN\u00117pG.\u001cuN\u001c;bS:LgnZ'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:\u0015\t\u0005m\u0013q\u0016\u0005\b\u0003cS\u0002\u0019AA\f\u0003Mi\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014\b*Y:i\u0003E:W\r^*jI\u0016\u001c\u0007.Y5o\u00052|7m[\"p]R\f\u0017N\\5oO6\u000b\u0017N\\2iC&t'+\u001a4fe\u0016t7-\u001a#bi\u0006$B!a\u0017\u00028\"9\u0011\u0011W\u000eA\u0002\u0005]\u0011\u0001I4fi6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,')\u001f%bg\"$B!!0\u0002FB)\u0011(a\r\u0002@B!\u00111IAa\u0013\u0011\t\u0019-!\u0012\u0003/5\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0007bBAY9\u0001\u0007\u0011qC\u0001\u0019O\u0016$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'OQ=ICNDG\u0003BAf\u0003'\u0004R!OA\u001a\u0003\u001b\u0004B!a\u0011\u0002P&!\u0011\u0011[A#\u0005=i\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014\bbBAY;\u0001\u0007\u0011qC\u0001 O\u0016$X*Y5oG\"\f\u0017N\u001c*fM\u0016\u0014XM\\2f\t\u0006$\u0018MQ=ICNDG\u0003BAm\u0003C\u0004R!OA\u001a\u00037\u0004B!a\u0011\u0002^&!\u0011q\\A#\u0005mi\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC\"9\u0011\u0011\u0017\u0010A\u0002\u0005]\u0011\u0001N4fi6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0017J\u001c4p\u0005fl\u0015-\u001b8dQ\u0006LgN\u00117pG.DU-[4iiR!\u0011q]A|!\u0015I\u00141GAu!\u0011\tY/a=\u000e\u0005\u00055(bA#\u0002p*\u0019\u0011\u0011\u001f\u001a\u0002\t9|G-Z\u0005\u0005\u0003k\fiOA\u000eNC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK&sgm\u001c\u0005\b\u0003s|\u0002\u0019AA\u0014\u0003=i\u0017-\u001b8dQ\u0006Lg\u000eS3jO\"$\u0018AI4fi\n+7\u000f^'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\u0013:4w.\u0006\u0002\u0002h\u0006!s-\u001a;NC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK&sgm\u001c\"z\u0011\u0006\u001c\b\u000e\u0006\u0003\u0002h\n\r\u0001bBAYC\u0001\u0007\u0011qC\u0001!EVLG\u000eZ'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\u0013:4w\u000e\u0006\u0007\u0002j\n%!Q\u0005B\u0018\u0005g\u00119\u0004C\u0004\u0003\f\t\u0002\rA!\u0004\u0002\r5\u001c\u0007*Y:i!\u0011\u0011yAa\b\u000f\t\tE!Q\u0004\b\u0005\u0005'\u0011YB\u0004\u0003\u0003\u0016\teab\u0001?\u0003\u0018%\tQ'\u0003\u00024i%\u0011aNM\u0005\u0004\u0003\u000bi\u0017\u0002\u0002B\u0011\u0005G\u00111#T1j]\u000eD\u0017-\u001b8IK\u0006$WM\u001d%bg\"T1!!\u0002n\u0011\u001d\u00119C\ta\u0001\u0005S\tQB]3gKJ,gnY3J]\u001a|\u0007c\u00017\u0003,%\u0019!QF7\u0003/5\u000b\u0017N\\2iC&t\u0007*Z1eKJlU\r^1eCR\f\u0007b\u0002B\u0019E\u0001\u0007\u0011qE\u0001\u000e[\u000e\u0014En\\2l\u0011\u0016Lw\r\u001b;\t\r\tU\"\u00051\u0001y\u0003}i\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u00148+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u0005\u0007\u0005s\u0011\u0003\u0019\u0001=\u0002M5\f\u0017N\\2iC&t'+\u001a4fe\u0016t7-\u001a#bi\u0006\u001c\u0016\u000eZ3dQ\u0006LgN\u00117pG.LE-\u0001\u000fhKRl\u0015-\u001b8dQ\u0006Lg\u000eS1tQ\u0016\u001chi\u001c:J]\u0012,\u00070Z:\u0015\t\t}\"\u0011\t\t\u0007\u00037\u000b\u0019K!\u0004\t\u000f\t\r3\u00051\u0001\u0003F\u0005\u0001R.Y5oG\"\f\u0017N\u001c%fS\u001eDGo\u001d\t\u0007\u00037\u000b\u0019+a\n\u00025\u001d,GOQ3ti6\u000b\u0017N\\2iC&t\u0007*Z1eKJLeNZ8\u0016\u0005\t-\u0003#B\u001d\u00024\t5\u0003c\u00017\u0003P%\u0019!\u0011K7\u0003'5\u000b\u0017N\\2iC&t\u0007*Z1eKJLeNZ8\u0002=\u001d,G/T1j]\u000eD\u0017-\u001b8IK\u0006$WM]%oM>\u0014\u0015\u0010S3jO\"$H\u0003\u0002B&\u0005/Bq!!?&\u0001\u0004\t9#\u0001\u000fhKRl\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014\u0018J\u001c4p\u0005fD\u0015m\u001d5\u0015\t\t-#Q\f\u0005\b\u0003c3\u0003\u0019AA\f\u0003\u0019:W\r\u001e\"fgRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC&sgm\\\u000b\u0003\u0005G\u0002R!OA\u001a\u0005K\u00022\u0001\u001cB4\u0013\r\u0011I'\u001c\u0002 \u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016$\u0015\r^1J]\u001a|\u0017AK4fi6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4wNQ=IK&<\u0007\u000e\u001e\u000b\u0005\u0005G\u0012y\u0007C\u0004\u0002z\"\u0002\r!a\n\u0002Q\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0017J\u001c4p\u0005fD\u0015m\u001d5\u0015\t\t\r$Q\u000f\u0005\b\u0003cK\u0003\u0019AA\f\u0003\u0019)\b\u000fZ1uKR1!1\u0010BC\u0005\u000f\u0003RA! \u0003\u0002rk!Aa \u000b\u0005\u0015S\u0014\u0002\u0002BB\u0005\u007f\u00121\u0001\u0016:z\u0011\u001d\t9E\u000ba\u0001\u0003\u0003BqA!#+\u0001\u0004\t\t&A\u0005cY>\u001c7.\u00138g_\u0006\u00012/Z7b]RL7MV1mS\u0012LG/\u001f\u000b\u0005\u0005\u001f\u0013y\n\u0005\u0003\u0003\u0012\nmUB\u0001BJ\u0015\u0011\u0011)Ja&\u0002\u0013\r|gn]3ogV\u001c(b\u0001BM\r\u0006!1m\u001c:f\u0013\u0011\u0011iJa%\u000315{G-\u001b4jKJ\u001cV-\\1oi&\u001cg+\u00197jI&$\u0018\u0010C\u0003xW\u0001\u0007\u00010\u0001\fva\u0012\fG/Z*f[\u0006tG/[2WC2LG-\u001b;z)\u0019\u0011YH!*\u0003(\"9\u0011q\t\u0017A\u0002\u0005\u0005\u0003b\u0002BUY\u0001\u0007!qR\u0001\u0007gR\fG/^:\u0002\u001dM,G/Q:CKN$(\t\\8dWR1!1\u0010BX\u0005cCq!a\u0012.\u0001\u0004\t\t\u0005C\u0004\u0003\n6\u0002\r!!\u0015\u0002\u000f%\u001cX)\u001c9usV\u0011\u0011q\u0011")
public class SidechainHistoryStorage
implements SidechainBlockInfoProvider,
ScorexLogging {
    private final Storage storage;
    private final SidechainTransactionsCompanion sidechainTransactionsCompanion;
    private final NetworkParams params;
    private final ByteArrayWrapper bestBlockIdKey;
    private final ActiveChain activeChain;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ByteArrayWrapper bestBlockIdKey() {
        return this.bestBlockIdKey;
    }

    private ActiveChain activeChain() {
        return this.activeChain;
    }

    private ActiveChain loadActiveChain() {
        if (this.height() == 0) {
            return ActiveChain$.MODULE$.apply(this.params.mainchainCreationBlockHeight());
        }
        ArrayBuffer activeChainBlocksInfo = new ArrayBuffer(this.height());
        activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.bestBlockId(), (Object)this.blockInfoById(this.bestBlockId()))}));
        while (((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).height() > 1) {
            String id = ((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).parentId();
            activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)id, (Object)this.blockInfoById(id))}));
        }
        ArrayBuffer orderedChainBlocks = (ArrayBuffer)activeChainBlocksInfo.reverse();
        Option mainchainBlockParent = orderedChainBlocks.headOption().flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlockInfo -> this.blockById((String)firstSidechainBlockInfo._1()).flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlock -> firstSidechainBlock.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)firstMainchainHeader -> package$.MODULE$.byteArrayToMainchainHeaderHash(firstMainchainHeader.hashPrevBlock()))));
        return ActiveChain$.MODULE$.apply((ArrayBuffer<Tuple2<String, SidechainBlockInfo>>)orderedChainBlocks, (ByteArrayWrapper)((Object)mainchainBlockParent.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Loaded active chain miss mainchain parent");
        })), this.params.mainchainCreationBlockHeight());
    }

    private ByteArrayWrapper validityKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(8).append("validity").append(blockId).toString()));
    }

    private ByteArrayWrapper blockInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(9).append("blockInfo").append(blockId).toString()));
    }

    /*
     * WARNING - void declaration
     */
    private byte[] nextVersion() {
        void var1_1;
        byte[] version = new byte[32];
        Random$.MODULE$.nextBytes(version);
        return var1_1;
    }

    public int height() {
        return BoxesRunTime.unboxToInt((Object)this.heightOf(this.bestBlockId()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public Option<Object> heightOf(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.height()));
    }

    public String bestBlockId() {
        return (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.bestBlockIdKey()))).map((Function1 & Serializable & scala.Serializable)d -> scorex.util.package$.MODULE$.bytesToId(d.data())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.params.sidechainGenesisBlockId());
    }

    public SidechainBlock bestBlock() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return (SidechainBlock)this.blockById(this.bestBlockId()).get();
    }

    public SidechainBlockInfo bestBlockInfo() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return this.blockInfoById(this.bestBlockId());
    }

    public Option<SidechainBlock> blockById(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(blockId))))).flatMap((Function1 & Serializable & scala.Serializable)baw -> {
            Try<SidechainBlock> tryBlock = new SidechainBlockSerializer($this.sidechainTransactionsCompanion).parseBytesTry(baw.data());
            Try<SidechainBlock> try_ = tryBlock;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("SidechainHistoryStorage: Failed to parse block bytes from storage.", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return tryBlock.toOption();
        });
    }

    @Override
    public SidechainBlockInfo blockInfoById(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionById(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(24).append("No block info for block ").append(blockId).toString());
        });
    }

    public Option<SidechainBlockInfo> blockInfoOptionById(String blockId) {
        None$ none$;
        if (this.activeChain() != null && this.activeChain().contains(blockId)) {
            return this.activeChain().blockInfoById(blockId);
        }
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.blockInfoKey(blockId))));
        if (option instanceof Some) {
            None$ none$2;
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some.value());
            Try<SidechainBlockInfo> try_ = SidechainBlockInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("SidechainHistoryStorage: Failed to parse block info bytes from storage.", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$2 = None$.MODULE$;
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainBlockInfo blockInfo = (SidechainBlockInfo)success.value();
                none$2 = new Some((Object)blockInfo);
            } else {
                throw new MatchError(try_);
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public Option<String> parentBlockId(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parentId());
    }

    public Option<Object> chainScoreFor(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()));
    }

    public boolean isInActiveChain(String blockId) {
        return this.activeChain().contains(blockId);
    }

    public Option<String> activeChainBlockId(int height) {
        return this.activeChain().idByHeight(height);
    }

    public Seq<String> activeChainAfter(String blockId) {
        return this.activeChain().chainAfter(blockId);
    }

    public Option<SidechainBlock> getSidechainBlockContainingMainchainHeader(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcHeader(package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<SidechainBlock> getSidechainBlockContainingMainchainReferenceData(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcReferenceData(package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<MainchainBlockReference> getMainchainBlockReferenceByHash(byte[] mainchainHeaderHash) {
        return this.getMainchainHeaderByHash(mainchainHeaderHash).flatMap((Function1 & Serializable & scala.Serializable)header -> this.getMainchainReferenceDataByHash(mainchainHeaderHash).map((Function1 & Serializable & scala.Serializable)data -> new MainchainBlockReference((MainchainHeader)header, (MainchainBlockReferenceData)data)));
    }

    public Option<MainchainHeader> getMainchainHeaderByHash(byte[] mainchainHeaderHash) {
        Option<SidechainBlock> sidechainBlock = this.getSidechainBlockContainingMainchainHeader(mainchainHeaderHash);
        return sidechainBlock.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)SidechainHistoryStorage.$anonfun$getMainchainHeaderByHash$2(mainchainHeaderHash, header))));
    }

    public Option<MainchainBlockReferenceData> getMainchainReferenceDataByHash(byte[] mainchainHeaderHash) {
        Option<SidechainBlock> sidechainBlock = this.getSidechainBlockContainingMainchainReferenceData(mainchainHeaderHash);
        return sidechainBlock.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mainchainBlockReferencesData().find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)SidechainHistoryStorage.$anonfun$getMainchainReferenceDataByHash$2(mainchainHeaderHash, data))));
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByMainchainBlockHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).flatMap((Function1 & Serializable & scala.Serializable)hash -> this.getMainchainBlockReferenceInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)((Object)hash))));
    }

    public Option<MainchainBlockReferenceInfo> getBestMainchainBlockReferenceInfo() {
        return this.getMainchainBlockReferenceInfoByMainchainBlockHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainBlockReferenceInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    private MainchainBlockReferenceInfo buildMainchainBlockReferenceInfo(ByteArrayWrapper mcHash, MainchainHeaderMetadata referenceInfo, int mcBlockHeight, String mainchainHeaderSidechainBlockId, String mainchainReferenceDataSidechainBlockId) {
        return new MainchainBlockReferenceInfo(com.horizen.utils.package$.MODULE$.wrapperToByteArray(mcHash), com.horizen.utils.package$.MODULE$.wrapperToByteArray(referenceInfo.getParentId()), mcBlockHeight, scorex.util.package$.MODULE$.idToBytes(mainchainHeaderSidechainBlockId), scorex.util.package$.MODULE$.idToBytes(mainchainReferenceDataSidechainBlockId));
    }

    public Seq<ByteArrayWrapper> getMainchainHashesForIndexes(Seq<Object> mainchainHeights) {
        return (Seq)mainchainHeights.flatMap((Function1 & Serializable & scala.Serializable)mainchainHeight -> Option$.MODULE$.option2Iterable(this.activeChain().mcHashByMcHeight(BoxesRunTime.unboxToInt((Object)mainchainHeight))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<MainchainHeaderInfo> getBestMainchainHeaderInfo() {
        return this.getMainchainHeaderInfoByHeight(this.activeChain().heightOfMcHeaders());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainHeaderInfo)this.getMainchainHeaderInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)((Object)mcHash))).get());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcHeadersHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Option<MainchainBlockReferenceDataInfo> getBestMainchainBlockReferenceDataInfo() {
        return this.getMainchainBlockReferenceDataInfoByHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainBlockReferenceDataInfo)this.getMainchainBlockReferenceDataInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)((Object)mcHash))).get());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainBlockReferenceDataInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Try<SidechainHistoryStorage> update(SidechainBlock block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(block != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBlock must be NOT NULL.");
            String string = block.parentId();
            String string2 = blockInfo.parentId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Passed BlockInfo data conflicts to passed Block.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes())));
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(block.id())), new ByteArrayWrapper(block.bytes())));
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public ModifierSemanticValidity semanticValidity(String blockId) {
        ModifierSemanticValidity.Absent$ absent$;
        Option<SidechainBlockInfo> option = this.blockInfoOptionById(blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainBlockInfo info = (SidechainBlockInfo)some.value();
            absent$ = info.semanticValidity();
        } else if (None$.MODULE$.equals(option)) {
            absent$ = ModifierSemanticValidity.Absent$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return absent$;
    }

    public Try<SidechainHistoryStorage> updateSemanticValidity(SidechainBlock block, ModifierSemanticValidity status) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainBlockInfo oldInfo = (SidechainBlockInfo)this.activeChain().blockInfoById(block.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoById(block.id()));
            ModifierSemanticValidity x$1 = status;
            int x$2 = oldInfo.copy$default$1();
            long x$3 = oldInfo.copy$default$2();
            String x$4 = oldInfo.copy$default$3();
            long x$5 = oldInfo.copy$default$4();
            Seq<ByteArrayWrapper> x$6 = oldInfo.copy$default$6();
            Seq<ByteArrayWrapper> x$7 = oldInfo.copy$default$7();
            WithdrawalEpochInfo x$8 = oldInfo.copy$default$8();
            Option<VrfOutput> x$9 = oldInfo.copy$default$9();
            String x$10 = oldInfo.copy$default$10();
            SidechainBlockInfo blockInfo = oldInfo.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<SidechainHistoryStorage> setAsBestBlock(SidechainBlock block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.bestBlockIdKey(), new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(block.id())))}), new ArrayList<ByteArrayWrapper>());
            Option mainchainParent = block.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)header -> package$.MODULE$.byteArrayToMainchainHeaderHash(header.hashPrevBlock()));
            this.activeChain().setBestBlock(block.id(), blockInfo, (Option<ByteArrayWrapper>)mainchainParent);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderByHash$2(byte[] mainchainHeaderHash$2, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$2)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.hash()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainReferenceDataByHash$2(byte[] mainchainHeaderHash$3, MainchainBlockReferenceData data) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$3)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(data.headerHash()));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$1, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)headerContainingId -> $this.activeChain().idByMcReferenceData(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)dataContainingId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$1).map((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.buildMainchainBlockReferenceInfo(mcHash$1, (MainchainHeaderMetadata)mcMetadata, mcHeight, (String)headerContainingId, (String)dataContainingId))));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainHeaderInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$2, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)sidechainBlockId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$2).map((Function1 & Serializable & scala.Serializable)mcMetadata -> new MainchainHeaderInfo(mcHash$2, mcMetadata.getParentId(), mcHeight, (String)sidechainBlockId)));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceDataInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$3, int mcHeight) {
        return $this.activeChain().idByMcReferenceData(mcHash$3).map((Function1 & Serializable & scala.Serializable)sidechainBlockId -> new MainchainBlockReferenceDataInfo(mcHash$3, mcHeight, (String)sidechainBlockId));
    }

    public SidechainHistoryStorage(Storage storage, SidechainTransactionsCompanion sidechainTransactionsCompanion, NetworkParams params) {
        this.storage = storage;
        this.sidechainTransactionsCompanion = sidechainTransactionsCompanion;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainTransactionsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainTransactionsCompanion must be NOT NULL.");
        Predef$.MODULE$.require(params != null, (Function0 & Serializable & scala.Serializable)() -> "params must be NOT NULL.");
        this.bestBlockIdKey = new ByteArrayWrapper((byte[])Array$.MODULE$.fill(32, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Byte()));
        this.activeChain = this.loadActiveChain();
    }
}

