/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.ForgerBox;
import com.horizen.box.ForgerBoxSerializer;
import com.horizen.box.NoncedBox;
import com.horizen.box.RegularBox;
import com.horizen.consensus.package$ConsensusEpochNumber$;
import com.horizen.proposition.Proposition;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.RegularTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.ForgerBoxMerklePathInfo;
import com.horizen.utils.ForgerBoxMerklePathInfoSerializer$;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u000b\u0017\u0001uA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0007q\u0001!\t\u0001G\u001d\t\u0011Q\u0003!\u0019!C\u00011UCaA\u0016\u0001!\u0002\u0013Q\u0004\u0002C,\u0001\u0005\u0004%\t\u0001\u0007-\t\rq\u0003\u0001\u0015!\u0003Z\u0011!i\u0006A1A\u0005\u0002aq\u0006BB3\u0001A\u0003%q\f\u0003\u0005g\u0001\t\u0007I\u0011\u0001\rh\u0011\u0019y\u0007\u0001)A\u0005Q\")\u0001\u000f\u0001C\u0005+\")\u0011\u000f\u0001C\u0001e\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\t9bi\u001c:hS:<'i\u001c=fg&sgm\\*u_J\fw-\u001a\u0006\u0003/a\tqa\u001d;pe\u0006<WM\u0003\u0002\u001a5\u00059\u0001n\u001c:ju\u0016t'\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001qB\u0005\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\r\n\u0005\u001dB\"AD*jI\u0016\u001c\u0007.Y5o)f\u0004Xm\u001d\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0004tG>\u0014X\r_\u0005\u0003_)\u0012QbU2pe\u0016DHj\\4hS:<\u0007CA\u00193\u001b\u00051\u0012BA\u001a\u0017\u0005\u001d\u0019Fo\u001c:bO\u0016\fa\u0001P5oSRtDC\u0001\u001c8!\t\t\u0004\u0001C\u0003\u0018\u0005\u0001\u0007\u0001'\u0001\u0005fa>\u001c\u0007nS3z)\tQ\u0004\t\u0005\u0002<}5\tAH\u0003\u0002>1\u0005)Q\u000f^5mg&\u0011q\b\u0010\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJDQ!Q\u0002A\u0002\t\u000bQ!\u001a9pG\"\u0004\"aQ)\u000f\u0005\u0011seBA#M\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002J9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!!\u0014\r\u0002\u0013\r|gn]3ogV\u001c\u0018BA(Q\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u0014\r\n\u0005I\u001b&\u0001F\"p]N,gn];t\u000bB|7\r\u001b(v[\n,'O\u0003\u0002P!\u0006qam\u001c:hKJ\u0014u\u000e_3t\u0017\u0016LX#\u0001\u001e\u0002\u001f\u0019|'oZ3s\u0005>DXm]&fs\u0002\nq#\\1y\u001dVl'-\u001a:PMN#xN]3e\u000bB|7\r[:\u0016\u0003e\u0003\"a\b.\n\u0005m\u0003#aA%oi\u0006AR.\u0019=Ok6\u0014WM](g'R|'/\u001a3Fa>\u001c\u0007n\u001d\u0011\u0002K\u0019|'oZ3s\u0005>DX*\u001a:lY\u0016\u0004\u0016\r\u001e5J]\u001a|G*[:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A0\u0011\u0007m\u0002'-\u0003\u0002by\tqA*[:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\u001ed\u0013\t!GHA\fG_J<WM\u001d\"pq6+'o\u001b7f!\u0006$\b.\u00138g_\u00061cm\u001c:hKJ\u0014u\u000e_'fe.dW\rU1uQ&sgm\u001c'jgR\u001cVM]5bY&TXM\u001d\u0011\u0002/\u0019|'oZ3s\u0005>DH*[:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014X#\u00015\u0011\u0007m\u0002\u0017\u000e\u0005\u0002k[6\t1N\u0003\u0002m1\u0005\u0019!m\u001c=\n\u00059\\'!\u0003$pe\u001e,'OQ8y\u0003a1wN]4fe\n{\u0007\u0010T5tiN+'/[1mSj,'\u000fI\u0001\f]\u0016DHOV3sg&|g.A\u000fva\u0012\fG/\u001a$pe\u001e,'OQ8y\u001b\u0016\u00148\u000e\\3QCRD\u0017J\u001c4p)\r\u0019\b0\u001f\t\u0004iZ4T\"A;\u000b\u0005-\u0002\u0013BA<v\u0005\r!&/\u001f\u0005\u0006\u00036\u0001\rA\u0011\u0005\u0006u6\u0001\ra_\u0001\u0015E>DX*\u001a:lY\u0016\u0004\u0016\r\u001e5J]\u001a|7+Z9\u0011\tq\f\tA\u0019\b\u0003{~t!a\u0012@\n\u0003\u0005J!a\u0014\u0011\n\t\u0005\r\u0011Q\u0001\u0002\u0004'\u0016\f(BA(!\u0003E)\b\u000fZ1uK\u001a{'oZ3s\u0005>DXm\u001d\u000b\bg\u0006-\u0011qBA\u000b\u0011\u0019\tiA\u0004a\u0001u\u00059a/\u001a:tS>t\u0007bBA\t\u001d\u0001\u0007\u00111C\u0001\u0017M>\u0014x-\u001a:C_b,7\u000fV8BaB,g\u000eZ*fcB!A0!\u0001j\u0011\u001d\t9B\u0004a\u0001\u00033\tqBY8y\u0013\u0012\u001c(+Z7pm\u0016\u001cV-\u001d\t\u0006y\u0006\u0005\u00111\u0004\t\u0006?\u0005u\u0011\u0011E\u0005\u0004\u0003?\u0001#!B!se\u0006L\bcA\u0010\u0002$%\u0019\u0011Q\u0005\u0011\u0003\t\tKH/Z\u0001\u000fO\u0016$hi\u001c:hKJ\u0014u\u000e_3t+\t\tY\u0003E\u0003 \u0003[\t\u0019\"C\u0002\u00020\u0001\u0012aa\u00149uS>t\u0017AI4fi\u001a{'oZ3s\u0005>DX*\u001a:lY\u0016\u0004\u0016\r\u001e5J]\u001a|gi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u00026\u0005]\u0002\u0003B\u0010\u0002.mDQ!\u0011\tA\u0002\t\u000bQ\u0002\\1tiZ+'o]5p]&#WCAA\u001f!\u0011y\u0012Q\u0006\u001e\u0002!I|G\u000e\u001c2bG.4VM]:j_:\u001cXCAA\"!\u0011a\u0018Q\t\u001e\n\t\u0005\u001d\u0013Q\u0001\u0002\u0005\u0019&\u001cH/\u0001\u0005s_2d'-Y2l)\r\u0019\u0018Q\n\u0005\u0007\u0003\u001b\u0019\u0002\u0019\u0001\u001e\u0002\u000f%\u001cX)\u001c9usV\u0011\u00111\u000b\t\u0004?\u0005U\u0013bAA,A\t9!i\\8mK\u0006t\u0007")
public class ForgingBoxesInfoStorage
implements SidechainTypes,
ScorexLogging {
    private final Storage storage;
    private final ByteArrayWrapper forgerBoxesKey;
    private final int maxNumberOfStoredEpochs;
    private final ListSerializer<ForgerBoxMerklePathInfo> forgerBoxMerklePathInfoListSerializer;
    private final ListSerializer<ForgerBox> forgerBoxListSerializer;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> regularTxToScbt(RegularTransaction t) {
        return SidechainTypes.regularTxToScbt$(this, t);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainNoncedBoxTxToScbt(SidechainTransaction<Proposition, NoncedBox<Proposition>> t) {
        return SidechainTypes.sidechainNoncedBoxTxToScbt$(this, t);
    }

    @Override
    public List<BoxTransaction<Proposition, Box<Proposition>>> regularTxListToScbtList(List<RegularTransaction> tl) {
        return SidechainTypes.regularTxListToScbtList$(this, tl);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainNoncedBoxTxListToScbtList(java.util.List<SidechainTransaction<Proposition, NoncedBox<Proposition>>> tl) {
        return SidechainTypes.sidechainNoncedBoxTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> regularBoxToScb(RegularBox b) {
        return SidechainTypes.regularBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> certifierRightBoxToScb(CertifierRightBox b) {
        return SidechainTypes.certifierRightBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> regularBoxJavaListToScbtJavaList(java.util.List<RegularBox> bl) {
        return SidechainTypes.regularBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> regularBoxListToScbtList(List<RegularBox> bl) {
        return SidechainTypes.regularBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public java.util.List<Box<Proposition>> certifierRightBoxJavaListToScbtJavaList(java.util.List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> certifierRightBoxListToScbtList(List<CertifierRightBox> bl) {
        return SidechainTypes.certifierRightBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> regularBoxSetToScbSet(Set<RegularBox> bs) {
        return SidechainTypes.regularBoxSetToScbSet$(this, bs);
    }

    @Override
    public Set<Box<Proposition>> certifierRightBoxSetToScbSet(Set<CertifierRightBox> bs) {
        return SidechainTypes.certifierRightBoxSetToScbSet$(this, bs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper epochKey(int epoch) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("epoch").append(epoch).toString()));
    }

    public ByteArrayWrapper forgerBoxesKey() {
        return this.forgerBoxesKey;
    }

    public int maxNumberOfStoredEpochs() {
        return this.maxNumberOfStoredEpochs;
    }

    public ListSerializer<ForgerBoxMerklePathInfo> forgerBoxMerklePathInfoListSerializer() {
        return this.forgerBoxMerklePathInfoListSerializer;
    }

    public ListSerializer<ForgerBox> forgerBoxListSerializer() {
        return this.forgerBoxListSerializer;
    }

    private ByteArrayWrapper nextVersion() {
        byte[] version = new byte[32];
        Option<ByteArrayWrapper> option = this.lastVersionId();
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper lastVersion = (ByteArrayWrapper)((Object)some.value());
            new Random(lastVersion.hashCode()).nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Random$.MODULE$.nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return new ByteArrayWrapper(version);
    }

    public Try<ForgingBoxesInfoStorage> updateForgerBoxMerklePathInfo(int epoch, Seq<ForgerBoxMerklePathInfo> boxMerklePathInfoSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxMerklePathInfoSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of boxMerklePathInfoSeq to append must be NOT NULL. Use empty Seq instead.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            removeList.add(this.epochKey(BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)(epoch - this.maxNumberOfStoredEpochs())), package.Tagger$.MODULE$.baseRaw()))));
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.epochKey(epoch), new ByteArrayWrapper(this.forgerBoxMerklePathInfoListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(boxMerklePathInfoSeq).asJava()))));
            $this.storage.update(this.nextVersion(), updateList, removeList);
            return this;
        });
    }

    public Try<ForgingBoxesInfoStorage> updateForgerBoxes(ByteArrayWrapper version, Seq<ForgerBox> forgerBoxesToAppendSeq, Seq<byte[]> boxIdsRemoveSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            Seq currentForgerBoxSeq = (Seq)this.getForgerBoxes().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            Seq existentForgerBoxSeq = (Seq)currentForgerBoxSeq.filterNot((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)boxIdsRemoveSeq.exists((Function1 & Serializable & scala.Serializable)removedId -> BoxesRunTime.boxToBoolean((boolean)ForgingBoxesInfoStorage.$anonfun$updateForgerBoxes$4(box, removedId)))));
            Seq newForgerBoxSeq = (Seq)existentForgerBoxSeq.$plus$plus((GenTraversableOnce)forgerBoxesToAppendSeq, Seq$.MODULE$.canBuildFrom());
            Object object = existentForgerBoxSeq.size() != currentForgerBoxSeq.size() || forgerBoxesToAppendSeq.nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerBoxesKey(), new ByteArrayWrapper(this.forgerBoxListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(newForgerBoxSeq).asJava()))))) : BoxedUnit.UNIT;
            $this.storage.update(version, toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<Seq<ForgerBox>> getForgerBoxes() {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgerBoxesKey())));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some2.value());
            Try try_ = this.forgerBoxListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List forgerBoxes = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(forgerBoxes).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while forger boxes list parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<ForgerBoxMerklePathInfo>> getForgerBoxMerklePathInfoForEpoch(int epoch) {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.epochKey(epoch))));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)((Object)some2.value());
            Try try_ = this.forgerBoxMerklePathInfoListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List boxMerklePathsInfo = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(boxMerklePathsInfo).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while box merkle paths info parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<ForgingBoxesInfoStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$updateForgerBoxes$4(ForgerBox box$1, byte[] removedId) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(box$1.id())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(removedId));
    }

    public ForgingBoxesInfoStorage(Storage storage) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.forgerBoxesKey = new ByteArrayWrapper(Blake2b256$.MODULE$.hash("forgerBoxesKey".getBytes()));
        this.maxNumberOfStoredEpochs = 3;
        this.forgerBoxMerklePathInfoListSerializer = new ListSerializer<ForgerBoxMerklePathInfo>(ForgerBoxMerklePathInfoSerializer$.MODULE$);
        this.forgerBoxListSerializer = new ListSerializer<ForgerBox>(ForgerBoxSerializer.getSerializer());
    }
}

