/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.secret;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.cryptolibprovider.VrfFunctions;
import com.horizen.node.NodeWallet;
import com.horizen.secret.Secret;
import com.horizen.secret.SecretCreator;
import com.horizen.secret.VrfSecretKey;
import java.util.EnumMap;
import java.util.List;
import scorex.crypto.hash.Blake2b256;

public class VrfKeyGenerator
implements SecretCreator<VrfSecretKey> {
    private static VrfKeyGenerator instance = new VrfKeyGenerator();

    private VrfKeyGenerator() {
    }

    public static VrfKeyGenerator getInstance() {
        return instance;
    }

    @Override
    public VrfSecretKey generateSecret(byte[] seed) {
        EnumMap<VrfFunctions.KeyType, byte[]> keys = CryptoLibProvider.vrfFunctions().generatePublicAndSecretKeys(seed);
        return new VrfSecretKey(keys.get((Object)VrfFunctions.KeyType.SECRET), keys.get((Object)VrfFunctions.KeyType.PUBLIC));
    }

    @Override
    public VrfSecretKey generateNextSecret(NodeWallet wallet) {
        List<Secret> prevSecrets = wallet.secretsOfType(VrfSecretKey.class);
        byte[] nonce = Ints.toByteArray((int)prevSecrets.size());
        byte[] seed = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{wallet.walletSeed(), nonce}));
        return this.generateSecret(seed);
    }
}

