/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import com.horizen.proposition.Proposition;
import com.horizen.proposition.PropositionSerializer;
import com.horizen.serialization.JsonHorizenPublicKeyHashSerializer;
import com.horizen.serialization.Views;
import com.horizen.utils.BytesUtils;
import java.util.Arrays;

@JsonView(value={Views.Default.class})
public final class MCPublicKeyHashProposition
implements Proposition {
    public static final int KEY_LENGTH = 20;
    @JsonProperty(value="publicKey")
    @JsonSerialize(using=JsonHorizenPublicKeyHashSerializer.class)
    private byte[] pubKeyHashBytes;

    public MCPublicKeyHashProposition(byte[] bytes) {
        if (bytes.length != 20) {
            throw new IllegalArgumentException(String.format("Incorrect pubKeyHash length, %d expected, %d found", 20, bytes.length));
        }
        this.pubKeyHashBytes = Arrays.copyOf(bytes, 20);
    }

    @Override
    public byte[] bytes() {
        return Arrays.copyOf(this.pubKeyHashBytes, 20);
    }

    @Override
    public PropositionSerializer serializer() {
        return MCPublicKeyHashPropositionSerializer.getSerializer();
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubKeyHashBytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MCPublicKeyHashProposition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.pubKeyHashBytes, ((MCPublicKeyHashProposition)obj).bytes());
    }

    public String toString() {
        return BytesUtils.toHexString(this.pubKeyHashBytes);
    }

    public static MCPublicKeyHashProposition parseBytes(byte[] bytes) {
        return new MCPublicKeyHashProposition(bytes);
    }

    public static int getLength() {
        return 20;
    }
}

