/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proof;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.CoreProofsIdsEnum;
import com.horizen.proof.ProofOfKnowledge;
import com.horizen.proof.ProofSerializer;
import com.horizen.proof.VrfProofSerializer;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.secret.VrfSecretKey;
import com.horizen.serialization.Views;
import com.horizen.vrf.VrfOutput;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"typeId"})
public final class VrfProof
implements ProofOfKnowledge<VrfSecretKey, VrfPublicKey> {
    private final byte[] proofBytes;

    public VrfProof(byte[] proof) {
        Objects.requireNonNull(proof, "Vrf proof can't be null");
        this.proofBytes = Arrays.copyOf(proof, proof.length);
    }

    public Optional<VrfOutput> proofToVrfOutput(VrfPublicKey publicKey, byte[] message) {
        return CryptoLibProvider.vrfFunctions().proofToOutput(publicKey.pubKeyBytes(), message, this.proofBytes).map(VrfOutput::new);
    }

    @Override
    public boolean isValid(VrfPublicKey proposition, byte[] message) {
        return CryptoLibProvider.vrfFunctions().verifyProof(message, proposition.pubKeyBytes(), this.proofBytes);
    }

    @Override
    @JsonProperty(value="vrfProof")
    public byte[] bytes() {
        return Arrays.copyOf(this.proofBytes, this.proofBytes.length);
    }

    @Override
    public ProofSerializer serializer() {
        return VrfProofSerializer.getSerializer();
    }

    @Override
    public byte proofTypeId() {
        return CoreProofsIdsEnum.VrfProofId.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VrfProof vrfProof = (VrfProof)o;
        return Arrays.equals(this.proofBytes, vrfProof.proofBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.proofBytes);
    }

    public static VrfProof parse(byte[] bytes) {
        return new VrfProof(bytes);
    }

    public String toString() {
        return "VrfProof{proofBytes=" + ByteUtils.toHexString((byte[])this.proofBytes) + '}';
    }
}

