/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proof;

import com.horizen.proof.AbstractSignature25519;
import com.horizen.proof.CoreProofsIdsEnum;
import com.horizen.proof.ProofSerializer;
import com.horizen.proof.Signature25519Serializer;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.secret.PrivateKey25519;
import com.horizen.utils.Ed25519;
import java.util.Arrays;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class Signature25519
extends AbstractSignature25519<PrivateKey25519, PublicKey25519Proposition> {
    public static int SIGNATURE_LENGTH = Ed25519.signatureLength();

    public Signature25519(byte[] signatureBytes) {
        super(signatureBytes);
        if (signatureBytes.length != SIGNATURE_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect signature length, %d expected, %d found", SIGNATURE_LENGTH, signatureBytes.length));
        }
    }

    @Override
    public byte proofTypeId() {
        return CoreProofsIdsEnum.Signature25519Id.id();
    }

    @Override
    public byte[] bytes() {
        return Arrays.copyOf(this.signatureBytes, SIGNATURE_LENGTH);
    }

    @Override
    public ProofSerializer serializer() {
        return Signature25519Serializer.getSerializer();
    }

    public static Signature25519 parseBytes(byte[] bytes) {
        return new Signature25519(bytes);
    }

    public String toString() {
        return "Signature25519{signatureBytes=" + ByteUtils.toHexString((byte[])this.signatureBytes) + '}';
    }
}

