/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proof;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.CoreProofsIdsEnum;
import com.horizen.proof.ProofOfKnowledge;
import com.horizen.proof.ProofSerializer;
import com.horizen.proof.SchnorrSignatureSerializer;
import com.horizen.proposition.SchnorrProposition;
import com.horizen.secret.SchnorrSecret;
import com.horizen.serialization.Views;
import java.util.Arrays;
import java.util.Objects;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"typeId"})
public class SchnorrProof
implements ProofOfKnowledge<SchnorrSecret, SchnorrProposition> {
    private final byte[] signature;

    public SchnorrProof(byte[] signatureBytes) {
        Objects.requireNonNull(signatureBytes, "SchnorrProofBytes can't be null");
        this.signature = Arrays.copyOf(signatureBytes, signatureBytes.length);
    }

    @Override
    public byte proofTypeId() {
        return CoreProofsIdsEnum.SchnorrSignatureId.id();
    }

    @Override
    public boolean isValid(SchnorrProposition publicKey, byte[] message) {
        return CryptoLibProvider.schnorrFunctions().verify(message, publicKey.pubKeyBytes(), this.signature);
    }

    @Override
    public byte[] bytes() {
        return Arrays.copyOf(this.signature, this.signature.length);
    }

    @Override
    public ProofSerializer serializer() {
        return SchnorrSignatureSerializer.getSerializer();
    }

    public static SchnorrProof parse(byte[] bytes) {
        return new SchnorrProof(bytes);
    }
}

