/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.node.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.CommonParams;
import com.horizen.node.util.MainchainBlockReferenceInfoSerializer;
import com.horizen.serialization.Views;
import com.horizen.utils.BytesUtils;
import java.util.Arrays;
import java.util.Objects;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;

@JsonView(value={Views.Default.class})
public final class MainchainBlockReferenceInfo
implements BytesSerializable {
    @JsonProperty(value="hash")
    private byte[] mainchainHeaderHash;
    @JsonProperty(value="parentHash")
    private byte[] parentMainchainHeaderHash;
    @JsonProperty(value="height")
    private int mainchainHeight;
    private byte[] mainchainHeaderSidechainBlockId;
    private byte[] mainchainReferenceDataSidechainBlockId;

    public MainchainBlockReferenceInfo(byte[] mainchainHeaderHash, byte[] parentMainchainHeaderHash, int mainchainHeight, byte[] mainchainHeaderSidechainBlockId, byte[] mainchainReferenceDataSidechainBlockId) {
        assert (mainchainHeaderHash.length == CommonParams.mainchainBlockHashLength());
        this.mainchainHeaderHash = Arrays.copyOf(mainchainHeaderHash, mainchainHeaderHash.length);
        assert (parentMainchainHeaderHash.length == CommonParams.mainchainBlockHashLength());
        this.parentMainchainHeaderHash = Arrays.copyOf(parentMainchainHeaderHash, parentMainchainHeaderHash.length);
        this.mainchainHeight = mainchainHeight;
        assert (mainchainHeaderSidechainBlockId.length == CommonParams.sidechainIdLength());
        this.mainchainHeaderSidechainBlockId = Arrays.copyOf(mainchainHeaderSidechainBlockId, mainchainHeaderSidechainBlockId.length);
        assert (mainchainReferenceDataSidechainBlockId.length == CommonParams.sidechainIdLength());
        this.mainchainReferenceDataSidechainBlockId = Arrays.copyOf(mainchainReferenceDataSidechainBlockId, mainchainReferenceDataSidechainBlockId.length);
    }

    public byte[] getMainchainHeaderHash() {
        return this.mainchainHeaderHash;
    }

    public byte[] getParentMainchainHeaderHash() {
        return this.parentMainchainHeaderHash;
    }

    public int getMainchainHeight() {
        return this.mainchainHeight;
    }

    public byte[] getMainchainHeaderSidechainBlockId() {
        return this.mainchainHeaderSidechainBlockId;
    }

    public byte[] getMainchainReferenceDataSidechainBlockId() {
        return this.mainchainReferenceDataSidechainBlockId;
    }

    public static MainchainBlockReferenceInfo parseBytes(byte[] bytes) {
        int offset = 0;
        byte[] mainchainBlockReferenceHash = Arrays.copyOfRange(bytes, offset, offset + CommonParams.mainchainBlockHashLength());
        byte[] parentMainchainBlockReferenceHash = Arrays.copyOfRange(bytes, offset += CommonParams.mainchainBlockHashLength(), offset + CommonParams.mainchainBlockHashLength());
        int mainchainHeight = BytesUtils.getInt(bytes, offset += CommonParams.mainchainBlockHashLength());
        byte[] mainchainHeaderSidechainBlockId = Arrays.copyOfRange(bytes, offset += 4, offset + CommonParams.sidechainIdLength());
        byte[] mainchainReferenceDataSidechainBlockId = Arrays.copyOfRange(bytes, offset += CommonParams.sidechainIdLength(), offset + CommonParams.sidechainIdLength());
        offset += CommonParams.sidechainIdLength();
        return new MainchainBlockReferenceInfo(mainchainBlockReferenceHash, parentMainchainBlockReferenceHash, mainchainHeight, mainchainHeaderSidechainBlockId, mainchainReferenceDataSidechainBlockId);
    }

    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{this.mainchainHeaderHash, this.parentMainchainHeaderHash, Ints.toByteArray((int)this.mainchainHeight), this.mainchainHeaderSidechainBlockId, this.mainchainReferenceDataSidechainBlockId});
    }

    public ScorexSerializer<BytesSerializable> serializer() {
        return MainchainBlockReferenceInfoSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainchainBlockReferenceInfo that = (MainchainBlockReferenceInfo)o;
        return this.mainchainHeight == that.mainchainHeight && Arrays.equals(this.mainchainHeaderHash, that.mainchainHeaderHash) && Arrays.equals(this.parentMainchainHeaderHash, that.parentMainchainHeaderHash) && Arrays.equals(this.mainchainHeaderSidechainBlockId, that.mainchainHeaderSidechainBlockId) && Arrays.equals(this.mainchainReferenceDataSidechainBlockId, that.mainchainReferenceDataSidechainBlockId);
    }

    public int hashCode() {
        int result = Objects.hash(this.mainchainHeight);
        result = 31 * result + Arrays.hashCode(this.mainchainHeaderHash);
        result = 31 * result + Arrays.hashCode(this.parentMainchainHeaderHash);
        result = 31 * result + Arrays.hashCode(this.mainchainHeaderSidechainBlockId);
        result = 31 * result + Arrays.hashCode(this.mainchainReferenceDataSidechainBlockId);
        return result;
    }
}

