/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.mainchain.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.horizen.SidechainSettings;
import com.horizen.mainchain.api.MainchainNodeApi;
import com.horizen.mainchain.api.SendCertificateRequest;
import com.horizen.mainchain.api.SendCertificateResponse;
import com.horizen.mainchain.api.SidechainInfoResponse;
import com.horizen.serialization.ApplicationJsonSerializer;
import com.horizen.utils.BytesUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import scala.Function0;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154Aa\u0003\u0007\u0001+!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003#\u0011\u00159\u0003\u0001\"\u0001)\u0011!Y\u0003\u0001#b\u0001\n\u0013a\u0003\"\u0002\u0019\u0001\t\u0013\t\u0004\"B#\u0001\t\u00131\u0005\"B(\u0001\t\u0013\u0001\u0006\"B*\u0001\t\u0013!\u0006\"\u0002,\u0001\t\u0003:\u0006\"B.\u0001\t\u0003b&a\u0005*qG6\u000b\u0017N\\2iC&tgj\u001c3f\u0003BL'BA\u0007\u000f\u0003\r\t\u0007/\u001b\u0006\u0003\u001fA\t\u0011\"\\1j]\u000eD\u0017-\u001b8\u000b\u0005E\u0011\u0012a\u00025pe&TXM\u001c\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\tib$D\u0001\r\u0013\tyBB\u0001\tNC&t7\r[1j]:{G-Z!qS\u0006\t2/\u001b3fG\"\f\u0017N\\*fiRLgnZ:\u0016\u0003\t\u0002\"a\t\u0013\u000e\u0003AI!!\n\t\u0003#MKG-Z2iC&t7+\u001a;uS:<7/\u0001\ntS\u0012,7\r[1j]N+G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002*UA\u0011Q\u0004\u0001\u0005\u0006A\r\u0001\rAI\u0001\fSN|5oV5oI><8/F\u0001.!\t9b&\u0003\u000201\t9!i\\8mK\u0006t\u0017!\u0004>f]\u000ec\u0017nQ8n[\u0006tG-F\u00013!\r\u0019\u0004HO\u0007\u0002i)\u0011QGN\u0001\u0005kRLGNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$!C!se\u0006LH*[:u!\tY$I\u0004\u0002=\u0001B\u0011Q\bG\u0007\u0002})\u0011q\bF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005C\u0012A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011\r\u0002\u000f\r\fG\u000e\u001c*qGR\u0011!h\u0012\u0005\u0006\u0011\u001a\u0001\r!S\u0001\u0003a\n\u0004\"AS'\u000e\u0003-S!\u0001\u0014\u001c\u0002\t1\fgnZ\u0005\u0003\u001d.\u0013a\u0002\u0015:pG\u0016\u001c8OQ;jY\u0012,'/\u0001\u000bf]\u000edwn]3Kg>t\u0007+\u0019:b[\u0016$XM\u001d\u000b\u0003uECQAU\u0004A\u0002i\n\u0011\u0002]1sC6,G/\u001a:\u0002-\u0015t7\r\\8tKN#(/\u001b8h!\u0006\u0014\u0018-\\3uKJ$\"AO+\t\u000bIC\u0001\u0019\u0001\u001e\u0002!\u001d,GoU5eK\u000eD\u0017-\u001b8J]\u001a|W#\u0001-\u0011\u0005uI\u0016B\u0001.\r\u0005U\u0019\u0016\u000eZ3dQ\u0006Lg.\u00138g_J+7\u000f]8og\u0016\fqb]3oI\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0003;\u0002\u0004\"!\b0\n\u0005}c!aF*f]\u0012\u001cUM\u001d;jM&\u001c\u0017\r^3SKN\u0004xN\\:f\u0011\u0015\t'\u00021\u0001c\u0003I\u0019WM\u001d;jM&\u001c\u0017\r^3SKF,Xm\u001d;\u0011\u0005u\u0019\u0017B\u00013\r\u0005Y\u0019VM\u001c3DKJ$\u0018NZ5dCR,'+Z9vKN$\b")
public class RpcMainchainNodeApi
implements MainchainNodeApi {
    private boolean isOsWindows;
    private final SidechainSettings sidechainSettings;
    private volatile boolean bitmap$0;

    public SidechainSettings sidechainSettings() {
        return this.sidechainSettings;
    }

    private boolean isOsWindows$lzycompute() {
        RpcMainchainNodeApi rpcMainchainNodeApi = this;
        synchronized (rpcMainchainNodeApi) {
            if (!this.bitmap$0) {
                String osname = System.getProperty("os.name", "generic").toLowerCase();
                this.isOsWindows = osname.contains("win");
                this.bitmap$0 = true;
            }
        }
        return this.isOsWindows;
    }

    private boolean isOsWindows() {
        return !this.bitmap$0 ? this.isOsWindows$lzycompute() : this.isOsWindows;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<String> zenCliCommand() {
        void var2_1;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.sidechainSettings().websocket().zencliCommandLine());
        String string = this.sidechainSettings().genesisData().mcNetwork();
        Boolean bl = "regtest".equals(string) ? BoxesRunTime.boxToBoolean((boolean)command.add("-regtest")) : ("testnet".equals(string) ? BoxesRunTime.boxToBoolean((boolean)command.add("-testnet")) : BoxedUnit.UNIT);
        command.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.sidechainSettings().websocket().zencliCommandLineArguments().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).asJava());
        return var2_1;
    }

    private String callRpc(ProcessBuilder pb) {
        System.out.println(pb.command());
        Process process = pb.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String error = stdError.readLine();
        if (error != null) {
            throw new IllegalStateException(new StringBuilder(7).append("Error: ").append(error).toString());
        }
        return stdInput.readLine();
    }

    private String encloseJsonParameter(String parameter) {
        return this.isOsWindows() ? new StringBuilder(2).append("\"").append(parameter.replace("\"", "\\\"")).append("\"").toString() : parameter;
    }

    private String encloseStringParameter(String parameter) {
        return new StringBuilder(2).append("\"").append(parameter).append("\"").toString();
    }

    @Override
    public SidechainInfoResponse getSidechainInfo() {
        ObjectMapper objectMapper = new ObjectMapper();
        String response = this.callRpc(new ProcessBuilder("getscinfo"));
        return (SidechainInfoResponse)objectMapper.readValue(response, SidechainInfoResponse.class);
    }

    @Override
    public SendCertificateResponse sendCertificate(SendCertificateRequest certificateRequest) {
        ApplicationJsonSerializer serializer = ApplicationJsonSerializer.getInstance();
        serializer.setDefaultConfiguration();
        ObjectMapper objectMapper = serializer.getObjectMapper();
        objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        ArrayList<String> command = this.zenCliCommand();
        command.add("send_certificate");
        command.add(BytesUtils.toHexString(certificateRequest.sidechainId()));
        command.add(((Object)BoxesRunTime.boxToInteger((int)certificateRequest.epochNumber())).toString());
        command.add(((Object)BoxesRunTime.boxToLong((long)certificateRequest.quality())).toString());
        command.add(BytesUtils.toHexString(certificateRequest.endEpochBlockHash()));
        command.add(BytesUtils.toHexString(certificateRequest.proofBytes()));
        command.add(this.encloseJsonParameter(objectMapper.writeValueAsString(certificateRequest.backwardTransfers())));
        command.add(certificateRequest.fee().toString());
        ProcessBuilder pb = new ProcessBuilder(command);
        String response = this.callRpc(pb);
        return new SendCertificateResponse(BytesUtils.fromHexString(response));
    }

    public RpcMainchainNodeApi(SidechainSettings sidechainSettings) {
        this.sidechainSettings = sidechainSettings;
    }
}

