/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.cryptolibprovider.VrfFunctions;
import com.horizen.utils.Utils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;

public class VrfFunctionsImpl
implements VrfFunctions {
    private static int vrfLength = 32;

    @Override
    public EnumMap<VrfFunctions.KeyType, byte[]> generatePublicAndSecretKeys(byte[] seed) {
        byte[] secretAndPublic = new byte[vrfLength];
        Arrays.fill(secretAndPublic, (byte)Objects.hash(new BigInteger(1, seed)));
        EnumMap<VrfFunctions.KeyType, byte[]> res = new EnumMap<VrfFunctions.KeyType, byte[]>(VrfFunctions.KeyType.class);
        res.put(VrfFunctions.KeyType.PUBLIC, Arrays.copyOf(secretAndPublic, secretAndPublic.length));
        res.put(VrfFunctions.KeyType.SECRET, Arrays.copyOf(secretAndPublic, secretAndPublic.length));
        return res;
    }

    @Override
    public boolean verifyProof(byte[] messageBytes, byte[] publicKeyBytes, byte[] proofBytes) {
        byte[] messageWithCorrectLength = Utils.doubleSHA256Hash(messageBytes);
        byte[] decoded = Arrays.copyOf(proofBytes, proofBytes.length);
        for (int i = 0; i < decoded.length; ++i) {
            decoded[i] = (byte)(decoded[i] ^ publicKeyBytes[0]);
        }
        return Arrays.equals(messageWithCorrectLength, decoded);
    }

    @Override
    public boolean publicKeyIsValid(byte[] publicKeyBytes) {
        return publicKeyBytes.length == vrfLength;
    }

    @Override
    public Optional<byte[]> proofToOutput(byte[] publicKeyBytes, byte[] message, byte[] proofBytes) {
        assert (proofBytes.length == vrfLength);
        int xorByte = proofBytes[0] ^ proofBytes[proofBytes.length - 1];
        if (this.verifyProof(message, publicKeyBytes, proofBytes)) {
            byte[] vrfOutput = Arrays.copyOf(proofBytes, proofBytes.length);
            for (int i = 0; i < vrfOutput.length; ++i) {
                vrfOutput[i] = (byte)(vrfOutput[i] ^ xorByte);
            }
            return Optional.of(vrfOutput);
        }
        return Optional.empty();
    }

    @Override
    public EnumMap<VrfFunctions.ProofType, byte[]> createProof(byte[] secretKeyBytes, byte[] publicKeyBytes, byte[] message) {
        byte[] messageWithCorrectLength = Utils.doubleSHA256Hash(message);
        byte[] proofBytes = Arrays.copyOf(messageWithCorrectLength, messageWithCorrectLength.length);
        for (int i = 0; i < proofBytes.length; ++i) {
            proofBytes[i] = (byte)(proofBytes[i] ^ secretKeyBytes[0]);
        }
        byte[] vrfOutputBytes = this.proofToOutput(publicKeyBytes, message, proofBytes).get();
        EnumMap<VrfFunctions.ProofType, byte[]> proofsMap = new EnumMap<VrfFunctions.ProofType, byte[]>(VrfFunctions.ProofType.class);
        proofsMap.put(VrfFunctions.ProofType.VRF_PROOF, proofBytes);
        proofsMap.put(VrfFunctions.ProofType.VRF_OUTPUT, vrfOutputBytes);
        return proofsMap;
    }

    @Override
    public int vrfSecretKeyLength() {
        return vrfLength;
    }

    @Override
    public int vrfPublicKeyLen() {
        return vrfLength;
    }

    @Override
    public int vrfProofLen() {
        return vrfLength;
    }

    @Override
    public int vrfOutputLen() {
        return vrfLength;
    }
}

