/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.cryptolibprovider.FieldElementUtils;
import com.horizen.cryptolibprovider.SchnorrFunctions;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.schnorrnative.SchnorrKeyPair;
import com.horizen.schnorrnative.SchnorrPublicKey;
import com.horizen.schnorrnative.SchnorrSecretKey;
import com.horizen.schnorrnative.SchnorrSignature;
import java.util.EnumMap;

public class SchnorrFunctionsImplZendoo
implements SchnorrFunctions {
    @Override
    public EnumMap<SchnorrFunctions.KeyType, byte[]> generateSchnorrKeys(byte[] seed) {
        SchnorrKeyPair keyPair = SchnorrKeyPair.generate();
        SchnorrSecretKey secretKey = keyPair.getSecretKey();
        SchnorrPublicKey publicKey = keyPair.getPublicKey();
        EnumMap<SchnorrFunctions.KeyType, byte[]> keysMap = new EnumMap<SchnorrFunctions.KeyType, byte[]>(SchnorrFunctions.KeyType.class);
        keysMap.put(SchnorrFunctions.KeyType.SECRET, secretKey.serializeSecretKey());
        keysMap.put(SchnorrFunctions.KeyType.PUBLIC, publicKey.serializePublicKey());
        secretKey.freeSecretKey();
        publicKey.freePublicKey();
        return keysMap;
    }

    @Override
    public byte[] sign(byte[] secretKeyBytes, byte[] publicKeyBytes, byte[] messageBytes) {
        SchnorrSecretKey secretKey = SchnorrSecretKey.deserialize((byte[])secretKeyBytes);
        SchnorrPublicKey publicKey = SchnorrPublicKey.deserialize((byte[])publicKeyBytes);
        SchnorrKeyPair keyPair = new SchnorrKeyPair(secretKey, publicKey);
        FieldElement fieldElement = FieldElementUtils.messageToFieldElement(messageBytes);
        SchnorrSignature signature = keyPair.signMessage(fieldElement);
        byte[] signatureBytes = signature.serializeSignature();
        signature.freeSignature();
        fieldElement.freeFieldElement();
        publicKey.freePublicKey();
        secretKey.freeSecretKey();
        return signatureBytes;
    }

    @Override
    public boolean verify(byte[] messageBytes, byte[] publicKeyBytes, byte[] signatureBytes) {
        SchnorrPublicKey publicKey = SchnorrPublicKey.deserialize((byte[])publicKeyBytes);
        FieldElement fieldElement = FieldElementUtils.messageToFieldElement(messageBytes);
        SchnorrSignature signature = SchnorrSignature.deserialize((byte[])signatureBytes);
        boolean signatureIsValid = publicKey.verifySignature(signature, fieldElement);
        signature.freeSignature();
        fieldElement.freeFieldElement();
        publicKey.freePublicKey();
        return signatureIsValid;
    }

    @Override
    public int schnorrSecretKeyLength() {
        return 96;
    }

    @Override
    public int schnorrPublicKeyLength() {
        return 193;
    }

    @Override
    public int schnorrSignatureLength() {
        return SchnorrSignature.SIGNATURE_LENGTH;
    }
}

