/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.consensus;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.package$ConsensusAbsoluteSlotNumber$;
import com.horizen.consensus.package$ConsensusEpochId$;
import com.horizen.consensus.package$ConsensusEpochNumber$;
import com.horizen.consensus.package$ConsensusNonce$;
import com.horizen.consensus.package$ConsensusSlotNumber$;
import com.horizen.consensus.package$VrfMessage$;
import com.horizen.vrf.VrfOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import scala.runtime.BoxesRunTime;
import scorex.util.package;
import supertagged.package;

public final class package$ {
    public static package$ MODULE$;
    private final int merkleTreeHashLen;
    private final int sha256HashLen;
    private final byte[] consensusHardcodedSaltString;
    private final BigDecimal forgerStakePercentPrecision;
    private final MathContext stakeConsensusDivideMathContext;

    static {
        new package$();
    }

    public int merkleTreeHashLen() {
        return this.merkleTreeHashLen;
    }

    public int sha256HashLen() {
        return this.sha256HashLen;
    }

    public byte[] consensusHardcodedSaltString() {
        return this.consensusHardcodedSaltString;
    }

    public BigDecimal forgerStakePercentPrecision() {
        return this.forgerStakePercentPrecision;
    }

    public MathContext stakeConsensusDivideMathContext() {
        return this.stakeConsensusDivideMathContext;
    }

    public int intToConsensusEpochNumber(int consensusEpochNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusEpochNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public String blockIdToEpochId(String blockId) {
        return (String)package$ConsensusEpochId$.MODULE$.$at$at(blockId, package.Tagger$.MODULE$.baseTagged());
    }

    public String lastBlockIdInEpochId(String epochId) {
        return (String)package.ModifierId$.MODULE$.$at$at(package.PostfixSugar$.MODULE$.untag$extension(supertagged.package$.MODULE$.PostfixSugar((Object)epochId), (package.TaggedType)package$ConsensusEpochId$.MODULE$, package.Tagger$.MODULE$.baseTagged()), package.Tagger$.MODULE$.baseRaw());
    }

    public int intToConsensusSlotNumber(int consensusSlotNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusSlotNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusSlotNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public int intToConsensusAbsoluteSlotNumber(int consensusSlotNumber) {
        return BoxesRunTime.unboxToInt((Object)package$ConsensusAbsoluteSlotNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)consensusSlotNumber), package.Tagger$.MODULE$.baseRaw()));
    }

    public byte[] byteArrayToConsensusNonce(byte[] bytes) {
        return (byte[])package$ConsensusNonce$.MODULE$.$at$at(bytes, package.Tagger$.MODULE$.baseRaw());
    }

    public byte[] buildVrfMessage(int slotNumber, NonceConsensusEpochInfo nonce) {
        byte[] slotNumberBytes = Ints.toByteArray((int)slotNumber);
        byte[] nonceBytes = nonce.consensusNonce();
        byte[] resBytes = Bytes.concat((byte[][])new byte[][]{slotNumberBytes, nonceBytes, this.consensusHardcodedSaltString()});
        return (byte[])package$VrfMessage$.MODULE$.$at$at(resBytes, package.Tagger$.MODULE$.baseRaw());
    }

    public BigInteger vrfOutputToPositiveBigInteger(VrfOutput vrfOutput) {
        return new BigInteger(1, vrfOutput.bytes());
    }

    public boolean vrfProofCheckAgainstStake(VrfOutput vrfOutput, long actualStake, long totalStake) {
        boolean bl;
        BigDecimal requiredStakePercentage = this.vrfOutputToRequiredStakePercentage(vrfOutput);
        BigDecimal actualStakePercentage = new BigDecimal(actualStake).divide(new BigDecimal(totalStake), this.stakeConsensusDivideMathContext());
        int n = requiredStakePercentage.compareTo(actualStakePercentage);
        switch (n) {
            case -1: {
                bl = true;
                break;
            }
            case 0: {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public BigDecimal vrfOutputToRequiredStakePercentage(VrfOutput vrfOutput) {
        BigDecimal hashAsBigDecimal = new BigDecimal(this.vrfOutputToPositiveBigInteger(vrfOutput));
        return hashAsBigDecimal.remainder(this.forgerStakePercentPrecision()).divide(this.forgerStakePercentPrecision(), this.stakeConsensusDivideMathContext());
    }

    private package$() {
        MODULE$ = this;
        this.merkleTreeHashLen = 32;
        this.sha256HashLen = 32;
        this.consensusHardcodedSaltString = "TEST".getBytes();
        this.forgerStakePercentPrecision = BigDecimal.valueOf(1000000L);
        this.stakeConsensusDivideMathContext = MathContext.DECIMAL128;
    }
}

