/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.consensus;

import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.NonceConsensusEpochInfoSerializer$;
import com.horizen.consensus.StakeConsensusEpochInfo;
import com.horizen.consensus.StakeConsensusEpochInfoSerializer$;
import com.horizen.storage.Storage;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u000154Aa\u0003\u0007\u0001'!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u0003B\u0001\u0011\u0005!\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003T\u0001\u0011%A\u000bC\u0003\\\u0001\u0011%A\fC\u0003e\u0001\u0011%Q\rC\u0003h\u0001\u0011%\u0001N\u0001\u000bD_:\u001cXM\\:vg\u0012\u000bG/Y*u_J\fw-\u001a\u0006\u0003\u001b9\t\u0011bY8og\u0016t7/^:\u000b\u0005=\u0001\u0012a\u00025pe&TXM\u001c\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003vi&d'\"A\u0010\u0002\rM\u001cwN]3y\u0013\t\tCDA\u0007TG>\u0014X\r\u001f'pO\u001eLgnZ\u0001\u001aG>t7/\u001a8tkN,\u0005o\\2i\u0013:4wn\u0015;pe\u0006<W\r\u0005\u0002%O5\tQE\u0003\u0002'\u001d\u000591\u000f^8sC\u001e,\u0017B\u0001\u0015&\u0005\u001d\u0019Fo\u001c:bO\u0016\fa\u0001P5oSRtDCA\u0016.!\ta\u0003!D\u0001\r\u0011\u0015\u0011#\u00011\u0001$\u0003i\tG\rZ*uC.,7i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p)\r\u00014\u0007\u0010\t\u0003+EJ!A\r\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006i\r\u0001\r!N\u0001\bKB|7\r[%e!\t1\u0014H\u0004\u0002-o%\u0011\u0001\bD\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\tD_:\u001cXM\\:vg\u0016\u0003xn\u00195JI*\u0011\u0001\b\u0004\u0005\u0006{\r\u0001\rAP\u0001\u000fgR\f7.Z#q_\u000eD\u0017J\u001c4p!\tas(\u0003\u0002A\u0019\t92\u000b^1lK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\\\u0001\u001bO\u0016$8\u000b^1lK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u000b\u0003\u0007\u001a\u00032!\u0006#?\u0013\t)eC\u0001\u0004PaRLwN\u001c\u0005\u0006i\u0011\u0001\r!N\u0001\u001bC\u0012$gj\u001c8dK\u000e{gn]3ogV\u001cX\t]8dQ&sgm\u001c\u000b\u0004a%S\u0005\"\u0002\u001b\u0006\u0001\u0004)\u0004\"B&\u0006\u0001\u0004a\u0015AD2p]N,gn];t\u001d>t7-\u001a\t\u0003Y5K!A\u0014\u0007\u0003/9{gnY3D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|\u0017AG4fi:{gnY3D_:\u001cXM\\:vg\u0016\u0003xn\u00195J]\u001a|GCA)S!\r)B\t\u0014\u0005\u0006i\u0019\u0001\r!N\u0001\f]\u0016DHOV3sg&|g.F\u0001V!\r)b\u000bW\u0005\u0003/Z\u0011Q!\u0011:sCf\u0004\"!F-\n\u0005i3\"\u0001\u0002\"zi\u0016\f\u0011c\u001d;bW\u0016,\u0005o\\2i\u0013:4wnS3z)\ti6\r\u0005\u0002_C6\tqL\u0003\u0002a\u001d\u0005)Q\u000f^5mg&\u0011!m\u0018\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJDQ\u0001\u000e\u0005A\u0002U\n\u0011C\\8oG\u0016,\u0005o\\2i\u0013:4wnS3z)\tif\rC\u00035\u0013\u0001\u0007Q'\u0001\u0005bI\u0012,e\u000e\u001e:z)\r\u0001\u0014n\u001b\u0005\u0006U*\u0001\r!X\u0001\u0004W\u0016L\b\"\u00027\u000b\u0001\u0004)\u0016!\u0002<bYV,\u0007")
public class ConsensusDataStorage
implements ScorexLogging {
    private final Storage consensusEpochInfoStorage;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void addStakeConsensusEpochInfo(String epochId, StakeConsensusEpochInfo stakeEpochInfo) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add stake to consensus data storage: for epochId {} stake info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, stakeEpochInfo});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getStakeConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)stakeInfo -> BoxesRunTime.boxToBoolean((boolean)stakeInfo.equals(stakeEpochInfo))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("StakeConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.stakeEpochInfoKey(epochId), StakeConsensusEpochInfoSerializer$.MODULE$.toBytes(stakeEpochInfo));
    }

    public Option<StakeConsensusEpochInfo> getStakeConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.stakeEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (StakeConsensusEpochInfo)StakeConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    public void addNonceConsensusEpochInfo(String epochId, NonceConsensusEpochInfo consensusNonce) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Storage with id:{} -- Add nonce to consensus data storage: for epochId {} nonce info: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode()), epochId, consensusNonce});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(this.getNonceConsensusEpochInfo(epochId).forall((Function1 & Serializable & scala.Serializable)nonceInfo -> BoxesRunTime.boxToBoolean((boolean)nonceInfo.equals(consensusNonce))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("NonceConsensusEpochInfo shall not be redefined for epoch ").append(epochId).toString());
        this.addEntry(this.nonceEpochInfoKey(epochId), NonceConsensusEpochInfoSerializer$.MODULE$.toBytes(consensusNonce));
    }

    public Option<NonceConsensusEpochInfo> getNonceConsensusEpochInfo(String epochId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.consensusEpochInfoStorage.get(this.nonceEpochInfoKey(epochId)))).map((Function1 & Serializable & scala.Serializable)byteArray -> (NonceConsensusEpochInfo)NonceConsensusEpochInfoSerializer$.MODULE$.parseBytes(byteArray.data()));
    }

    /*
     * WARNING - void declaration
     */
    private byte[] nextVersion() {
        void var1_1;
        byte[] version = new byte[32];
        Random$.MODULE$.nextBytes(version);
        return var1_1;
    }

    private ByteArrayWrapper stakeEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("stake").append(epochId).toString()));
    }

    private ByteArrayWrapper nonceEpochInfoKey(String epochId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("nonce").append(epochId).toString()));
    }

    private void addEntry(ByteArrayWrapper key, byte[] value) {
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> listForUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        Pair<ByteArrayWrapper, ByteArrayWrapper> addedData = new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper(value));
        listForUpdate.add(addedData);
        this.consensusEpochInfoStorage.update(new ByteArrayWrapper(this.nextVersion()), listForUpdate, Collections.emptyList());
    }

    public ConsensusDataStorage(Storage consensusEpochInfoStorage) {
        this.consensusEpochInfoStorage = consensusEpochInfoStorage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
    }
}

