/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box.data;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.data.AbstractNoncedBoxData;
import com.horizen.box.data.CoreBoxesDataIdsEnum;
import com.horizen.box.data.NoncedBoxDataSerializer;
import com.horizen.box.data.WithdrawalRequestBoxDataSerializer;
import com.horizen.proposition.MCPublicKeyHashProposition;
import com.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import java.util.Arrays;

public final class WithdrawalRequestBoxData
extends AbstractNoncedBoxData<MCPublicKeyHashProposition, WithdrawalRequestBox, WithdrawalRequestBoxData> {
    public WithdrawalRequestBoxData(MCPublicKeyHashProposition proposition, long value) {
        super(proposition, value);
    }

    @Override
    public WithdrawalRequestBox getBox(long nonce) {
        return new WithdrawalRequestBox(this, nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{((MCPublicKeyHashProposition)this.proposition()).bytes(), Longs.toByteArray((long)this.value())});
    }

    @Override
    public NoncedBoxDataSerializer serializer() {
        return WithdrawalRequestBoxDataSerializer.getSerializer();
    }

    @Override
    public byte boxDataTypeId() {
        return CoreBoxesDataIdsEnum.WithdrawalRequestBoxDataId.id();
    }

    public static WithdrawalRequestBoxData parseBytes(byte[] bytes) {
        int valueOffset = MCPublicKeyHashProposition.getLength();
        MCPublicKeyHashProposition proposition = (MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(Arrays.copyOf(bytes, valueOffset));
        long value = Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, valueOffset, valueOffset + 8));
        return new WithdrawalRequestBoxData(proposition, value);
    }
}

