/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box.data;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.RegularBox;
import com.horizen.box.data.AbstractNoncedBoxData;
import com.horizen.box.data.CoreBoxesDataIdsEnum;
import com.horizen.box.data.NoncedBoxDataSerializer;
import com.horizen.box.data.RegularBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.PublicKey25519PropositionSerializer;
import java.util.Arrays;

public final class RegularBoxData
extends AbstractNoncedBoxData<PublicKey25519Proposition, RegularBox, RegularBoxData> {
    public RegularBoxData(PublicKey25519Proposition proposition, long value) {
        super(proposition, value);
    }

    @Override
    public RegularBox getBox(long nonce) {
        return new RegularBox(this, nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{((PublicKey25519Proposition)this.proposition()).bytes(), Longs.toByteArray((long)this.value())});
    }

    @Override
    public NoncedBoxDataSerializer serializer() {
        return RegularBoxDataSerializer.getSerializer();
    }

    @Override
    public byte boxDataTypeId() {
        return CoreBoxesDataIdsEnum.RegularBoxDataId.id();
    }

    public static RegularBoxData parseBytes(byte[] bytes) {
        int valueOffset = PublicKey25519Proposition.getLength();
        PublicKey25519Proposition proposition = (PublicKey25519Proposition)PublicKey25519PropositionSerializer.getSerializer().parseBytes(Arrays.copyOf(bytes, valueOffset));
        long value = Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, valueOffset, valueOffset + 8));
        return new RegularBoxData(proposition, value);
    }
}

