/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box.data;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.ForgerBox;
import com.horizen.box.data.AbstractNoncedBoxData;
import com.horizen.box.data.CoreBoxesDataIdsEnum;
import com.horizen.box.data.ForgerBoxDataSerializer;
import com.horizen.box.data.NoncedBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.PublicKey25519PropositionSerializer;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.proposition.VrfPublicKeySerializer;
import java.util.Arrays;
import java.util.Objects;
import scorex.crypto.hash.Blake2b256;

public final class ForgerBoxData
extends AbstractNoncedBoxData<PublicKey25519Proposition, ForgerBox, ForgerBoxData> {
    private final PublicKey25519Proposition blockSignProposition;
    private final VrfPublicKey vrfPublicKey;

    public ForgerBoxData(PublicKey25519Proposition proposition, long value, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey) {
        super(proposition, value);
        Objects.requireNonNull(blockSignProposition, "blockSignProposition must be defined");
        Objects.requireNonNull(vrfPublicKey, "vrfPublicKey must be defined");
        this.blockSignProposition = blockSignProposition;
        this.vrfPublicKey = vrfPublicKey;
    }

    public PublicKey25519Proposition blockSignProposition() {
        return this.blockSignProposition;
    }

    public VrfPublicKey vrfPublicKey() {
        return this.vrfPublicKey;
    }

    @Override
    public ForgerBox getBox(long nonce) {
        return new ForgerBox(this, nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{((PublicKey25519Proposition)this.proposition()).bytes(), Longs.toByteArray((long)this.value()), this.blockSignProposition().bytes(), this.vrfPublicKey().bytes()});
    }

    @Override
    public NoncedBoxDataSerializer serializer() {
        return ForgerBoxDataSerializer.getSerializer();
    }

    @Override
    public byte boxDataTypeId() {
        return CoreBoxesDataIdsEnum.ForgerBoxDataId.id();
    }

    public static ForgerBoxData parseBytes(byte[] bytes) {
        int valueOffset = PublicKey25519Proposition.getLength();
        int blockSignPropositionOffset = valueOffset + 8;
        int vrfPubKeyOffset = blockSignPropositionOffset + PublicKey25519Proposition.getLength();
        PublicKey25519Proposition proposition = (PublicKey25519Proposition)PublicKey25519PropositionSerializer.getSerializer().parseBytes(Arrays.copyOf(bytes, valueOffset));
        long value = Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, valueOffset, blockSignPropositionOffset));
        PublicKey25519Proposition blockSignProposition = PublicKey25519Proposition.parseBytes(Arrays.copyOfRange(bytes, blockSignPropositionOffset, vrfPubKeyOffset));
        VrfPublicKey vrfPublicKey = (VrfPublicKey)VrfPublicKeySerializer.getSerializer().parseBytes(Arrays.copyOfRange(bytes, vrfPubKeyOffset, bytes.length));
        return new ForgerBoxData(proposition, value, blockSignProposition, vrfPublicKey);
    }

    @Override
    public byte[] customFieldsHash() {
        return Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.blockSignProposition().pubKeyBytes(), this.vrfPublicKey().pubKeyBytes()}));
    }
}

