/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box.data;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.CertifierRightBox;
import com.horizen.box.data.AbstractNoncedBoxData;
import com.horizen.box.data.CertifierRightBoxDataSerializer;
import com.horizen.box.data.CoreBoxesDataIdsEnum;
import com.horizen.box.data.NoncedBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.PublicKey25519PropositionSerializer;
import java.util.Arrays;
import scorex.crypto.hash.Blake2b256;

public final class CertifierRightBoxData
extends AbstractNoncedBoxData<PublicKey25519Proposition, CertifierRightBox, CertifierRightBoxData> {
    private final long activeFromWithdrawalEpoch;

    public CertifierRightBoxData(PublicKey25519Proposition proposition, long value, long activeFromWithdrawalEpoch) {
        super(proposition, value);
        this.activeFromWithdrawalEpoch = activeFromWithdrawalEpoch;
    }

    public long activeFromWithdrawalEpoch() {
        return this.activeFromWithdrawalEpoch;
    }

    @Override
    public CertifierRightBox getBox(long nonce) {
        return new CertifierRightBox(this, nonce);
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{((PublicKey25519Proposition)this.proposition()).bytes(), Longs.toByteArray((long)this.value()), Longs.toByteArray((long)this.activeFromWithdrawalEpoch())});
    }

    @Override
    public NoncedBoxDataSerializer serializer() {
        return CertifierRightBoxDataSerializer.getSerializer();
    }

    @Override
    public byte boxDataTypeId() {
        return CoreBoxesDataIdsEnum.CertifierRightBoxDataId.id();
    }

    public static CertifierRightBoxData parseBytes(byte[] bytes) {
        int valueOffset = PublicKey25519Proposition.getLength();
        int activeOffset = valueOffset + 8;
        PublicKey25519Proposition proposition = (PublicKey25519Proposition)PublicKey25519PropositionSerializer.getSerializer().parseBytes(Arrays.copyOf(bytes, valueOffset));
        long value = Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, valueOffset, activeOffset));
        long activeFromWithdrawalEpoch = Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, activeOffset, activeOffset + 8));
        return new CertifierRightBoxData(proposition, value, activeFromWithdrawalEpoch);
    }

    @Override
    public byte[] customFieldsHash() {
        return Blake2b256.hash((byte[])Longs.toByteArray((long)this.activeFromWithdrawalEpoch()));
    }
}

