/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box.data;

import com.horizen.box.AbstractNoncedBox;
import com.horizen.box.data.NoncedBoxData;
import com.horizen.proposition.Proposition;
import com.horizen.utils.Utils;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractNoncedBoxData<P extends Proposition, B extends AbstractNoncedBox<P, BD, B>, BD extends AbstractNoncedBoxData<P, B, BD>>
implements NoncedBoxData<P, B> {
    private final P proposition;
    private final long value;

    public AbstractNoncedBoxData(P proposition, long value) {
        Objects.requireNonNull(proposition, "proposition must be defined");
        this.proposition = proposition;
        this.value = value;
    }

    @Override
    public final long value() {
        return this.value;
    }

    @Override
    public final P proposition() {
        return this.proposition;
    }

    @Override
    public abstract byte[] bytes();

    @Override
    public byte[] customFieldsHash() {
        return Utils.ZEROS_HASH;
    }

    public int hashCode() {
        return Objects.hash(this.proposition(), this.value(), Arrays.hashCode(this.customFieldsHash()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractNoncedBoxData boxData = (AbstractNoncedBoxData)obj;
        return this.proposition().equals(boxData.proposition()) && this.value() == boxData.value() && Arrays.equals(this.customFieldsHash(), boxData.customFieldsHash());
    }
}

