/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.AbstractNoncedBox;
import com.horizen.box.BoxSerializer;
import com.horizen.box.CoreBoxesIdsEnum;
import com.horizen.box.WithdrawalRequestBoxSerializer;
import com.horizen.box.data.WithdrawalRequestBoxData;
import com.horizen.box.data.WithdrawalRequestBoxDataSerializer;
import com.horizen.proposition.MCPublicKeyHashProposition;
import java.util.Arrays;

public final class WithdrawalRequestBox
extends AbstractNoncedBox<MCPublicKeyHashProposition, WithdrawalRequestBoxData, WithdrawalRequestBox> {
    public WithdrawalRequestBox(WithdrawalRequestBoxData boxData, long nonce) {
        super(boxData, nonce);
    }

    @Override
    public byte boxTypeId() {
        return CoreBoxesIdsEnum.WithdrawalRequestBoxId.id();
    }

    @Override
    public BoxSerializer serializer() {
        return WithdrawalRequestBoxSerializer.getSerializer();
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.nonce), WithdrawalRequestBoxDataSerializer.getSerializer().toBytes((WithdrawalRequestBoxData)this.boxData)});
    }

    public static WithdrawalRequestBox parseBytes(byte[] bytes) {
        long nonce = Longs.fromByteArray((byte[])Arrays.copyOf(bytes, 8));
        WithdrawalRequestBoxData boxData = (WithdrawalRequestBoxData)WithdrawalRequestBoxDataSerializer.getSerializer().parseBytes(Arrays.copyOfRange(bytes, 8, bytes.length));
        return new WithdrawalRequestBox(boxData, nonce);
    }
}

