/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.AbstractNoncedBox;
import com.horizen.box.BoxSerializer;
import com.horizen.box.CoinsBox;
import com.horizen.box.CoreBoxesIdsEnum;
import com.horizen.box.RegularBoxSerializer;
import com.horizen.box.data.RegularBoxData;
import com.horizen.box.data.RegularBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import java.util.Arrays;

public final class RegularBox
extends AbstractNoncedBox<PublicKey25519Proposition, RegularBoxData, RegularBox>
implements CoinsBox<PublicKey25519Proposition> {
    public RegularBox(RegularBoxData boxData, long nonce) {
        super(boxData, nonce);
    }

    @Override
    public byte boxTypeId() {
        return CoreBoxesIdsEnum.RegularBoxId.id();
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.nonce), RegularBoxDataSerializer.getSerializer().toBytes((RegularBoxData)this.boxData)});
    }

    @Override
    public BoxSerializer serializer() {
        return RegularBoxSerializer.getSerializer();
    }

    public static RegularBox parseBytes(byte[] bytes) {
        long nonce = Longs.fromByteArray((byte[])Arrays.copyOf(bytes, 8));
        RegularBoxData boxData = (RegularBoxData)RegularBoxDataSerializer.getSerializer().parseBytes(Arrays.copyOfRange(bytes, 8, bytes.length));
        return new RegularBox(boxData, nonce);
    }
}

