/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.AbstractNoncedBox;
import com.horizen.box.BoxSerializer;
import com.horizen.box.CoinsBox;
import com.horizen.box.CoreBoxesIdsEnum;
import com.horizen.box.ForgerBoxSerializer;
import com.horizen.box.data.ForgerBoxData;
import com.horizen.box.data.ForgerBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.VrfPublicKey;
import java.util.Arrays;

public final class ForgerBox
extends AbstractNoncedBox<PublicKey25519Proposition, ForgerBoxData, ForgerBox>
implements CoinsBox<PublicKey25519Proposition> {
    public ForgerBox(ForgerBoxData boxData, long nonce) {
        super(boxData, nonce);
    }

    @Override
    public byte boxTypeId() {
        return CoreBoxesIdsEnum.ForgerBoxId.id();
    }

    @JsonProperty(value="vrfPubKey")
    public VrfPublicKey vrfPubKey() {
        return ((ForgerBoxData)this.boxData).vrfPublicKey();
    }

    @JsonProperty(value="blockSignProposition")
    public PublicKey25519Proposition blockSignProposition() {
        return ((ForgerBoxData)this.boxData).blockSignProposition();
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.nonce), ForgerBoxDataSerializer.getSerializer().toBytes((ForgerBoxData)this.boxData)});
    }

    @Override
    public BoxSerializer serializer() {
        return ForgerBoxSerializer.getSerializer();
    }

    @Override
    public String toString() {
        return String.format("%s(id: %s, proposition: %s, value: %d, vrfPubKey: %s, blockSignProposition: %s, nonce: %d)", this.getClass().toString(), ForgerBox.encoder().encode(this.id()), this.proposition(), this.value(), this.vrfPubKey(), this.blockSignProposition(), this.nonce());
    }

    public static ForgerBox parseBytes(byte[] bytes) {
        long nonce = Longs.fromByteArray((byte[])Arrays.copyOf(bytes, 8));
        int forgerBoxDataOffset = 8;
        ForgerBoxData boxData = (ForgerBoxData)ForgerBoxDataSerializer.getSerializer().parseBytes(Arrays.copyOfRange(bytes, forgerBoxDataOffset, bytes.length));
        return boxData.getBox(nonce);
    }
}

