/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.AbstractNoncedBox;
import com.horizen.box.BoxSerializer;
import com.horizen.box.CertifierRightBoxSerializer;
import com.horizen.box.CoreBoxesIdsEnum;
import com.horizen.box.data.CertifierRightBoxData;
import com.horizen.box.data.CertifierRightBoxDataSerializer;
import com.horizen.proposition.PublicKey25519Proposition;
import java.util.Arrays;

public final class CertifierRightBox
extends AbstractNoncedBox<PublicKey25519Proposition, CertifierRightBoxData, CertifierRightBox> {
    public CertifierRightBox(CertifierRightBoxData boxData, long nonce) {
        super(boxData, nonce);
    }

    @JsonProperty(value="activeFromWithdrawalEpoch")
    public long activeFromWithdrawalEpoch() {
        return ((CertifierRightBoxData)this.boxData).activeFromWithdrawalEpoch();
    }

    @Override
    public byte boxTypeId() {
        return CoreBoxesIdsEnum.CertifierRightBoxId.id();
    }

    @Override
    public String toString() {
        return String.format("%s(id: %s, proposition: %s, nonce: %d, epoch: %d)", this.getClass().toString(), CertifierRightBox.encoder().encode(this.id()), this.proposition(), this.nonce(), this.activeFromWithdrawalEpoch());
    }

    @Override
    public byte[] bytes() {
        return Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)this.nonce), CertifierRightBoxDataSerializer.getSerializer().toBytes((CertifierRightBoxData)this.boxData)});
    }

    @Override
    public BoxSerializer serializer() {
        return CertifierRightBoxSerializer.getSerializer();
    }

    public static CertifierRightBox parseBytes(byte[] bytes) {
        long nonce = Longs.fromByteArray((byte[])Arrays.copyOf(bytes, 8));
        CertifierRightBoxData boxData = (CertifierRightBoxData)CertifierRightBoxDataSerializer.getSerializer().parseBytes(Arrays.copyOfRange(bytes, 8, bytes.length));
        return new CertifierRightBox(boxData, nonce);
    }
}

