/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import com.horizen.block.MainchainBackwardTransferCertificateOutput;
import com.horizen.block.MainchainBackwardTransferCertificateOutput$;
import com.horizen.block.MainchainTransactionInput;
import com.horizen.block.MainchainTransactionInput$;
import com.horizen.block.MainchainTransactionOutput;
import com.horizen.block.MainchainTransactionOutput$;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.VarInt;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple10;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class WithdrawalEpochCertificate$
implements Serializable {
    public static WithdrawalEpochCertificate$ MODULE$;

    static {
        new WithdrawalEpochCertificate$();
    }

    public byte[] $lessinit$greater$default$7() {
        return (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
    }

    public WithdrawalEpochCertificate parse(byte[] certificateBytes, int offset) {
        int currentOffset = offset;
        int version = BytesUtils.getReversedInt(certificateBytes, currentOffset);
        byte[] sidechainId = BytesUtils.reverseBytes((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(certificateBytes)).slice(currentOffset += 4, currentOffset + 32));
        int epochNumber = BytesUtils.getReversedInt(certificateBytes, currentOffset += 32);
        long quality = BytesUtils.getReversedLong(certificateBytes, currentOffset += 4);
        byte[] endEpochBlockHash = BytesUtils.reverseBytes((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(certificateBytes)).slice(currentOffset += 8, currentOffset + 32));
        int scProofSize = CryptoLibProvider$.MODULE$.sigProofThresholdCircuitFunctions().proofSizeLength();
        byte[] scProof = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(certificateBytes)).slice(currentOffset += 32, currentOffset + scProofSize);
        VarInt transactionInputCount = BytesUtils.getVarInt(certificateBytes, currentOffset += scProofSize);
        currentOffset += transactionInputCount.size();
        Seq transactionInputs = (Seq)Nil$.MODULE$;
        while ((long)transactionInputs.size() < transactionInputCount.value()) {
            MainchainTransactionInput input = MainchainTransactionInput$.MODULE$.parse(certificateBytes, currentOffset);
            transactionInputs = (Seq)transactionInputs.$colon$plus((Object)input, Seq$.MODULE$.canBuildFrom());
            currentOffset += input.size();
        }
        VarInt transactionOutputCount = BytesUtils.getVarInt(certificateBytes, currentOffset);
        currentOffset += transactionOutputCount.size();
        Seq transactionOutputs = (Seq)Nil$.MODULE$;
        while ((long)transactionOutputs.size() < transactionOutputCount.value()) {
            MainchainTransactionOutput o = MainchainTransactionOutput$.MODULE$.parse(certificateBytes, currentOffset);
            transactionOutputs = (Seq)transactionOutputs.$colon$plus((Object)o, Seq$.MODULE$.canBuildFrom());
            currentOffset += o.size();
        }
        VarInt backwardTransferOutputsCount = BytesUtils.getVarInt(certificateBytes, currentOffset);
        currentOffset += backwardTransferOutputsCount.size();
        Seq backwardTransferOutputs = (Seq)Nil$.MODULE$;
        while ((long)backwardTransferOutputs.size() < backwardTransferOutputsCount.value()) {
            MainchainBackwardTransferCertificateOutput o = MainchainBackwardTransferCertificateOutput$.MODULE$.parse(certificateBytes, currentOffset);
            backwardTransferOutputs = (Seq)backwardTransferOutputs.$colon$plus((Object)o, Seq$.MODULE$.canBuildFrom());
            currentOffset += o.size();
        }
        return new WithdrawalEpochCertificate((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(certificateBytes)).slice(offset, currentOffset), version, sidechainId, epochNumber, quality, endEpochBlockHash, scProof, (Seq<MainchainTransactionInput>)transactionInputs, (Seq<MainchainTransactionOutput>)transactionOutputs, (Seq<MainchainBackwardTransferCertificateOutput>)backwardTransferOutputs);
    }

    public WithdrawalEpochCertificate apply(byte[] certificateBytes, int version, byte[] sidechainId, int epochNumber, long quality, byte[] endEpochBlockHash, byte[] proof, Seq<MainchainTransactionInput> transactionInputs, Seq<MainchainTransactionOutput> transactionOutputs, Seq<MainchainBackwardTransferCertificateOutput> backwardTransferOutputs) {
        return new WithdrawalEpochCertificate(certificateBytes, version, sidechainId, epochNumber, quality, endEpochBlockHash, proof, transactionInputs, transactionOutputs, backwardTransferOutputs);
    }

    public byte[] apply$default$7() {
        return (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
    }

    public Option<Tuple10<byte[], Object, byte[], Object, Object, byte[], byte[], Seq<MainchainTransactionInput>, Seq<MainchainTransactionOutput>, Seq<MainchainBackwardTransferCertificateOutput>>> unapply(WithdrawalEpochCertificate x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.certificateBytes(), (Object)BoxesRunTime.boxToInteger((int)x$0.version()), (Object)x$0.sidechainId(), (Object)BoxesRunTime.boxToInteger((int)x$0.epochNumber()), (Object)BoxesRunTime.boxToLong((long)x$0.quality()), (Object)x$0.endEpochBlockHash(), (Object)x$0.proof(), x$0.transactionInputs(), x$0.transactionOutputs(), x$0.backwardTransferOutputs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private WithdrawalEpochCertificate$() {
        MODULE$ = this;
    }
}

