/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import akka.util.ByteString;
import com.horizen.block.SidechainBlockHeader;
import com.horizen.box.ForgerBox;
import com.horizen.box.ForgerBoxSerializer;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.proof.Signature25519;
import com.horizen.proof.Signature25519Serializer;
import com.horizen.proof.VrfProof;
import com.horizen.utils.MerklePath;
import scala.util.Try;
import scorex.core.NodeViewModifier$;
import scorex.core.package$;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Serializer;
import scorex.util.serialization.Writer;

public final class SidechainBlockHeaderSerializer$
implements ScorexSerializer<SidechainBlockHeader> {
    public static SidechainBlockHeaderSerializer$ MODULE$;

    static {
        new SidechainBlockHeaderSerializer$();
    }

    public ByteString toByteString(Object obj) {
        return ScorexSerializer.toByteString$((ScorexSerializer)this, (Object)obj);
    }

    public Object parseByteString(ByteString byteString) {
        return ScorexSerializer.parseByteString$((ScorexSerializer)this, (ByteString)byteString);
    }

    public Try<SidechainBlockHeader> parseByteStringTry(ByteString byteString) {
        return ScorexSerializer.parseByteStringTry$((ScorexSerializer)this, (ByteString)byteString);
    }

    public byte[] toBytes(Object obj) {
        return ScorexSerializer.toBytes$((ScorexSerializer)this, (Object)obj);
    }

    public Object parseBytes(byte[] bytes) {
        return ScorexSerializer.parseBytes$((ScorexSerializer)this, (byte[])bytes);
    }

    public Try<SidechainBlockHeader> parseBytesTry(byte[] bytes) {
        return ScorexSerializer.parseBytesTry$((ScorexSerializer)this, (byte[])bytes);
    }

    public Try<SidechainBlockHeader> parseTry(Reader r) {
        return Serializer.parseTry$((Serializer)this, (Reader)r);
    }

    public void serialize(SidechainBlockHeader obj, Writer w) {
        w.put(obj.version());
        w.putBytes((byte[])package$.MODULE$.idToBytes().apply((Object)obj.parentId()));
        w.putLong(obj.timestamp());
        byte[] forgerBoxBytes = ForgerBoxSerializer.getSerializer().toBytes(obj.forgerBox());
        w.putInt(forgerBoxBytes.length);
        w.putBytes(forgerBoxBytes);
        byte[] forgerBoxMerklePathBytes = obj.forgerBoxMerklePath().bytes();
        w.putInt(forgerBoxMerklePathBytes.length);
        w.putBytes(forgerBoxMerklePathBytes);
        byte[] vrfProofBytes = obj.vrfProof().bytes();
        w.putBytes(vrfProofBytes);
        w.putBytes(obj.sidechainTransactionsMerkleRootHash());
        w.putBytes(obj.mainchainMerkleRootHash());
        w.putBytes(obj.ommersMerkleRootHash());
        w.putLong(obj.ommersCumulativeScore());
        byte[] signatureBytes = Signature25519Serializer.getSerializer().toBytes(obj.signature());
        w.putInt(signatureBytes.length);
        w.putBytes(signatureBytes);
    }

    public SidechainBlockHeader parse(Reader r) {
        byte version = r.getByte();
        String parentId = (String)package$.MODULE$.bytesToId().apply((Object)r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize()));
        long timestamp = r.getLong();
        int forgerBoxBytesLength = r.getInt();
        ForgerBox forgerBox = (ForgerBox)ForgerBoxSerializer.getSerializer().parseBytes(r.getBytes(forgerBoxBytesLength));
        int forgerBoxMerklePathBytesLength = r.getInt();
        MerklePath forgerBoxMerklePath = MerklePath.parseBytes(r.getBytes(forgerBoxMerklePathBytesLength));
        int vrfProofBytesLength = CryptoLibProvider$.MODULE$.vrfFunctions().vrfProofLen();
        VrfProof vrfProof = VrfProof.parse(r.getBytes(vrfProofBytesLength));
        byte[] sidechainTransactionsMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        byte[] mainchainMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        byte[] ommersMerkleRootHash = r.getBytes(NodeViewModifier$.MODULE$.ModifierIdSize());
        long ommersCumulativeScore = r.getLong();
        int signatureLength = r.getInt();
        Signature25519 signature = (Signature25519)Signature25519Serializer.getSerializer().parseBytes(r.getBytes(signatureLength));
        return new SidechainBlockHeader(version, parentId, timestamp, forgerBox, forgerBoxMerklePath, vrfProof, sidechainTransactionsMerkleRootHash, mainchainMerkleRootHash, ommersMerkleRootHash, ommersCumulativeScore, signature);
    }

    private SidechainBlockHeaderSerializer$() {
        MODULE$ = this;
        Serializer.$init$((Serializer)this);
        ScorexSerializer.$init$((ScorexSerializer)this);
    }
}

