/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.block.Equihash;
import com.horizen.block.MainchainHeader$;
import com.horizen.block.MainchainHeaderSerializer$;
import com.horizen.block.ProofOfWorkVerifier$;
import com.horizen.params.NetworkParams;
import com.horizen.serialization.Views;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;
import com.horizen.validation.InvalidMainchainHeaderException;
import com.horizen.validation.InvalidMainchainHeaderException$;
import com.horizen.validation.MainchainHeaderTimestampInFutureException;
import com.horizen.validation.MainchainHeaderTimestampInFutureException$;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"mainchainHeaderBytes", "hashHex"})
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u0013&\u00011B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0011!a\u0005A!b\u0001\n\u0003q\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B \t\u00119\u0003!Q1A\u0005\u0002yB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t!\u0002\u0011)\u0019!C\u0001}!A\u0011\u000b\u0001B\u0001B\u0003%q\b\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001H\u0011!\u0019\u0006A!A!\u0002\u0013A\u0005\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011A$\t\u0011U\u0003!\u0011!Q\u0001\n!C\u0001B\u0016\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t/\u0002\u0011\t\u0011)A\u0005\u007f!A\u0001\f\u0001BC\u0002\u0013\u0005a\b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011!9\u0007\u0001#b\u0001\n\u0003q\u0004\u0002\u00035\u0001\u0011\u000b\u0007I\u0011A5\u0006\tU\u0004\u0001\u0005\u0018\u0005\u0006m\u0002!\te\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002<\u0001!\t%!\u0010\b\u000f\u0005mT\u0005#\u0001\u0002~\u00191A%\nE\u0001\u0003\u007fBaA\u0017\u0010\u0005\u0002\u0005\u001d\u0005\u0002CAE=\t\u0007I\u0011A$\t\u000f\u0005-e\u0004)A\u0005\u0011\"9\u0011Q\u0012\u0010\u0005\u0002\u0005=\u0005\"CAN=\u0005\u0005I\u0011BAO\u0005=i\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014(B\u0001\u0014(\u0003\u0015\u0011Gn\\2l\u0015\tA\u0013&A\u0004i_JL'0\u001a8\u000b\u0003)\n1aY8n\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011AgO\u0007\u0002k)\u0011agN\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005aJ\u0014\u0001B2pe\u0016T\u0011AO\u0001\u0007g\u000e|'/\u001a=\n\u0005q*$!\u0005\"zi\u0016\u001c8+\u001a:jC2L'0\u00192mK\u0006!R.Y5oG\"\f\u0017N\u001c%fC\u0012,'OQ=uKN,\u0012a\u0010\t\u0004]\u0001\u0013\u0015BA!0\u0005\u0015\t%O]1z!\tq3)\u0003\u0002E_\t!!)\u001f;f\u0003Ui\u0017-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014()\u001f;fg\u0002\nqA^3sg&|g.F\u0001I!\tq\u0013*\u0003\u0002K_\t\u0019\u0011J\u001c;\u0002\u0011Y,'o]5p]\u0002\nQ\u0002[1tQB\u0013XM\u001e\"m_\u000e\\\u0017A\u00045bg\"\u0004&/\u001a<CY>\u001c7\u000eI\u0001\u000fQ\u0006\u001c\b.T3sW2,'k\\8u\u0003=A\u0017m\u001d5NKJ\\G.\u001a*p_R\u0004\u0013a\u00055bg\"\u001c6\r\u0016=t\u0007>lW.\u001b;nK:$\u0018\u0001\u00065bg\"\u001c6\r\u0016=t\u0007>lW.\u001b;nK:$\b%\u0001\u0003uS6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u00022jiN\fQAY5ug\u0002\nQA\\8oG\u0016\faA\\8oG\u0016\u0004\u0013\u0001C:pYV$\u0018n\u001c8\u0002\u0013M|G.\u001e;j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006]=~\u0003\u0017MY2eK\u001a\u0004\"!\u0018\u0001\u000e\u0003\u0015BQ!P\nA\u0002}BQAR\nA\u0002!CQ\u0001T\nA\u0002}BQAT\nA\u0002}BQ\u0001U\nA\u0002}BQAU\nA\u0002!CQ\u0001V\nA\u0002!CQAV\nA\u0002}BQ\u0001W\nA\u0002}\nA\u0001[1tQ\u00069\u0001.Y:i\u0011\u0016DX#\u00016\u0011\u0005-\u0014hB\u00017q!\tiw&D\u0001o\u0015\ty7&\u0001\u0004=e>|GOP\u0005\u0003c>\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011o\f\u0002\u0002\u001b\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u0003a\u00042\u0001N=]\u0013\tQXG\u0001\tTG>\u0014X\r_*fe&\fG.\u001b>fe\u0006\u00012/Z7b]RL7MV1mS\u0012LG/\u001f\u000b\u0004{\u00065\u0001#\u0002@\u0002\u0004\u0005\u001dQ\"A@\u000b\u0007\u0005\u0005q&\u0001\u0003vi&d\u0017bAA\u0003\u007f\n\u0019AK]=\u0011\u00079\nI!C\u0002\u0002\f=\u0012A!\u00168ji\"9\u0011q\u0002\rA\u0002\u0005E\u0011A\u00029be\u0006l7\u000f\u0005\u0003\u0002\u0014\u0005]QBAA\u000b\u0015\r\tyaJ\u0005\u0005\u00033\t)BA\u0007OKR<xN]6QCJ\fWn]\u0001\u000bSN\u0004\u0016M]3oi>3G\u0003BA\u0010\u0003K\u00012ALA\u0011\u0013\r\t\u0019c\f\u0002\b\u0005>|G.Z1o\u0011\u0019\t9#\u0007a\u00019\u00061\u0001.Z1eKJ\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u0011\u00061Q-];bYN$B!a\b\u00022!9\u00111G\u000eA\u0002\u0005U\u0012aA8cUB\u0019a&a\u000e\n\u0007\u0005erFA\u0002B]f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002U\":\u0001!!\u0011\u0002V\u0005]\u0003\u0003BA\"\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u000bC:tw\u000e^1uS>t'\u0002BA&\u0003\u001b\nqA[1dWN|gNC\u0002\u0002P%\n\u0011BZ1ti\u0016\u0014\b0\u001c7\n\t\u0005M\u0013Q\t\u0002\u0015\u0015N|g.S4o_J,\u0007K]8qKJ$\u0018.Z:\u0002\u000bY\fG.^3-\t\u0005e\u00131L\u0011\u0002{\u0005\n\u0001\u000eK\u0004\u0001\u0003?\n)&!\u001a\u0011\t\u0005\r\u0013\u0011M\u0005\u0005\u0003G\n)E\u0001\u0005Kg>tg+[3xY\t\t9g\t\u0002\u0002jA!\u00111NA;\u001d\u0011\ti'!\u001d\u000e\u0005\u0005=$B\u0001\u001c(\u0013\u0011\t\u0019(a\u001c\u0002\u000bYKWm^:\n\t\u0005]\u0014\u0011\u0010\u0002\b\t\u00164\u0017-\u001e7u\u0015\u0011\t\u0019(a\u001c\u0002\u001f5\u000b\u0017N\\2iC&t\u0007*Z1eKJ\u0004\"!\u0018\u0010\u0014\tyi\u0013\u0011\u0011\t\u0004]\u0005\r\u0015bAAC_\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011QP\u0001\u0010\u0011\u0016\u000bE)\u0012*`\u001b&sulU%[\u000b\u0006\u0001\u0002*R!E\u000bJ{V*\u0013(`'&SV\tI\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005E\u00151SAL!\u0011q\u00181\u0001/\t\r\u0005U%\u00051\u0001@\u0003-AW-\u00193fe\nKH/Z:\t\r\u0005e%\u00051\u0001I\u0003\u0019ygMZ:fi\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\t1\fgn\u001a\u0006\u0003\u0003S\u000bAA[1wC&!\u0011QVAR\u0005\u0019y%M[3di\u0002")
public class MainchainHeader
implements BytesSerializable {
    private byte[] hash;
    private String hashHex;
    private final byte[] mainchainHeaderBytes;
    private final int version;
    private final byte[] hashPrevBlock;
    private final byte[] hashMerkleRoot;
    private final byte[] hashScTxsCommitment;
    private final int time;
    private final int bits;
    private final byte[] nonce;
    private final byte[] solution;
    private volatile byte bitmap$0;

    public static Try<MainchainHeader> create(byte[] byArray, int n) {
        return MainchainHeader$.MODULE$.create(byArray, n);
    }

    public static int HEADER_MIN_SIZE() {
        return MainchainHeader$.MODULE$.HEADER_MIN_SIZE();
    }

    public byte[] bytes() {
        return BytesSerializable.bytes$((BytesSerializable)this);
    }

    public byte[] mainchainHeaderBytes() {
        return this.mainchainHeaderBytes;
    }

    public int version() {
        return this.version;
    }

    public byte[] hashPrevBlock() {
        return this.hashPrevBlock;
    }

    public byte[] hashMerkleRoot() {
        return this.hashMerkleRoot;
    }

    public byte[] hashScTxsCommitment() {
        return this.hashScTxsCommitment;
    }

    public int time() {
        return this.time;
    }

    public int bits() {
        return this.bits;
    }

    public byte[] nonce() {
        return this.nonce;
    }

    public byte[] solution() {
        return this.solution;
    }

    private byte[] hash$lzycompute() {
        MainchainHeader mainchainHeader = this;
        synchronized (mainchainHeader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.hash = BytesUtils.reverseBytes(Utils.doubleSHA256Hash(this.mainchainHeaderBytes()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.hash;
    }

    public byte[] hash() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.hash$lzycompute() : this.hash;
    }

    private String hashHex$lzycompute() {
        MainchainHeader mainchainHeader = this;
        synchronized (mainchainHeader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hashHex = BytesUtils.toHexString(this.hash());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashHex;
    }

    public String hashHex() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hashHex$lzycompute() : this.hashHex;
    }

    public ScorexSerializer<MainchainHeader> serializer() {
        return MainchainHeaderSerializer$.MODULE$;
    }

    public Try<BoxedUnit> semanticValidity(NetworkParams params) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.hashPrevBlock() == null || this.hashPrevBlock().length != 32 || this.hashMerkleRoot() == null || this.hashMerkleRoot().length != 32 || this.hashScTxsCommitment() == null || this.hashScTxsCommitment().length != 32 || this.nonce() == null || this.nonce().length != 32 || this.solution() == null || this.solution().length != params.EquihashSolutionLength() || this.time() <= 0) {
                throw new InvalidMainchainHeaderException("MainchainHeader contains null or out of bound fields.", InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!ProofOfWorkVerifier$.MODULE$.checkProofOfWork(this, params)) {
                throw new InvalidMainchainHeaderException(new StringBuilder(32).append("MainchainHeader ").append(this.hashHex()).append(" PoW is invalid.").toString(), InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!new Equihash(params.EquihashN(), params.EquihashK()).checkEquihashSolution((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.mainchainHeaderBytes())).slice(0, this.mainchainHeaderBytes().length - params.EquihashVarIntLength() - params.EquihashSolutionLength()), this.solution())) {
                throw new InvalidMainchainHeaderException(new StringBuilder(46).append("MainchainHeader ").append(this.hashHex()).append(" Equihash solution is invalid.").toString(), InvalidMainchainHeaderException$.MODULE$.$lessinit$greater$default$2());
            }
            if ((long)this.time() > Instant.now().getEpochSecond() + 7200L) {
                throw new MainchainHeaderTimestampInFutureException(new StringBuilder(44).append("MainchainHeader ").append(this.hashHex()).append(" time ").append(this.time()).append(" is too far in future.").toString(), MainchainHeaderTimestampInFutureException$.MODULE$.$lessinit$greater$default$2());
            }
        });
    }

    public boolean isParentOf(MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.hashPrevBlock())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.hash()));
    }

    public int hashCode() {
        return Arrays.hashCode(this.mainchainHeaderBytes());
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof MainchainHeader) {
            MainchainHeader mainchainHeader = (MainchainHeader)object;
            bl = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeader.hash()));
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return new StringBuilder(33).append("MainchainHeader(").append(this.mainchainHeaderBytes()).append(", ").append(this.version()).append(", ").append(this.hashPrevBlock()).append(", ").append(this.hashMerkleRoot()).append(", ").append(this.hashScTxsCommitment()).append(", ").append(this.time()).append(", ").append(this.bits()).append(", ").append(this.nonce()).append(", ").append(this.solution()).append(")").toString();
    }

    public MainchainHeader(byte[] mainchainHeaderBytes, int version, byte[] hashPrevBlock, byte[] hashMerkleRoot, byte[] hashScTxsCommitment, int time, int bits, byte[] nonce, byte[] solution) {
        this.mainchainHeaderBytes = mainchainHeaderBytes;
        this.version = version;
        this.hashPrevBlock = hashPrevBlock;
        this.hashMerkleRoot = hashMerkleRoot;
        this.hashScTxsCommitment = hashScTxsCommitment;
        this.time = time;
        this.bits = bits;
        this.nonce = nonce;
        this.solution = solution;
        BytesSerializable.$init$((BytesSerializable)this);
    }
}

