/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReferenceData;
import com.horizen.block.MainchainHeader;
import com.horizen.block.MainchainHeader$;
import com.horizen.block.MainchainTransaction;
import com.horizen.block.MainchainTransaction$;
import com.horizen.block.MainchainTxCrosschainOutput;
import com.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import com.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import com.horizen.block.SidechainCommitmentEntryProof;
import com.horizen.block.SidechainsCommitmentTree;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.block.WithdrawalEpochCertificate$;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.params.NetworkParams;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.MC2SCAggregatedTransaction;
import com.horizen.transaction.mainchain.ForwardTransfer;
import com.horizen.transaction.mainchain.SidechainCreation;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.MerklePath;
import com.horizen.utils.MerkleTree;
import com.horizen.utils.VarInt;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

public final class MainchainBlockReference$
implements ScorexLogging,
scala.Serializable {
    public static MainchainBlockReference$ MODULE$;
    private final int MAX_MAINCHAIN_BLOCK_SIZE;
    private final int SC_CERT_BLOCK_VERSION;
    private final Logger logger;

    static {
        new MainchainBlockReference$();
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int MAX_MAINCHAIN_BLOCK_SIZE() {
        return this.MAX_MAINCHAIN_BLOCK_SIZE;
    }

    public int SC_CERT_BLOCK_VERSION() {
        return this.SC_CERT_BLOCK_VERSION;
    }

    public Try<MainchainBlockReference> create(byte[] mainchainBlockBytes, NetworkParams params) {
        Failure failure;
        Failure failure2;
        Success success;
        Tuple3 tuple3;
        Predef$.MODULE$.require(mainchainBlockBytes.length < this.MAX_MAINCHAIN_BLOCK_SIZE());
        Predef$.MODULE$.require(params.sidechainId().length == 32);
        Try<Tuple3<MainchainHeader, Seq<MainchainTransaction>, Seq<WithdrawalEpochCertificate>>> try_ = this.parseMainchainBlockBytes(mainchainBlockBytes);
        if (try_ instanceof Success && (tuple3 = (Tuple3)(success = (Success)try_).value()) != null) {
            MainchainHeader header = (MainchainHeader)tuple3._1();
            Seq mainchainTxs = (Seq)tuple3._2();
            Seq certificates = (Seq)tuple3._3();
            ObjectRef scIds = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
            ByteArrayWrapper sidechainId = new ByteArrayWrapper(params.sidechainId());
            SidechainsCommitmentTree sidechainHashMap = new SidechainsCommitmentTree();
            mainchainTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
                scIds.elem = (Set)((Set)scIds.elem).$plus$plus(tx.getRelatedSidechains());
                return BoxedUnit.UNIT;
            });
            ObjectRef mc2scTransaction = ObjectRef.create((Object)None$.MODULE$);
            ((Set)scIds.elem).foreach((Function1 & Serializable & scala.Serializable)id -> {
                MainchainBlockReference$.$anonfun$create$2(mainchainTxs, sidechainHashMap, sidechainId, mc2scTransaction, header, id);
                return BoxedUnit.UNIT;
            });
            scIds.elem = (Set)((Set)scIds.elem).$plus$plus((GenTraversableOnce)certificates.map((Function1 & Serializable & scala.Serializable)c -> new ByteArrayWrapper(c.sidechainId()), Seq$.MODULE$.canBuildFrom()));
            certificates.foreach((Function1 & Serializable & scala.Serializable)c -> {
                sidechainHashMap.addCertificate(c);
                return BoxedUnit.UNIT;
            });
            Option certificate = certificates.find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReference$.$anonfun$create$7(sidechainId, c)));
            MainchainBlockReferenceData data = ((Set)scIds.elem).isEmpty() ? new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)None$.MODULE$, (Option<MerklePath>)None$.MODULE$, (Tuple2<Option<SidechainCommitmentEntryProof>, Option<SidechainCommitmentEntryProof>>)new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$), (Option<WithdrawalEpochCertificate>)None$.MODULE$) : (((Set)scIds.elem).contains((Object)sidechainId) ? new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)((Option)mc2scTransaction.elem), sidechainHashMap.getSidechainCommitmentEntryMerklePath(sidechainId), (Tuple2<Option<SidechainCommitmentEntryProof>, Option<SidechainCommitmentEntryProof>>)new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$), (Option<WithdrawalEpochCertificate>)certificate) : new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)((Option)mc2scTransaction.elem), (Option<MerklePath>)None$.MODULE$, sidechainHashMap.getNeighbourSidechainCommitmentEntryProofs(sidechainId), (Option<WithdrawalEpochCertificate>)certificate));
            failure2 = new Success((Object)new MainchainBlockReference(header, data));
        } else if (try_ instanceof Failure) {
            Failure failure3 = (Failure)try_;
            Throwable e = failure3.exception();
            failure2 = new Failure(e);
        } else {
            throw new MatchError(try_);
        }
        Failure tryBlock = failure2;
        if (tryBlock.isFailure()) {
            failure = tryBlock;
        } else {
            ((MainchainBlockReference)tryBlock.get()).semanticValidity(params).get();
            failure = tryBlock;
        }
        return failure;
    }

    private Seq<SidechainRelatedMainchainOutput<? extends Box<? extends Proposition>>> getSidechainRelatedTransactionsOutputs(MainchainTransaction tx, ByteArrayWrapper sidechainId) {
        IntRef indexInTx = IntRef.create((int)-1);
        return (Seq)tx.getCrosschainOutputs(sidechainId).map((Function1 & Serializable & scala.Serializable)output -> {
            SidechainRelatedMainchainOutput<ForgerBox> sidechainRelatedMainchainOutput;
            ++indexInTx$1.elem;
            MainchainTxCrosschainOutput mainchainTxCrosschainOutput = output;
            if (mainchainTxCrosschainOutput instanceof MainchainTxSidechainCreationCrosschainOutput) {
                MainchainTxSidechainCreationCrosschainOutput mainchainTxSidechainCreationCrosschainOutput = (MainchainTxSidechainCreationCrosschainOutput)mainchainTxCrosschainOutput;
                sidechainRelatedMainchainOutput = new SidechainCreation(mainchainTxSidechainCreationCrosschainOutput, tx.hash(), indexInTx$1.elem);
            } else if (mainchainTxCrosschainOutput instanceof MainchainTxForwardTransferCrosschainOutput) {
                MainchainTxForwardTransferCrosschainOutput mainchainTxForwardTransferCrosschainOutput = (MainchainTxForwardTransferCrosschainOutput)mainchainTxCrosschainOutput;
                sidechainRelatedMainchainOutput = new ForwardTransfer(mainchainTxForwardTransferCrosschainOutput, tx.hash(), indexInTx$1.elem);
            } else {
                throw new MatchError((Object)mainchainTxCrosschainOutput);
            }
            return sidechainRelatedMainchainOutput;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Try<Tuple3<MainchainHeader, Seq<MainchainTransaction>, Seq<WithdrawalEpochCertificate>>> parseMainchainBlockBytes(byte[] mainchainBlockBytes) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq certificates;
            Seq transactions;
            MainchainHeader header;
            int offset = 0;
            Try<MainchainHeader> try_ = MainchainHeader$.MODULE$.create(mainchainBlockBytes, offset);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                header = (MainchainHeader)success.value();
                VarInt transactionsCount = BytesUtils.getReversedVarInt(mainchainBlockBytes, offset += header.mainchainHeaderBytes().length);
                offset += transactionsCount.size();
                transactions = (Seq)Nil$.MODULE$;
                while ((long)transactions.size() < transactionsCount.value()) {
                    MainchainTransaction tx = (MainchainTransaction)MainchainTransaction$.MODULE$.create(mainchainBlockBytes, offset).get();
                    transactions = (Seq)transactions.$colon$plus((Object)tx, Seq$.MODULE$.canBuildFrom());
                    offset += tx.size();
                }
                certificates = (Seq)Nil$.MODULE$;
                if (header.version() == MODULE$.SC_CERT_BLOCK_VERSION()) {
                    VarInt certificatesCount = BytesUtils.getReversedVarInt(mainchainBlockBytes, offset);
                    offset += certificatesCount.size();
                    while ((long)certificates.size() < certificatesCount.value()) {
                        BoxedUnit boxedUnit;
                        if (MODULE$.log().underlying().isDebugEnabled()) {
                            MODULE$.log().underlying().debug("Parse Mainchain certificate: {}", new Object[]{BytesUtils.toHexString(Arrays.copyOfRange(mainchainBlockBytes, offset, mainchainBlockBytes.length))});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        WithdrawalEpochCertificate c = WithdrawalEpochCertificate$.MODULE$.parse(mainchainBlockBytes, offset);
                        certificates = (Seq)certificates.$colon$plus((Object)c, Seq$.MODULE$.canBuildFrom());
                        offset += c.size();
                    }
                }
                if (offset < mainchainBlockBytes.length) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Input data corrupted. There are unprocessed %d bytes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mainchainBlockBytes.length - offset))})));
                }
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw e;
                }
                throw new MatchError(try_);
            }
            Tuple3 tuple3 = new Tuple3((Object)header, (Object)transactions, (Object)certificates);
            return tuple3;
        });
    }

    public MainchainBlockReference apply(MainchainHeader header, MainchainBlockReferenceData data) {
        return new MainchainBlockReference(header, data);
    }

    public Option<Tuple2<MainchainHeader, MainchainBlockReferenceData>> unapply(MainchainBlockReference x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.header(), (Object)x$0.data()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$create$3(ObjectRef sidechainRelatedTransactionsOutputs$1, ByteArrayWrapper id$1, MainchainTransaction tx) {
        return ((ArrayList)sidechainRelatedTransactionsOutputs$1.elem).addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(MODULE$.getSidechainRelatedTransactionsOutputs(tx, id$1)).asJava());
    }

    public static final /* synthetic */ void $anonfun$create$2(Seq mainchainTxs$1, SidechainsCommitmentTree sidechainHashMap$1, ByteArrayWrapper sidechainId$1, ObjectRef mc2scTransaction$1, MainchainHeader header$1, ByteArrayWrapper id) {
        block0: {
            ObjectRef sidechainRelatedTransactionsOutputs = ObjectRef.create(new ArrayList());
            mainchainTxs$1.foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReference$.$anonfun$create$3(sidechainRelatedTransactionsOutputs, id, tx)));
            MerkleTree merkleTree = MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)((ArrayList)sidechainRelatedTransactionsOutputs.elem)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.hash(), Buffer$.MODULE$.canBuildFrom())).asJava());
            sidechainHashMap$1.addForwardTransferMerkleRootHash(id, merkleTree.rootHash());
            ByteArrayWrapper byteArrayWrapper = id;
            ByteArrayWrapper byteArrayWrapper2 = sidechainId$1;
            if (byteArrayWrapper != null ? !((Object)((Object)byteArrayWrapper)).equals((Object)byteArrayWrapper2) : byteArrayWrapper2 != null) break block0;
            mc2scTransaction$1.elem = new Some((Object)new MC2SCAggregatedTransaction((ArrayList)sidechainRelatedTransactionsOutputs.elem, header$1.time()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$7(ByteArrayWrapper sidechainId$1, WithdrawalEpochCertificate c) {
        return Arrays.equals(c.sidechainId(), sidechainId$1.data());
    }

    private MainchainBlockReference$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.MAX_MAINCHAIN_BLOCK_SIZE = 0x200000;
        this.SC_CERT_BLOCK_VERSION = 3;
    }
}

