/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.api.http;

import akka.http.javadsl.marshallers.jackson.Jackson;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.server.Directives;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.unmarshalling.Unmarshaller;
import com.horizen.api.http.ApiResponse;
import com.horizen.api.http.ApiResponseUtil;
import com.horizen.api.http.FunctionsApplierOnSidechainNodeView;
import com.horizen.api.http.InternalExceptionApiErrorResponse;
import com.horizen.node.SidechainNodeView;
import com.horizen.transaction.SidechainCoreTransactionFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import scala.Option;
import scala.Some;

public abstract class ApplicationApiGroup {
    private FunctionsApplierOnSidechainNodeView functionsApplierOnSidechainNodeView;
    private SidechainCoreTransactionFactory sidechainCoreTransactionFactory;

    public abstract String basePath();

    public abstract List<Route> getRoutes();

    public final FunctionsApplierOnSidechainNodeView getFunctionsApplierOnSidechainNodeView() {
        return this.functionsApplierOnSidechainNodeView;
    }

    public final void setFunctionsApplierOnSidechainNodeView(FunctionsApplierOnSidechainNodeView functionsApplierOnSidechainNodeView) {
        this.functionsApplierOnSidechainNodeView = functionsApplierOnSidechainNodeView;
    }

    public SidechainCoreTransactionFactory getSidechainCoreTransactionFactory() {
        return this.sidechainCoreTransactionFactory;
    }

    public void setSidechainCoreTransactionFactory(SidechainCoreTransactionFactory sidechainCoreTransactionFactory) {
        this.sidechainCoreTransactionFactory = sidechainCoreTransactionFactory;
    }

    protected static Route buildRouteForApiResponse(ApiResponse data) {
        try {
            return ApiResponseUtil.toResponseAsJava(data);
        }
        catch (Exception e) {
            return Directives.complete((HttpResponse)((HttpResponse)HttpResponse.create().withStatus(500).withEntity((RequestEntity)HttpEntities.create((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, (String)("{\"error\":500, \"reason\"=" + e.getMessage() + ", detail=\"\"}")))));
        }
    }

    protected final <T> Route bindPostRequest(String path, Function<T, ApiResponse> functionToBind, Class<T> requestBodyClazz) {
        Unmarshaller unmarshaller = Jackson.unmarshaller(requestBodyClazz);
        return Directives.path((String)path, () -> Directives.post(() -> Directives.entity((Unmarshaller)unmarshaller, functionToBind.andThen(ApplicationApiGroup::buildRouteForApiResponse))));
    }

    protected final <T> Route bindPostRequest(String path, BiFunction<SidechainNodeView, T, ApiResponse> functionToBind, Class<T> clazz) {
        Function<Object, ApiResponse> transformedFunction = ApplicationApiGroup.secondArgumentPartialApply(this::applyBiFunctionOnSidechainNodeView, functionToBind);
        return this.bindPostRequest(path, transformedFunction, clazz);
    }

    protected final Route bindPostRequest(String path, Function<SidechainNodeView, ApiResponse> functionToBind) {
        return Directives.path((String)path, () -> Directives.post(() -> Directives.requestEntityEmpty(() -> Directives.onSuccess(CompletableFuture.supplyAsync(() -> this.applyFunctionOnSidechainNodeView(functionToBind)), ApplicationApiGroup::buildRouteForApiResponse))));
    }

    private ApiResponse applyFunctionOnSidechainNodeView(Function<SidechainNodeView, ApiResponse> func) {
        try {
            return this.getFunctionsApplierOnSidechainNodeView().applyFunctionOnSidechainNodeView(func);
        }
        catch (Exception e) {
            return new InternalExceptionApiErrorResponse((Option<Throwable>)Some.apply((Object)e));
        }
    }

    private <T> ApiResponse applyBiFunctionOnSidechainNodeView(T functionParameter, BiFunction<SidechainNodeView, T, ApiResponse> func) {
        try {
            return this.getFunctionsApplierOnSidechainNodeView().applyBiFunctionOnSidechainNodeView(func, functionParameter);
        }
        catch (Exception e) {
            return new InternalExceptionApiErrorResponse((Option<Throwable>)Some.apply((Object)e));
        }
    }

    public static <T, U, R> Function<T, R> secondArgumentPartialApply(BiFunction<T, U, R> f, U x) {
        Function<Object, Object> partialAppliedFunction = y -> f.apply(y, x);
        return partialAppliedFunction;
    }
}

