/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.websocket.client;

import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReference$;
import io.horizen.block.MainchainHeader;
import io.horizen.block.MainchainHeader$;
import io.horizen.block.SidechainCreationVersions$;
import io.horizen.block.SidechainsVersionsManager;
import io.horizen.mainchain.api.SendCertificateRequest;
import io.horizen.mainchain.api.SendCertificateResponse;
import io.horizen.params.NetworkParams;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.websocket.client.BackwardTransfer;
import io.horizen.websocket.client.BlockHeadersResponsePayload;
import io.horizen.websocket.client.BlockResponsePayload;
import io.horizen.websocket.client.BlocksResponsePayload;
import io.horizen.websocket.client.CertificateResponsePayload;
import io.horizen.websocket.client.CommunicationClient;
import io.horizen.websocket.client.GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$;
import io.horizen.websocket.client.GET_MULTIPLE_HEADERS_REQUEST_TYPE$;
import io.horizen.websocket.client.GET_NEW_BLOCK_HASHES_REQUEST_TYPE$;
import io.horizen.websocket.client.GET_SIDECHAIN_VERSIONS_TYPE$;
import io.horizen.websocket.client.GET_SINGLE_BLOCK_REQUEST_TYPE$;
import io.horizen.websocket.client.GET_TOP_QUALITY_CERTIFICATES_TYPE$;
import io.horizen.websocket.client.GetBlockByHashRequestPayload;
import io.horizen.websocket.client.GetBlockByHeightRequestPayload;
import io.horizen.websocket.client.GetBlockHeadersRequestPayload;
import io.horizen.websocket.client.GetBlocksAfterHashRequestPayload;
import io.horizen.websocket.client.GetBlocksAfterHeightRequestPayload;
import io.horizen.websocket.client.GetNewBlocksRequestPayload;
import io.horizen.websocket.client.GetSidechainVersionsRequestPayload;
import io.horizen.websocket.client.GetSidechainVersionsResponsePayload;
import io.horizen.websocket.client.MainchainNodeChannel;
import io.horizen.websocket.client.MainchainNodeChannelImpl$;
import io.horizen.websocket.client.NewBlocksResponsePayload;
import io.horizen.websocket.client.OnUpdateTipEventHandler;
import io.horizen.websocket.client.OnUpdateTipEventPayload;
import io.horizen.websocket.client.SEND_CERTIFICATE_REQUEST_TYPE$;
import io.horizen.websocket.client.SendCertificateRequestPayload;
import io.horizen.websocket.client.SidechainVersionsInfo;
import io.horizen.websocket.client.TopQualityCertificatePayload;
import io.horizen.websocket.client.TopQualityCertificateResponsePayload;
import io.horizen.websocket.client.TopQualityCertificates;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u000f\u001f\u0001\u001dB\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001a\u0001\n\u00039\u0005b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\u0007[\u0002\u0001\u000b\u0015\u0002%\t\u000b9\u0004A\u0011I8\t\u000by\u0004A\u0011I@\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\tY\r\u0001C!\u0003\u001bDq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002d\u0002!\t%!:\t\u000f\u00055\b\u0001\"\u0011\u0002p\u001e9\u0011q \u0010\t\u0002\t\u0005aAB\u000f\u001f\u0011\u0003\u0011\u0019\u0001\u0003\u0004B3\u0011\u0005!Q\u0001\u0005\n\u0005\u000fI\"\u0019!C\u0001\u0005\u0013AqAa\u0003\u001aA\u0003%1P\u0001\rNC&t7\r[1j]:{G-Z\"iC:tW\r\\%na2T!a\b\u0011\u0002\r\rd\u0017.\u001a8u\u0015\t\t#%A\u0005xK\n\u001cxnY6fi*\u00111\u0005J\u0001\bQ>\u0014\u0018N_3o\u0015\u0005)\u0013AA5p\u0007\u0001\u0019B\u0001\u0001\u0015/eA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u0019\u000e\u0003yI!!\r\u0010\u0003)5\u000b\u0017N\\2iC&tgj\u001c3f\u0007\"\fgN\\3m!\t\u0019d'D\u00015\u0015\t)$%A\u0003cY>\u001c7.\u0003\u00028i\tI2+\u001b3fG\"\f\u0017N\\:WKJ\u001c\u0018n\u001c8t\u001b\u0006t\u0017mZ3s!\ty\u0013(\u0003\u0002;=\t\u00192i\\7nk:L7-\u0019;j_:\u001cE.[3oi\u00061\u0001/\u0019:b[N\u0004\"!P \u000e\u0003yR!a\u000f\u0012\n\u0005\u0001s$!\u0004(fi^|'o\u001b)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0007\u0012+\u0005CA\u0018\u0001\u0011\u0015y2\u00011\u00019\u0011\u0015Y4\u00011\u0001=\u0003]\u0019\u0018\u000eZ3dQ\u0006Lgn\u001d,feNLwN\\:DC\u000eDW-F\u0001I!\u0011I\u0005kU-\u000f\u0005)s\u0005CA&+\u001b\u0005a%BA''\u0003\u0019a$o\\8u}%\u0011qJK\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&aA'ba*\u0011qJ\u000b\t\u0003)^k\u0011!\u0016\u0006\u0003-\n\nQ!\u001e;jYNL!\u0001W+\u0003!\tKH/Z!se\u0006LxK]1qa\u0016\u0014\bC\u0001.d\u001d\tY\u0016M\u0004\u0002]A:\u0011Ql\u0018\b\u0003\u0017zK\u0011!J\u0005\u0003G\u0011J!!\u000e\u0012\n\u0005\t$\u0014!G*jI\u0016\u001c\u0007.Y5o\u0007J,\u0017\r^5p]Z+'o]5p]NL!\u0001Z3\u00031MKG-Z2iC&t7I]3bi&|gNV3sg&|gN\u0003\u0002ci\u0005Y2/\u001b3fG\"\f\u0017N\\:WKJ\u001c\u0018n\u001c8t\u0007\u0006\u001c\u0007.Z0%KF$\"\u0001[6\u0011\u0005%J\u0017B\u00016+\u0005\u0011)f.\u001b;\t\u000f1,\u0011\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\u00021MLG-Z2iC&t7OV3sg&|gn]\"bG\",\u0007%\u0001\thKR\u0014En\\2l\u0005fDU-[4iiR\u0011\u0001/\u001f\t\u0004cR4X\"\u0001:\u000b\u0005MT\u0013\u0001B;uS2L!!\u001e:\u0003\u0007Q\u0013\u0018\u0010\u0005\u00024o&\u0011\u0001\u0010\u000e\u0002\u0018\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016DQA_\u0004A\u0002m\fa\u0001[3jO\"$\bCA\u0015}\u0013\ti(FA\u0002J]R\fabZ3u\u00052|7m\u001b\"z\u0011\u0006\u001c\b\u000eF\u0002q\u0003\u0003Aq!a\u0001\t\u0001\u0004\t)!\u0001\u0003iCND\u0007cA%\u0002\b%\u0019\u0011\u0011\u0002*\u0003\rM#(/\u001b8h\u0003m\u0001(o\\2fgN\u0014En\\2l%\u0016\u001c\bo\u001c8tKB\u000b\u0017\u0010\\8bIR\u0019\u0001/a\u0004\t\u000f\u0005E\u0011\u00021\u0001\u0002\u0014\u00051a-\u001e;ve\u0016\u0004b!!\u0006\u0002\u001c\u0005}QBAA\f\u0015\r\tIBK\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u000f\u0003/\u0011aAR;ukJ,\u0007cA\u0018\u0002\"%\u0019\u00111\u0005\u0010\u0003)\tcwnY6SKN\u0004xN\\:f!\u0006LHn\\1e\u0003e9W\r\u001e\"m_\u000e\\\u0007*Y:iKN\fe\r^3s\u0011\u0016Lw\r\u001b;\u0015\r\u0005%\u0012QHA !\u0011\tH/a\u000b\u0011\r\u00055\u0012qGA\u0003\u001d\u0011\ty#a\r\u000f\u0007-\u000b\t$C\u0001,\u0013\r\t)DK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI$a\u000f\u0003\u0007M+\u0017OC\u0002\u00026)BQA\u001f\u0006A\u0002mDa!!\u0011\u000b\u0001\u0004Y\u0018!\u00027j[&$\u0018aF4fi\ncwnY6ICNDWm]!gi\u0016\u0014\b*Y:i)\u0019\tI#a\u0012\u0002J!9\u00111A\u0006A\u0002\u0005\u0015\u0001BBA!\u0017\u0001\u000710A\thKRtUm\u001e\"m_\u000e\\\u0007*Y:iKN$b!a\u0014\u0002X\u0005m\u0003\u0003B9u\u0003#\u0002b!KA*w\u0006-\u0012bAA+U\t1A+\u001e9mKJBq!!\u0017\r\u0001\u0004\tY#A\u0007m_\u000e\fGo\u001c:ICNDWm\u001d\u0005\u0007\u0003\u0003b\u0001\u0019A>\u0002%\u001d,GOQ3ti\u000e{W.\\8o!>Lg\u000e\u001e\u000b\u0005\u0003C\n)\u0007\u0005\u0003ri\u0006\r\u0004CB\u0015\u0002Tm\f)\u0001C\u0004\u0002Z5\u0001\r!a\u000b\u0002\u001f\u001d,GO\u00117pG.DU-\u00193feN$B!a\u001b\u0002vA!\u0011\u000f^A7!\u0019\ti#a\u000e\u0002pA\u00191'!\u001d\n\u0007\u0005MDGA\bNC&t7\r[1j]\"+\u0017\rZ3s\u0011\u001d\t9H\u0004a\u0001\u0003W\ta\u0001[1tQ\u0016\u001c\u0018A\t9s_\u000e,7o\u001d\"m_\u000e\\\u0007*Z1eKJ\u001c(+Z:q_:\u001cX\rU1zY>\fG\r\u0006\u0003\u0002l\u0005u\u0004bBA\t\u001f\u0001\u0007\u0011q\u0010\t\u0007\u0003+\tY\"!!\u0011\u0007=\n\u0019)C\u0002\u0002\u0006z\u00111D\u00117pG.DU-\u00193feN\u0014Vm\u001d9p]N,\u0007+Y=m_\u0006$\u0017!G:vEN\u001c'/\u001b2f\u001f:,\u0006\u000fZ1uKRK\u0007/\u0012<f]R$B!a#\u0002\u000eB\u0019\u0011\u000f\u001e5\t\u000f\u0005=\u0005\u00031\u0001\u0002\u0012\u00069\u0001.\u00198eY\u0016\u0014\bcA\u0018\u0002\u0014&\u0019\u0011Q\u0013\u0010\u0003/=sW\u000b\u001d3bi\u0016$\u0016\u000e]#wK:$\b*\u00198eY\u0016\u0014\u0018aG;ogV\u00147o\u0019:jE\u0016|e.\u00169eCR,G+\u001b9Fm\u0016tG\u000fF\u0002i\u00037Cq!a$\u0012\u0001\u0004\t\t*A\btK:$7)\u001a:uS\u001aL7-\u0019;f)\u0011\t\t+a-\u0011\tE$\u00181\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\r\t\u0007/\u001b\u0006\u0004\u0003[\u0013\u0013!C7bS:\u001c\u0007.Y5o\u0013\u0011\t\t,a*\u0003/M+g\u000eZ\"feRLg-[2bi\u0016\u0014Vm\u001d9p]N,\u0007bBA[%\u0001\u0007\u0011qW\u0001\u0013G\u0016\u0014H/\u001b4jG\u0006$XMU3rk\u0016\u001cH\u000f\u0005\u0003\u0002&\u0006e\u0016\u0002BA^\u0003O\u0013acU3oI\u000e+'\u000f^5gS\u000e\fG/\u001a*fcV,7\u000f^\u0001\"aJ|7-Z:t\u0007\u0016\u0014H/\u001b4jG\u0006$XMU3ta>t7/\u001a)bs2|\u0017\r\u001a\u000b\u0005\u0003G\u000b\t\rC\u0004\u0002\u0012M\u0001\r!a1\u0011\r\u0005U\u00111DAc!\ry\u0013qY\u0005\u0004\u0003\u0013t\"AG\"feRLg-[2bi\u0016\u0014Vm\u001d9p]N,\u0007+Y=m_\u0006$\u0017!G4fiR{\u0007/U;bY&$\u0018pQ3si&4\u0017nY1uKN$B!a4\u0002XB!\u0011\u000f^Ai!\ry\u00131[\u0005\u0004\u0003+t\"A\u0006+paF+\u0018\r\\5us\u000e+'\u000f^5gS\u000e\fG/Z:\t\u000f\u0005eG\u00031\u0001\u0002\u0006\u0005!1oY%e\u0003)9W\r\u001e,feNLwN\u001c\u000b\u00043\u0006}\u0007BBAq+\u0001\u00071+A\u0006tS\u0012,7\r[1j]&#\u0017aC4fiZ+'o]5p]N$2\u0001SAt\u0011\u001d\tIO\u0006a\u0001\u0003W\fAb]5eK\u000eD\u0017-\u001b8JIN\u0004R!!\f\u00028M\u000bAcZ3u'&$Wm\u00195bS:4VM]:j_:\u001cH\u0003BAy\u0003w\u0004B!\u001d;\u0002tB1\u0011QFA\u001c\u0003k\u00042aLA|\u0013\r\tIP\b\u0002\u0016'&$Wm\u00195bS:4VM]:j_:\u001c\u0018J\u001c4p\u0011\u001d\tip\u0006a\u0001\u0003W\tQa]2JIN\f\u0001$T1j]\u000eD\u0017-\u001b8O_\u0012,7\t[1o]\u0016d\u0017*\u001c9m!\ty\u0013d\u0005\u0002\u001aQQ\u0011!\u0011A\u0001\u0017\u001b\u0006CvlU%E\u000b\u000eC\u0015)\u0013(T?J+\u0015+V#T)V\t10A\fN\u0003b{6+\u0013#F\u0007\"\u000b\u0015JT*`%\u0016\u000bV+R*UA\u0001")
public class MainchainNodeChannelImpl
implements MainchainNodeChannel,
SidechainsVersionsManager {
    private final CommunicationClient client;
    private final NetworkParams params;
    private Map<ByteArrayWrapper, Enumeration.Value> sidechainsVersionsCache;

    public static int MAX_SIDECHAINS_REQUEST() {
        return MainchainNodeChannelImpl$.MODULE$.MAX_SIDECHAINS_REQUEST();
    }

    public Map<ByteArrayWrapper, Enumeration.Value> sidechainsVersionsCache() {
        return this.sidechainsVersionsCache;
    }

    public void sidechainsVersionsCache_$eq(Map<ByteArrayWrapper, Enumeration.Value> x$1) {
        this.sidechainsVersionsCache = x$1;
    }

    @Override
    public Try<MainchainBlockReference> getBlockByHeight(int height) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$, new GetBlockByHeightRequestPayload(height), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    @Override
    public Try<MainchainBlockReference> getBlockByHash(String hash) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$, new GetBlockByHashRequestPayload(hash), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    private Try<MainchainBlockReference> processBlockResponsePayload(Future<BlockResponsePayload> future) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BlockResponsePayload response = (BlockResponsePayload)Await$.MODULE$.result((Awaitable)future, (Duration)$this.client.requestTimeoutDuration());
            byte[] blockBytes = BytesUtils.fromHexString(response.block());
            return (MainchainBlockReference)MainchainBlockReference$.MODULE$.create(blockBytes, $this.params, this).get();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHeight(int height, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetBlocksAfterHeightRequestPayload(height, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHash(String hash, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetBlocksAfterHashRequestPayload(hash, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Tuple2<Object, Seq<String>>> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<NewBlocksResponsePayload> future = $this.client.sendRequest(GET_NEW_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetNewBlocksRequestPayload(locatorHashes, limit), NewBlocksResponsePayload.class);
            NewBlocksResponsePayload response = (NewBlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)response.height()), response.hashes());
        });
    }

    @Override
    public Try<Tuple2<Object, String>> getBestCommonPoint(Seq<String> locatorHashes) {
        Success success;
        Tuple2 tuple2;
        Try<Tuple2<Object, Seq<String>>> try_ = this.getNewBlockHashes(locatorHashes, 1);
        if (!(try_ instanceof Success) || (tuple2 = (Tuple2)(success = (Success)try_).value()) == null) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError(try_);
        }
        int height = tuple2._1$mcI$sp();
        Seq hashes = (Seq)tuple2._2();
        Success success2 = new Success((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)height), hashes.head()));
        return success2;
    }

    @Override
    public Try<Seq<MainchainHeader>> getBlockHeaders(Seq<String> hashes) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockHeadersResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_HEADERS_REQUEST_TYPE$.MODULE$, new GetBlockHeadersRequestPayload(hashes), BlockHeadersResponsePayload.class);
            return (Seq)this.processBlockHeadersResponsePayload(future).get();
        });
    }

    private Try<Seq<MainchainHeader>> processBlockHeadersResponsePayload(Future<BlockHeadersResponsePayload> future) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BlockHeadersResponsePayload response = (BlockHeadersResponsePayload)Await$.MODULE$.result((Awaitable)future, (Duration)$this.client.requestTimeoutDuration());
            Seq<String> strHeaders = response.headers();
            Seq headers = (Seq)strHeaders.map((Function1 & Serializable & scala.Serializable)str -> (MainchainHeader)MainchainHeader$.MODULE$.create(BytesUtils.fromHexString(str), 0).get(), Seq$.MODULE$.canBuildFrom());
            return headers;
        });
    }

    @Override
    public Try<BoxedUnit> subscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        return this.client.registerEventHandler(0, handler, OnUpdateTipEventPayload.class);
    }

    @Override
    public void unsubscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        this.client.unregisterEventHandler(0, handler);
    }

    @Override
    public Try<SendCertificateResponse> sendCertificate(SendCertificateRequest certificateRequest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            Seq backwardTransfers = (Seq)certificateRequest.backwardTransfers().map((Function1 & Serializable & scala.Serializable)bt -> new BackwardTransfer(bt.address(), bt.amount()), Seq$.MODULE$.canBuildFrom());
            Option<String> option = certificateRequest.fee();
            if (option instanceof Some) {
                String fee;
                Some some = (Some)option;
                string = fee = (String)some.value();
            } else if (None$.MODULE$.equals(option)) {
                string = "-1";
            } else {
                throw new MatchError(option);
            }
            String fee = string;
            SendCertificateRequestPayload requestPayload = new SendCertificateRequestPayload(BytesUtils.toHexString(certificateRequest.sidechainId()), certificateRequest.epochNumber(), certificateRequest.quality(), BytesUtils.toHexString(certificateRequest.endEpochCumCommTreeHash()), BytesUtils.toHexString(certificateRequest.proofBytes()), (Seq<BackwardTransfer>)backwardTransfers, certificateRequest.ftrMinAmount(), certificateRequest.btrMinFee(), fee, (Seq<String>)((Seq)certificateRequest.fieldElementCertificateFields().map((Function1 & Serializable & scala.Serializable)bytes -> BytesUtils.toHexString(bytes), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)certificateRequest.bitVectorCertificateFields().map((Function1 & Serializable & scala.Serializable)bytes -> BytesUtils.toHexString(bytes), Seq$.MODULE$.canBuildFrom())));
            Future<CertificateResponsePayload> future = $this.client.sendRequest(SEND_CERTIFICATE_REQUEST_TYPE$.MODULE$, requestPayload, CertificateResponsePayload.class);
            return this.processCertificateResponsePayload(future);
        });
    }

    private SendCertificateResponse processCertificateResponsePayload(Future<CertificateResponsePayload> future) {
        CertificateResponsePayload response = (CertificateResponsePayload)Await$.MODULE$.result(future, (Duration)this.client.requestTimeoutDuration());
        return new SendCertificateResponse(BytesUtils.fromHexString(response.certificateHash()));
    }

    @Override
    public Try<TopQualityCertificates> getTopQualityCertificates(String scId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<TopQualityCertificateResponsePayload> future = $this.client.sendRequest(GET_TOP_QUALITY_CERTIFICATES_TYPE$.MODULE$, new TopQualityCertificatePayload(scId), TopQualityCertificateResponsePayload.class);
            TopQualityCertificateResponsePayload response = (TopQualityCertificateResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return new TopQualityCertificates(response.mempoolTopQualityCert(), response.chainTopQualityCert());
        });
    }

    @Override
    public Enumeration.Value getVersion(ByteArrayWrapper sidechainId) {
        return (Enumeration.Value)((Tuple2)this.getVersions((Seq<ByteArrayWrapper>)((Seq)new .colon.colon((Object)sidechainId, (List)Nil$.MODULE$))).head())._2();
    }

    @Override
    public Map<ByteArrayWrapper, Enumeration.Value> getVersions(Seq<ByteArrayWrapper> sidechainIds) {
        Seq unknown = (Seq)sidechainIds.filterNot((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)MainchainNodeChannelImpl.$anonfun$getVersions$1(this, id)));
        unknown.grouped(MainchainNodeChannelImpl$.MODULE$.MAX_SIDECHAINS_REQUEST()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            MainchainNodeChannelImpl.$anonfun$getVersions$2(this, group);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)sidechainIds.map((Function1 & Serializable & scala.Serializable)id -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), this.sidechainsVersionsCache().apply(id)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Try<Seq<SidechainVersionsInfo>> getSidechainVersions(Seq<String> scIds) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<GetSidechainVersionsResponsePayload> future = $this.client.sendRequest(GET_SIDECHAIN_VERSIONS_TYPE$.MODULE$, new GetSidechainVersionsRequestPayload(scIds), GetSidechainVersionsResponsePayload.class);
            GetSidechainVersionsResponsePayload response = (GetSidechainVersionsResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.sidechainVersions();
        });
    }

    public static final /* synthetic */ boolean $anonfun$getVersions$1(MainchainNodeChannelImpl $this, ByteArrayWrapper id) {
        return $this.sidechainsVersionsCache().contains((Object)id);
    }

    public static final /* synthetic */ boolean $anonfun$getVersions$4(SidechainVersionsInfo check$ifrefutable$1) {
        SidechainVersionsInfo sidechainVersionsInfo = check$ifrefutable$1;
        boolean bl = sidechainVersionsInfo != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getVersions$2(MainchainNodeChannelImpl $this, Seq group) {
        Try<Seq<SidechainVersionsInfo>> try_ = $this.getSidechainVersions((Seq<String>)((Seq)group.map((Function1 & Serializable & scala.Serializable)id -> BytesUtils.toHexString(BytesUtils.reverseBytes(id.data())), Seq$.MODULE$.canBuildFrom())));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new RuntimeException("Can't retrieve sidechain versions.", exception);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        Seq res = (Seq)success.value();
        res.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MainchainNodeChannelImpl.$anonfun$getVersions$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)info -> {
            $this.sidechainsVersionsCache_$eq((Map<ByteArrayWrapper, Enumeration.Value>)$this.sidechainsVersionsCache().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ByteArrayWrapper(BytesUtils.reverseBytes(BytesUtils.fromHexString(info.scId())))), (Object)SidechainCreationVersions$.MODULE$.getVersion(info.version()))));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MainchainNodeChannelImpl(CommunicationClient client, NetworkParams params) {
        this.client = client;
        this.params = params;
        this.sidechainsVersionsCache = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

