/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.horizen.librustsidechains.FieldElement;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.cryptolibprovider.utils.InMemorySparseMerkleTreeWrapper;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.utxo.utils.UtxoMerkleTreeLeafInfo;
import io.horizen.utxo.utils.UtxoMerkleTreeLeafInfoSerializer$;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\n\u0014\u0001qA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006o\u0001!\t\u0001\u000f\u0005\by\u0001\u0001\r\u0011\"\u0001>\u0011\u001d1\u0005\u00011A\u0005\u0002\u001dCa!\u0014\u0001!B\u0013q\u0004\"\u0002(\u0001\t\u0013y\u0005B\u0002)\u0001\t\u00039\u0012\u000bC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003{\u0001\u0011\u00051\u0010\u0003\u0004\u007f\u0001\u0011\u0005qc \u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005e\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0002$'&$Wm\u00195bS:\u001cF/\u0019;f+RDx.T3sW2,GK]3f'R|'/Y4f\u0015\t!R#A\u0004ti>\u0014\u0018mZ3\u000b\u0005Y9\u0012\u0001B;uq>T!\u0001G\r\u0002\u000f!|'/\u001b>f]*\t!$\u0001\u0002j_\u000e\u00011#\u0002\u0001\u001eG-\u0002\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!Q\u000f^5m\u0015\u0005A\u0013AB:qCJ\\'0\u0003\u0002+K\ti1\u000b]1sWjdunZ4j]\u001e\u0004\"\u0001\f\u0018\u000e\u00035R!\u0001F\f\n\u0005=j#\u0001F*jI\u0016\u001c\u0007.Y5o'R|'/Y4f\u0013:4w\u000e\u0005\u00022e5\tq#\u0003\u00024/\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bC\u0001\u00176\u0013\t1TFA\u0004Ti>\u0014\u0018mZ3\u0002\rqJg.\u001b;?)\tI4\b\u0005\u0002;\u00015\t1\u0003C\u0003\u0015\u0005\u0001\u0007A'A\tnKJ\\G.\u001a+sK\u0016<&/\u00199qKJ,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ!\u001e;jYNT!aQ\f\u0002#\r\u0014\u0018\u0010\u001d;pY&\u0014\u0007O]8wS\u0012,'/\u0003\u0002F\u0001\ny\u0012J\\'f[>\u0014\u0018p\u00159beN,W*\u001a:lY\u0016$&/Z3Xe\u0006\u0004\b/\u001a:\u0002+5,'o\u001b7f)J,Wm\u0016:baB,'o\u0018\u0013fcR\u0011\u0001j\u0013\t\u0003=%K!AS\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0019\u0012\t\t\u00111\u0001?\u0003\rAH%M\u0001\u0013[\u0016\u00148\u000e\\3Ue\u0016,wK]1qa\u0016\u0014\b%\u0001\bm_\u0006$W*\u001a:lY\u0016$&/Z3\u0015\u0003y\nQbY1mGVd\u0017\r^3MK\u00064GC\u0001*\\!\t\u0019\u0016,D\u0001U\u0015\t)f+A\tmS\n\u0014Xo\u001d;tS\u0012,7\r[1j]NT!\u0001G,\u000b\u0003a\u000b1aY8n\u0013\tQFK\u0001\u0007GS\u0016dG-\u00127f[\u0016tG\u000fC\u0003]\u000f\u0001\u0007Q,A\u0002c_b\u00042A\u00181c\u001b\u0005y&B\u0001/\u0016\u0013\t\twLA\u0002C_b\u0004\"a\u00194\u000e\u0003\u0011T!!Z\f\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0003O\u0012\u00141\u0002\u0015:pa>\u001c\u0018\u000e^5p]\u0006Yq-\u001a;MK\u00064\u0017J\u001c4p)\tQ'\u000fE\u0002\u001fW6L!\u0001\\\u0010\u0003\r=\u0003H/[8o!\tq\u0007/D\u0001p\u0015\t\tU#\u0003\u0002r_\n1R\u000b\u001e=p\u001b\u0016\u00148\u000e\\3Ue\u0016,G*Z1g\u0013:4w\u000eC\u0003t\u0011\u0001\u0007A/A\u0003c_bLE\rE\u0002\u001fk^L!A^\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005yA\u0018BA= \u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\u001d,G/T3sW2,\u0007+\u0019;i)\taX\u0010E\u0002\u001fWRDQa]\u0005A\u0002Q\f\u0001cZ3u\u00032dG*Z1wKNLeNZ8\u0016\u0005\u0005\u0005\u0001#BA\u0002\u0003'ig\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017Y\u0012A\u0002\u001fs_>$h(C\u0001!\u0013\r\t\tbH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\u0007M+\u0017OC\u0002\u0002\u0012}\t\u0011cZ3u\u001b\u0016\u00148\u000e\\3Ue\u0016,'k\\8u+\u0005!\u0018AB;qI\u0006$X\r\u0006\u0005\u0002\"\u0005-\u0012\u0011HA !\u0015\t\u0019#a\n:\u001b\t\t)C\u0003\u0002'?%!\u0011\u0011FA\u0013\u0005\r!&/\u001f\u0005\b\u0003[a\u0001\u0019AA\u0018\u0003\u001d1XM]:j_:\u0004B!!\r\u000265\u0011\u00111\u0007\u0006\u0003\u0003^IA!a\u000e\u00024\t\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM\u001d\u0005\b\u0003wa\u0001\u0019AA\u001f\u00035\u0011w\u000e_3t)>\f\u0005\u000f]3oIB)\u00111AA\n;\"9\u0011\u0011\t\u0007A\u0002\u0005\r\u0013\u0001\u00052pq\u0016\u001cHk\u001c*f[>4XmU3u!\u0019\t)%!\u0014\u000209!\u0011qIA%!\r\t9aH\u0005\u0004\u0003\u0017z\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005E#aA*fi*\u0019\u00111J\u0010\u0002\u001b1\f7\u000f\u001e,feNLwN\\%e+\t\t9\u0006\u0005\u0003\u001fW\u0006=\u0012\u0001\u0005:pY2\u0014\u0017mY6WKJ\u001c\u0018n\u001c8t)\t\ti\u0006\u0005\u0004\u0002\u0004\u0005M\u0011q\u0006\u000b\u0005\u0003C\n9\u0007\u0005\u0004\u0002\u0004\u0005\r\u0014qF\u0005\u0005\u0003K\n9B\u0001\u0003MSN$\bbBA5\u001f\u0001\u0007\u00111N\u0001\u0014[\u0006Dh*^7cKJ|eMV3sg&|gn\u001d\t\u0004=\u00055\u0014bAA8?\t\u0019\u0011J\u001c;\u0002\u0011I|G\u000e\u001c2bG.$B!!\t\u0002v!9\u0011Q\u0006\tA\u0002\u0005=\u0012aB5t\u000b6\u0004H/_\u000b\u0003\u0003w\u00022AHA?\u0013\r\tyh\b\u0002\b\u0005>|G.Z1o\u0001")
public class SidechainStateUtxoMerkleTreeStorage
implements SparkzLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private InMemorySparseMerkleTreeWrapper merkleTreeWrapper;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public InMemorySparseMerkleTreeWrapper merkleTreeWrapper() {
        return this.merkleTreeWrapper;
    }

    public void merkleTreeWrapper_$eq(InMemorySparseMerkleTreeWrapper x$1) {
        this.merkleTreeWrapper = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public InMemorySparseMerkleTreeWrapper io$horizen$utxo$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree() {
        void var2_2;
        int treeHeight = CryptoLibProvider$.MODULE$.cswCircuitFunctions().utxoMerkleTreeHeight();
        InMemorySparseMerkleTreeWrapper merkleTree = new InMemorySparseMerkleTreeWrapper(treeHeight);
        scala.collection.immutable.Map newLeaves = ((TraversableOnce)this.getAllLeavesInfo().map((Function1 & Serializable & scala.Serializable)leafInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(leafInfo.position())), (Object)FieldElement.deserialize((byte[])leafInfo.leaf())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            merkleTree.addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newLeaves).asJava());
        }
        finally {
            newLeaves.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                SidechainStateUtxoMerkleTreeStorage.$anonfun$loadMerkleTree$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    public FieldElement calculateLeaf(Box<Proposition> box) {
        return CryptoLibProvider$.MODULE$.cswCircuitFunctions().getUtxoMerkleTreeLeaf(box);
    }

    public Option<UtxoMerkleTreeLeafInfo> getLeafInfo(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try<UtxoMerkleTreeLeafInfo> try_ = UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                UtxoMerkleTreeLeafInfo leafInfo = (UtxoMerkleTreeLeafInfo)success.value();
                option2 = Option$.MODULE$.apply((Object)leafInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while UtxoMerkleTreeLeafInfo parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getMerklePath(byte[] boxId) {
        return this.getLeafInfo(boxId).map((Function1 & Serializable & scala.Serializable)leafInfo -> this.merkleTreeWrapper().merklePath(leafInfo.position()));
    }

    public Seq<UtxoMerkleTreeLeafInfo> getAllLeavesInfo() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> (UtxoMerkleTreeLeafInfo)UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytes(((ByteArrayWrapper)pair.getValue()).data()), Buffer$.MODULE$.canBuildFrom());
    }

    public byte[] getMerkleTreeRoot() {
        return this.merkleTreeWrapper().calculateRoot();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> update(ByteArrayWrapper version, Seq<Box<Proposition>> boxesToAppend, Set<ByteArrayWrapper> boxesToRemoveSet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxesToAppend != null, (Function0 & Serializable & scala.Serializable)() -> "List of boxes to add must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxesToRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            java.util.List removeList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)boxesToRemoveSet.map((Function1 & Serializable & scala.Serializable)id -> Utils.calculateKey(id.data()), Set$.MODULE$.canBuildFrom())).toList()).asJava();
            Predef$.MODULE$.require(this.merkleTreeWrapper().removeLeaves((long[])((TraversableOnce)boxesToRemoveSet.flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(this.getLeafInfo(id.data()).map((Function1 & Serializable & scala.Serializable)leafInfo -> BoxesRunTime.boxToLong((long)leafInfo.position()))), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long())), (Function0 & Serializable & scala.Serializable)() -> "Failed to remove leaves from UtxoMerkleTree");
            Seq newLeavesPositions = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.merkleTreeWrapper().leftmostEmptyPositions(boxesToAppend.size())).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)), Buffer$.MODULE$.canBuildFrom());
            if (newLeavesPositions.size() != boxesToAppend.size()) {
                throw new IllegalStateException("Not enough empty leaves in the UTXOMerkleTree.");
            }
            Seq leavesToAppend = (Seq)((IterableLike)boxesToAppend.map((Function1 & Serializable & scala.Serializable)box -> new Tuple2((Object)Utils.calculateKey(box.id()), (Object)this.calculateLeaf((Box<Proposition>)box)), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)newLeavesPositions, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(this.merkleTreeWrapper().addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 != null && (leaf = (FieldElement)tuple22._2()) != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(l)), (Object)fieldElement);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), (Function0 & Serializable & scala.Serializable)() -> "Failed to add leaves to UtxoMerkleTree");
            java.util.List updateList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ByteArrayWrapper byteArrayWrapper;
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$2;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 == null) break block2;
                        ByteArrayWrapper key = (ByteArrayWrapper)tuple22._1();
                        leaf = (FieldElement)tuple22._2();
                        if (key == null) break block2;
                        byteArrayWrapper = key;
                        if (leaf != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                byte[] leafBytes = fieldElement.serializeFieldElement();
                fieldElement.freeFieldElement();
                Pair<ByteArrayWrapper, ByteArrayWrapper> pair = new Pair<ByteArrayWrapper, ByteArrayWrapper>(byteArrayWrapper, new ByteArrayWrapper(new UtxoMerkleTreeLeafInfo(leafBytes, l).bytes()));
                return pair;
            }, Seq$.MODULE$.canBuildFrom())).asJava();
            $this.storage.update(version, updateList, removeList);
            return this;
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SidechainStateUtxoMerkleTreeStorage $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.merkleTreeWrapper().close();
                this.$outer.merkleTreeWrapper_$eq(this.$outer.io$horizen$utxo$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.merkleTreeWrapper().close();
            this.merkleTreeWrapper_$eq(this.io$horizen$utxo$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$loadMerkleTree$2(Tuple2 x$1) {
        ((FieldElement)x$1._2()).close();
    }

    public SidechainStateUtxoMerkleTreeStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        this.merkleTreeWrapper = this.io$horizen$utxo$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree();
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
    }
}

