/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.consensus.package$ConsensusEpochNumber$;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.ForgerBoxMerklePathInfoSerializer$;
import io.horizen.utils.ForgingStakeMerklePathInfo;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.Pair;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.ForgerBoxSerializer;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\f\u0019\u0001\u0005B\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\u0007\u0003\u0002!\t\u0001\b\"\t\u0011u\u0003!\u0019!C\u00019yCaa\u0018\u0001!\u0002\u0013\u0019\u0005\u0002\u00031\u0001\u0005\u0004%\t\u0001H1\t\r\u0015\u0004\u0001\u0015!\u0003c\u0011!1\u0007A1A\u0005\u0002q9\u0007B\u00028\u0001A\u0003%\u0001\u000e\u0003\u0005p\u0001\t\u0007I\u0011\u0001\u000fq\u0011\u0019A\b\u0001)A\u0005c\")\u0011\u0010\u0001C\u0005=\")!\u0010\u0001C\u0001w\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002R\u0001!\t!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004BBA9\u0001\u0011\u0005\u0011MA\fG_J<\u0017N\\4C_b,7/\u00138g_N#xN]1hK*\u0011\u0011DG\u0001\bgR|'/Y4f\u0015\tYB$\u0001\u0003vib|'BA\u000f\u001f\u0003\u001dAwN]5{K:T\u0011aH\u0001\u0003S>\u001c\u0001aE\u0003\u0001E!b\u0013\u0007\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011\u0001H\u0005\u0003Wq\u0011abU5eK\u000eD\u0017-\u001b8UsB,7\u000f\u0005\u0002._5\taF\u0003\u0002\u001a9%\u0011\u0001G\f\u0002\u0015'&$Wm\u00195bS:\u001cFo\u001c:bO\u0016LeNZ8\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001B;uS2T\u0011AN\u0001\u0007gB\f'o\u001b>\n\u0005a\u001a$!D*qCJ\\'\u0010T8hO&tw\r\u0005\u0002.u%\u00111H\f\u0002\b'R|'/Y4f\u0003\u0019a\u0014N\\5u}Q\u0011a\b\u0011\t\u0003\u007f\u0001i\u0011\u0001\u0007\u0005\u00063\t\u0001\r!O\u0001\tKB|7\r[&fsR\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rr\tQ!\u001e;jYNL!\u0001S#\u0003!\tKH/Z!se\u0006LxK]1qa\u0016\u0014\b\"\u0002&\u0004\u0001\u0004Y\u0015!B3q_\u000eD\u0007C\u0001'[\u001d\tiuK\u0004\u0002O+:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005uq\u0012B\u0001,\u001d\u0003%\u0019wN\\:f]N,8/\u0003\u0002Y3\u00069\u0001/Y2lC\u001e,'B\u0001,\u001d\u0013\tYFL\u0001\u000bD_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\u0006\u00031f\u000baBZ8sO\u0016\u0014(i\u001c=fg.+\u00170F\u0001D\u0003=1wN]4fe\n{\u00070Z:LKf\u0004\u0013aF7bq:+XNY3s\u001f\u001a\u001cFo\u001c:fI\u0016\u0003xn\u00195t+\u0005\u0011\u0007CA\u0012d\u0013\t!GEA\u0002J]R\f\u0001$\\1y\u001dVl'-\u001a:PMN#xN]3e\u000bB|7\r[:!\u0003!2wN]4j]\u001e\u001cF/Y6f\u001b\u0016\u00148\u000e\\3QCRD\u0017J\u001c4p\u0019&\u001cHoU3sS\u0006d\u0017N_3s+\u0005A\u0007c\u0001#jW&\u0011!.\u0012\u0002\u000f\u0019&\u001cHoU3sS\u0006d\u0017N_3s!\t!E.\u0003\u0002n\u000b\nQbi\u001c:hS:<7\u000b^1lK6+'o\u001b7f!\u0006$\b.\u00138g_\u0006Icm\u001c:hS:<7\u000b^1lK6+'o\u001b7f!\u0006$\b.\u00138g_2K7\u000f^*fe&\fG.\u001b>fe\u0002\nqCZ8sO\u0016\u0014(i\u001c=MSN$8+\u001a:jC2L'0\u001a:\u0016\u0003E\u00042\u0001R5s!\t\u0019h/D\u0001u\u0015\t)($A\u0002c_bL!a\u001e;\u0003\u0013\u0019{'oZ3s\u0005>D\u0018\u0001\u00074pe\u001e,'OQ8y\u0019&\u001cHoU3sS\u0006d\u0017N_3sA\u0005Ya.\u001a=u-\u0016\u00148/[8o\u0003\u0001*\b\u000fZ1uK\u001a{'oZ5oON#\u0018m[3NKJ\\G.\u001a)bi\"LeNZ8\u0015\u000bq\f\u0019!!\u0002\u0011\u0007u|h(D\u0001\u007f\u0015\t!D%C\u0002\u0002\u0002y\u00141\u0001\u0016:z\u0011\u0015QU\u00021\u0001L\u0011\u001d\t9!\u0004a\u0001\u0003\u0013\tACY8y\u001b\u0016\u00148\u000e\\3QCRD\u0017J\u001c4p'\u0016\f\b#BA\u0006\u0003'Yg\u0002BA\u0007\u0003#q1\u0001UA\b\u0013\u0005)\u0013B\u0001-%\u0013\u0011\t)\"a\u0006\u0003\u0007M+\u0017O\u0003\u0002YI\u0005\tR\u000f\u001d3bi\u00164uN]4fe\n{\u00070Z:\u0015\u000fq\fi\"!\t\u0002(!1\u0011q\u0004\bA\u0002\r\u000bqA^3sg&|g\u000eC\u0004\u0002$9\u0001\r!!\n\u0002-\u0019|'oZ3s\u0005>DXm\u001d+p\u0003B\u0004XM\u001c3TKF\u0004R!a\u0003\u0002\u0014IDq!!\u000b\u000f\u0001\u0004\tY#A\bc_bLEm\u001d*f[>4XmU3r!\u0019\tY!a\u0005\u0002.A)1%a\f\u00024%\u0019\u0011\u0011\u0007\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\n)$C\u0002\u00028\u0011\u0012AAQ=uK\u0006qq-\u001a;G_J<WM\u001d\"pq\u0016\u001cXCAA\u001f!\u0015\u0019\u0013qHA\u0013\u0013\r\t\t\u0005\n\u0002\u0007\u001fB$\u0018n\u001c8\u0002K\u001d,GOR8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>4uN]#q_\u000eDG\u0003BA$\u0003\u0013\u0002RaIA \u0003\u0013AQA\u0013\tA\u0002-\u000bQ\u0002\\1tiZ+'o]5p]&#WCAA(!\u0011\u0019\u0013qH\"\u0002!I|G\u000e\u001c2bG.4VM]:j_:\u001cHCAA+!\u0015\tY!a\u0016D\u0013\u0011\tI&a\u0006\u0003\t1K7\u000f\u001e\u000b\u0005\u0003+\ni\u0006\u0003\u0004\u0002`M\u0001\rAY\u0001\u0014[\u0006Dh*^7cKJ|eMV3sg&|gn]\u0001\te>dGNY1dWR\u0019A0!\u001a\t\r\u0005}A\u00031\u0001D\u0003\u001dI7/R7qif,\"!a\u001b\u0011\u0007\r\ni'C\u0002\u0002p\u0011\u0012qAQ8pY\u0016\fg.\u0001\tok6\u0014WM](g-\u0016\u00148/[8og\u0002")
public class ForgingBoxesInfoStorage
implements SidechainTypes,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final ByteArrayWrapper forgerBoxesKey;
    private final int maxNumberOfStoredEpochs;
    private final ListSerializer<ForgingStakeMerklePathInfo> forgingStakeMerklePathInfoListSerializer;
    private final ListSerializer<ForgerBox> forgerBoxListSerializer;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper epochKey(int epoch) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("epoch").append(epoch).toString()));
    }

    public ByteArrayWrapper forgerBoxesKey() {
        return this.forgerBoxesKey;
    }

    public int maxNumberOfStoredEpochs() {
        return this.maxNumberOfStoredEpochs;
    }

    public ListSerializer<ForgingStakeMerklePathInfo> forgingStakeMerklePathInfoListSerializer() {
        return this.forgingStakeMerklePathInfoListSerializer;
    }

    public ListSerializer<ForgerBox> forgerBoxListSerializer() {
        return this.forgerBoxListSerializer;
    }

    private ByteArrayWrapper nextVersion() {
        byte[] version = new byte[32];
        Option<ByteArrayWrapper> option = this.lastVersionId();
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper lastVersion = (ByteArrayWrapper)some.value();
            new Random(lastVersion.hashCode()).nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Random$.MODULE$.nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return new ByteArrayWrapper(version);
    }

    public Try<ForgingBoxesInfoStorage> updateForgingStakeMerklePathInfo(int epoch, Seq<ForgingStakeMerklePathInfo> boxMerklePathInfoSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxMerklePathInfoSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of boxMerklePathInfoSeq to append must be NOT NULL. Use empty Seq instead.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            removeList.add(this.epochKey(BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)(epoch - this.maxNumberOfStoredEpochs())), package.Tagger$.MODULE$.baseRaw()))));
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.epochKey(epoch), new ByteArrayWrapper(this.forgingStakeMerklePathInfoListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(boxMerklePathInfoSeq).asJava()))));
            $this.storage.update(this.nextVersion(), updateList, removeList);
            return this;
        });
    }

    public Try<ForgingBoxesInfoStorage> updateForgerBoxes(ByteArrayWrapper version, Seq<ForgerBox> forgerBoxesToAppendSeq, Seq<byte[]> boxIdsRemoveSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            Seq currentForgerBoxSeq = (Seq)this.getForgerBoxes().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            Seq existentForgerBoxSeq = (Seq)currentForgerBoxSeq.filterNot((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)boxIdsRemoveSeq.exists((Function1 & Serializable & scala.Serializable)removedId -> BoxesRunTime.boxToBoolean((boolean)ForgingBoxesInfoStorage.$anonfun$updateForgerBoxes$4(box, removedId)))));
            Seq newForgerBoxSeq = (Seq)existentForgerBoxSeq.$plus$plus((GenTraversableOnce)forgerBoxesToAppendSeq, Seq$.MODULE$.canBuildFrom());
            Object object = existentForgerBoxSeq.size() != currentForgerBoxSeq.size() || forgerBoxesToAppendSeq.nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerBoxesKey(), new ByteArrayWrapper(this.forgerBoxListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(newForgerBoxSeq).asJava()))))) : BoxedUnit.UNIT;
            $this.storage.update(version, toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<Seq<ForgerBox>> getForgerBoxes() {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgerBoxesKey())));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = this.forgerBoxListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List forgerBoxes = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(forgerBoxes).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while forger boxes list parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<ForgingStakeMerklePathInfo>> getForgingStakeMerklePathInfoForEpoch(int epoch) {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.epochKey(epoch))));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = this.forgingStakeMerklePathInfoListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List boxMerklePathsInfo = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(boxMerklePathsInfo).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while box merkle paths info parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<ForgingBoxesInfoStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public int numberOfVersions() {
        return this.storage.numberOfVersions();
    }

    public static final /* synthetic */ boolean $anonfun$updateForgerBoxes$4(ForgerBox box$1, byte[] removedId) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(box$1.id())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(removedId));
    }

    public ForgingBoxesInfoStorage(Storage storage) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.forgerBoxesKey = new ByteArrayWrapper(Blake2b256$.MODULE$.hash("forgerBoxesKey".getBytes(StandardCharsets.UTF_8)));
        this.maxNumberOfStoredEpochs = 3;
        this.forgingStakeMerklePathInfoListSerializer = new ListSerializer<ForgingStakeMerklePathInfo>(ForgerBoxMerklePathInfoSerializer$.MODULE$);
        this.forgerBoxListSerializer = new ListSerializer<ForgerBox>(ForgerBoxSerializer.getSerializer());
    }
}

