/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utxo.backup.BoxIterator;
import io.horizen.utxo.companion.SidechainBoxesCompanion;
import java.util.ArrayList;
import java.util.List;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0003\u0006\u0001'!A1\u0002\u0001B\u0001B\u0003%!\u0004\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u0011!9\u0003A!A!\u0002\u0013\t\u0003\"\u0002\u0015\u0001\t\u0003I\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"\u0002&\u0001\t\u0003Y\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B,\u0001\t\u0003A&!\u0004\"bG.,\bo\u0015;pe\u0006<WM\u0003\u0002\f\u0019\u000591\u000f^8sC\u001e,'BA\u0007\u000f\u0003\u0011)H\u000f_8\u000b\u0005=\u0001\u0012a\u00025pe&TXM\u001c\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037ui\u0011\u0001\b\u0006\u0003\u00179I!A\b\u000f\u0003\u000fM#xN]1hK\u000692/\u001b3fG\"\f\u0017N\u001c\"pq\u0016\u001c8i\\7qC:LwN\\\u000b\u0002CA\u0011!%J\u0007\u0002G)\u0011A\u0005D\u0001\nG>l\u0007/\u00198j_:L!AJ\u0012\u0003/MKG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0017\u0001G:jI\u0016\u001c\u0007.Y5o\u0005>DXm]\"p[B\fg.[8oA\u00051A(\u001b8jiz\"2A\u000b\u0017.!\tY\u0003!D\u0001\u000b\u0011\u0015YA\u00011\u0001\u001b\u0011\u0015yB\u00011\u0001\"\u0003\u0019)\b\u000fZ1uKR\u0019\u0001G\u000e \u0011\u0007E\"$&D\u00013\u0015\t\u0019d#\u0001\u0003vi&d\u0017BA\u001b3\u0005\r!&/\u001f\u0005\u0006o\u0015\u0001\r\u0001O\u0001\bm\u0016\u00148/[8o!\tID(D\u0001;\u0015\tYd\"A\u0003vi&d7/\u0003\u0002>u\t\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM\u001d\u0005\u0006\u007f\u0015\u0001\r\u0001Q\u0001\u000eE>DHk\\*bm\u0016d\u0015n\u001d;\u0011\u0007\u0005+u)D\u0001C\u0015\t\u00194IC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u0013%\u0001\u0002'jgR\u0004B!\u000f%9q%\u0011\u0011J\u000f\u0002\u0005!\u0006L'/\u0001\bhKR\u0014u\u000e_%uKJ\fGo\u001c:\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u0007\u0002\r\t\f7m[;q\u0013\t\tfJA\u0006C_bLE/\u001a:bi>\u0014\u0018aB5t\u000b6\u0004H/_\u000b\u0002)B\u0011Q#V\u0005\u0003-Z\u0011qAQ8pY\u0016\fg.A\u0003dY>\u001cX-F\u0001Z!\t)\",\u0003\u0002\\-\t!QK\\5u\u0001")
public class BackupStorage {
    private final Storage storage;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;

    public SidechainBoxesCompanion sidechainBoxesCompanion() {
        return this.sidechainBoxesCompanion;
    }

    public Try<BackupStorage> update(ByteArrayWrapper version, List<Pair<ByteArrayWrapper, ByteArrayWrapper>> boxToSaveList) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            Predef$.MODULE$.require(boxToSaveList != null, (Function0 & java.io.Serializable & Serializable)() -> "List of WalletBoxes to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxToSaveList.contains(null), (Function0 & java.io.Serializable & Serializable)() -> "WalletBox to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxToSaveList.isEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "List of WalletBoxes to add/update must be NOT EMPTY.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            $this.storage.update(version, boxToSaveList, removeList);
            return this;
        });
    }

    public BoxIterator getBoxIterator() {
        return new BoxIterator(this.storage.getIterator(), this.sidechainBoxesCompanion());
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public void close() {
        this.storage.close();
    }

    public BackupStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        Predef$.MODULE$.require(storage != null, (Function0 & java.io.Serializable & Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & java.io.Serializable & Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
    }
}

