/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.box.data;

import io.horizen.proposition.Proposition;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.AbstractBox;
import io.horizen.utxo.box.data.BoxData;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractBoxData<P extends Proposition, B extends AbstractBox<P, BD, B>, BD extends AbstractBoxData<P, B, BD>>
implements BoxData<P, B> {
    private final P proposition;
    private final long value;

    public AbstractBoxData(P proposition, long value) {
        Objects.requireNonNull(proposition, "proposition must be defined");
        this.proposition = proposition;
        this.value = value;
    }

    @Override
    public final long value() {
        return this.value;
    }

    @Override
    public final P proposition() {
        return this.proposition;
    }

    @Override
    public byte[] customFieldsHash() {
        return Utils.ZEROS_HASH;
    }

    public int hashCode() {
        return Objects.hash(this.proposition(), this.value(), Arrays.hashCode(this.customFieldsHash()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractBoxData boxData = (AbstractBoxData)obj;
        return this.proposition().equals(boxData.proposition()) && this.value() == boxData.value() && Arrays.equals(this.customFieldsHash(), boxData.customFieldsHash());
    }
}

