/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import io.horizen.consensus.ConsensusEpochAndSlot;
import io.horizen.consensus.ConsensusParamsUtil$;
import io.horizen.consensus.package$;
import io.horizen.fork.ConsensusParamsFork$;
import io.horizen.fork.ConsensusParamsForkInfo;
import io.horizen.utils.BlockConsensusForkInformation;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class TimeToEpochUtils$ {
    public static TimeToEpochUtils$ MODULE$;

    static {
        new TimeToEpochUtils$();
    }

    public long epochInSeconds(int consensusSecondsInSlot, int consensusSlotsInEpoch) {
        return Math.multiplyExact(consensusSlotsInEpoch, consensusSecondsInSlot);
    }

    public long virtualGenesisBlockTimeStamp(long sidechainGenesisBlockTimestamp) {
        return sidechainGenesisBlockTimestamp - this.epochInSeconds(((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSecondsInSlot(), ((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSlotsInEpoch()) + (long)((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSecondsInSlot();
    }

    public ConsensusEpochAndSlot timestampToEpochAndSlot(long sidechainGenesisBlockTimestamp, long timestamp) {
        return new ConsensusEpochAndSlot(this.timeStampToEpochNumber(sidechainGenesisBlockTimestamp, timestamp), this.timeStampToSlotNumber(sidechainGenesisBlockTimestamp, timestamp));
    }

    public int timeStampToEpochNumber(long sidechainGenesisBlockTimestamp, long timestamp) {
        return package$.MODULE$.intToConsensusEpochNumber(this.getEpochIndex(sidechainGenesisBlockTimestamp, timestamp));
    }

    public int timeStampToSlotNumber(long sidechainGenesisBlockTimestamp, long timestamp) {
        Predef$.MODULE$.require(timestamp >= sidechainGenesisBlockTimestamp, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(76).append("Try to get index epoch for timestamp ").append(timestamp).append(" which are less than genesis timestamp ").append(sidechainGenesisBlockTimestamp).toString());
        BlockConsensusForkInformation blockConsensusForkInformation = this.getConsensusInformationFromTimestamp(timestamp, timestamp);
        long slotIndex = blockConsensusForkInformation.secondsInFork() % this.epochInSeconds(blockConsensusForkInformation.lastConsensusFork().consensusParamsFork().consensusSecondsInSlot(), blockConsensusForkInformation.lastConsensusFork().consensusParamsFork().consensusSlotsInEpoch()) / (long)blockConsensusForkInformation.lastConsensusFork().consensusParamsFork().consensusSecondsInSlot();
        return package$.MODULE$.intToConsensusSlotNumber((int)slotIndex + 1);
    }

    public int timeStampToAbsoluteSlotNumber(long sidechainGenesisBlockTimestamp, long timestamp) {
        int n;
        if (ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork() > 1) {
            int epoch = this.getEpochIndex(sidechainGenesisBlockTimestamp, timestamp);
            int slot = this.timeStampToSlotNumber(sidechainGenesisBlockTimestamp, timestamp);
            Seq<ConsensusParamsForkInfo> forks = ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation();
            int forkIndex = 1;
            ConsensusParamsForkInfo fork = (ConsensusParamsForkInfo)forks.apply(forkIndex);
            ConsensusParamsForkInfo previousFork = (ConsensusParamsForkInfo)forks.apply(forkIndex - 1);
            int absoluteSlotNumber = 0;
            while (epoch > fork.activationEpoch() && forkIndex < ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) {
                absoluteSlotNumber += (fork.activationEpoch() - previousFork.activationEpoch()) * previousFork.consensusParamsFork().consensusSlotsInEpoch();
                if (++forkIndex >= ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) continue;
                previousFork = fork;
                fork = (ConsensusParamsForkInfo)forks.apply(forkIndex);
            }
            ConsensusParamsForkInfo lastFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().apply(forkIndex - 1);
            absoluteSlotNumber = absoluteSlotNumber + (epoch - lastFork.activationEpoch()) * lastFork.consensusParamsFork().consensusSlotsInEpoch() + slot;
            n = package$.MODULE$.intToConsensusAbsoluteSlotNumber(absoluteSlotNumber);
        } else {
            int slotNumber = this.timeStampToEpochNumber(sidechainGenesisBlockTimestamp, timestamp) * ConsensusParamsFork$.MODULE$.DefaultConsensusParamsFork().consensusSlotsInEpoch() + this.timeStampToSlotNumber(sidechainGenesisBlockTimestamp, timestamp);
            n = package$.MODULE$.intToConsensusAbsoluteSlotNumber(slotNumber);
        }
        return n;
    }

    public long getTimeStampForEpochAndSlot(long sidechainGenesisBlockTimestamp, int epochNumber, int slotNumber) {
        long l;
        Predef$.MODULE$.require(slotNumber <= ConsensusParamsFork$.MODULE$.get(epochNumber).consensusSlotsInEpoch());
        if (ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork() > 1) {
            int currentForkIndex = 1;
            ConsensusParamsForkInfo currentFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().apply(currentForkIndex);
            ConsensusParamsForkInfo previousFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().apply(currentForkIndex - 1);
            long previousAccumulatedSecondsPerFork = 0L;
            long accumulatedSecondsPerFork = (long)currentFork.activationEpoch() * this.epochInSeconds(previousFork.consensusParamsFork().consensusSecondsInSlot(), previousFork.consensusParamsFork().consensusSlotsInEpoch());
            while (epochNumber > currentFork.activationEpoch() - 1 && currentForkIndex < ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) {
                previousAccumulatedSecondsPerFork = accumulatedSecondsPerFork;
                if (++currentForkIndex >= ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) continue;
                previousFork = currentFork;
                currentFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().apply(currentForkIndex);
                accumulatedSecondsPerFork += (long)(currentFork.activationEpoch() - previousFork.activationEpoch()) * this.epochInSeconds(previousFork.consensusParamsFork().consensusSecondsInSlot(), previousFork.consensusParamsFork().consensusSlotsInEpoch());
            }
            ConsensusParamsForkInfo lastFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().apply(currentForkIndex - 1);
            int epochInCurrentFork = epochNumber - lastFork.activationEpoch() - 1;
            long accumulatedSecondsPerEpoch = previousAccumulatedSecondsPerFork + (long)(epochInCurrentFork + 1) * this.epochInSeconds(lastFork.consensusParamsFork().consensusSecondsInSlot(), lastFork.consensusParamsFork().consensusSlotsInEpoch()) + (long)((slotNumber - 1) * lastFork.consensusParamsFork().consensusSecondsInSlot()) - this.epochInSeconds(((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSecondsInSlot(), ((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSlotsInEpoch());
            l = this.virtualGenesisBlockTimeStamp(sidechainGenesisBlockTimestamp) + accumulatedSecondsPerEpoch;
        } else {
            ConsensusParamsForkInfo defaultConsensusParamsFork = (ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head();
            int totalSlots = (epochNumber - 1) * defaultConsensusParamsFork.consensusParamsFork().consensusSlotsInEpoch() + (slotNumber - 1);
            l = this.virtualGenesisBlockTimeStamp(sidechainGenesisBlockTimestamp) + (long)(totalSlots * defaultConsensusParamsFork.consensusParamsFork().consensusSecondsInSlot());
        }
        return l;
    }

    public long secondsRemainingInSlot(long sidechainGenesisBlockTimestamp, long timestamp) {
        int consensusSecondsInSlot = ConsensusParamsUtil$.MODULE$.getConsensusSecondsInSlotsPerEpoch(sidechainGenesisBlockTimestamp, timestamp);
        long secondsElapsedInSlot = (timestamp - this.virtualGenesisBlockTimeStamp(sidechainGenesisBlockTimestamp)) % (long)consensusSecondsInSlot;
        return (long)consensusSecondsInSlot - secondsElapsedInSlot;
    }

    private int getEpochIndex(long sidechainGenesisBlockTimestamp, long timestamp) {
        Predef$.MODULE$.require(timestamp >= sidechainGenesisBlockTimestamp, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(76).append("Try to get index epoch for timestamp ").append(timestamp).append(" which are less than genesis timestamp ").append(sidechainGenesisBlockTimestamp).toString());
        long refinedTimestamp = timestamp - (long)((ConsensusParamsForkInfo)ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation().head()).consensusParamsFork().consensusSecondsInSlot();
        BlockConsensusForkInformation blockConsensusForkInformation = this.getConsensusInformationFromTimestamp(timestamp, refinedTimestamp);
        return blockConsensusForkInformation.ForkStartingEpoch() + (int)(blockConsensusForkInformation.secondsInFork() / this.epochInSeconds(blockConsensusForkInformation.lastConsensusFork().consensusParamsFork().consensusSecondsInSlot(), blockConsensusForkInformation.lastConsensusFork().consensusParamsFork().consensusSlotsInEpoch()));
    }

    private BlockConsensusForkInformation getConsensusInformationFromTimestamp(long timestamp, long refinedTimestamp) {
        int startingEpoch = 0;
        int forkIndex = 0;
        Seq<ConsensusParamsForkInfo> forks = ConsensusParamsUtil$.MODULE$.getConsensusParamsForkActivation();
        Seq<Object> activationForksTimestamp = ConsensusParamsUtil$.MODULE$.getConsensusParamsForkTimestampActivation();
        ConsensusParamsForkInfo fork = (ConsensusParamsForkInfo)forks.apply(forkIndex);
        long forkActivationTimestamp = BoxesRunTime.unboxToLong((Object)activationForksTimestamp.apply(forkIndex));
        while (refinedTimestamp > forkActivationTimestamp && forkIndex < ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) {
            startingEpoch = fork.activationEpoch();
            if (++forkIndex >= ConsensusParamsUtil$.MODULE$.numberOfConsensusParamsFork()) continue;
            fork = (ConsensusParamsForkInfo)forks.apply(forkIndex);
            forkActivationTimestamp = BoxesRunTime.unboxToLong((Object)activationForksTimestamp.apply(forkIndex));
        }
        ConsensusParamsForkInfo lastFork = (ConsensusParamsForkInfo)forks.apply(Math.max(forkIndex - 1, 0));
        long lastForkActivationTimestamp = BoxesRunTime.unboxToLong((Object)activationForksTimestamp.apply(Math.max(forkIndex - 1, 0)));
        long timestampMinusSlot = timestamp - (long)lastFork.consensusParamsFork().consensusSecondsInSlot();
        long secondsInFork = timestampMinusSlot - lastForkActivationTimestamp + (long)lastFork.consensusParamsFork().consensusSecondsInSlot();
        if (lastFork.activationEpoch() == 0) {
            ++startingEpoch;
        }
        return new BlockConsensusForkInformation(secondsInFork, startingEpoch, lastFork);
    }

    private TimeToEpochUtils$() {
        MODULE$ = this;
    }
}

